/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#include <stdio.h>
#include <string.h>
#include "buffer.h"
#include "ins.h"
#include "misc.h"
#include "paste.h"

/* swap CLine and CLine->prev */
/* Note that marks are not updated here */
void swap_lines()
{
    Line *prev;
    unsigned char *p;

    /* check for end of line char */
    p = CLine->data + ( CLine->len - 1 );
    if ((CLine->len == 0) || (*p != '\n'))
      {
	 eol();
	 ins('\n');
      }

    prev = CLine->prev;
    if (prev == NULL) return;

    if (prev->prev != NULL) prev->prev->next = CLine;
    if (CLine->next != NULL) CLine->next->prev = prev;

    prev->next = CLine->next;
    CLine->prev = prev->prev;
    CLine->next = prev;
    prev->prev = CLine;

    /* better swap this too */
    if (CBuf->end == CLine) CBuf->end = prev;
    if (CBuf->beg == prev) CBuf->beg = CLine;
}

/* breaks line at current point leaving point at end of current line */

int split_line()
{
    int size;

    if (CLine == NULL)
      {
          exit_error("split_line: Null Line");
      }
    size = CLine->len - Point;

    if (NULL == make_line(size + 1))
      {
	  exit_error("Allocation Failure in split_line.");
      }

    strncpy((char *) CLine->data,
            (char *) (CLine->prev->data + Point), size);
    CLine->len = size;
    CLine = CLine->prev;
    CLine->len = Point;
    /* now update the marks */
    update_marks(NLINSERT, 1);
    return(0);
}

void splice_line()
{
    int n1, n2;

    if (CLine->next == NULL)
      {
         exit_error("splice line: next line is Null!");
      }
   push_spot();
   n1 = CLine->len;
   n2 = CLine->next->len;

   if (n1 + n2 > CLine->space) remake_line(n1 + n2 + 1);
   strncpy((char *) (CLine->data + Point), (char *) CLine->next->data, n2);
   CLine->len = n1 + n2;

   CLine = CLine->next;
   update_marks(NLDELETE, 1);
   delete_line();
   pop_spot();
}

