;;
;;  Site specific initialiation file.
;;  Should be placed in the JED_LIBRARY directory.
;;
;;   What is in here:
;;
;;    1. hooks:  mode_hook --- defines what mode to go in when a file is loaded
;;       Jed looks for other hooks as well:
;;           suspend_hook  --- function to be executed before suspending
;;           resume_hook   --- function that gets carried out after suspendion
;;           exit_hook     --- gets executed before exit
;;       
;;       see also jed.rc for more hooks.
;;
;;        For example, to prohibit suspension, simple define
;;          ("Suspension Prohibited!"  error) suspend_hook
;;
;;        The resume hook is useful for systems like VMS.  It could  read
;;        a logical (getenv) and load the file associated with it, something
;;        like:
;;               ( [file]
;;                 "JED_FILE" getenv =file
;;                 file strlen {return} !if
;;                 file find_file {"File not found!" error} !if
;;               ) resume_hook
;;
;;         However, on VMS, this is already built into the underlying C code
;;         so the above hook is redundant but you get the idea!
;;
;;    2. A simple find all occurances function-- called occur
;;    3. autoloads:  files to autoload when certain functions are called
;;    4. Miscellaneous functions

;; This sets terminals to vt320 on vt320s of course: 
;;"\e[63;1\"p"  tt_send


;;
;;  Autoloads
;;


"lpr"		"lpr.sl"	autoload
"help"		"help.sl"	autoload  "help" "^H^H"  setkey
"list_buffers"	"buf.sl"	autoload  "list_buffers" "^X^B" setkey
"sort"		"sort.sl"	autoload
"untab"		"untab.sl"	autoload
"save_buffers"	"buf.sl"	autoload  "save_buffers" "^Xs"  setkey
"rot13"		"rot13.sl"	autoload

"shell"		"shell.sl"	autoload

  "find_tag"	"ctags.sl"	autoload  "find_tag"	"^[."	setkey
"_UNIX" defined? {
  "unix_man"	"man.sl"	autoload  "unix_man" 	"^Hm"	setkey
  "mail"	"mail.sl"	autoload
  "rmail"	"rmail.sl"	autoload
  "ispell"	"ispell.sl"	autoload "ispell"	"^[$"	setkey
  "do_shell_cmd" "unix.sl"	autoload
} if 
 
"_IBMPC"  defined? {
  "do_shell_cmd" "ibmpc.sl"	autoload
} if

"_VMS"  defined? {
  "do_shell_cmd" "vms.sl"	autoload
} if

 "do_shell_cmd" "^[!" setkey

;; A useful hooks function---
;; There is a builtin one in slang as well that is called from C code
( [hook_fun] =hook_fun
  hook_fun defined? { hook_fun eval } if
) runhooks


;; These commands are better off in the jed.rc (.jedrc) file:
;; this next command changes to emacs keybindings:
;; "emacs.sl" evalfile

;; For other popular editors:  
;;  "edt.sl" evalfile
;;  "wordstar.sl" evalfile    ;; does not exist yet
;;  etc...


;; define a fortran macro to load fortran.sl
(
   [f] "Fortran" =f
   "Fortran_Mode" defined?
      {1} { "fortran.sl" evalfile }
      else { f use_keymap
             f setmode
	   } if
) fortran

(
   "DCL_Mode" defined? 
      {1} { "dcl.sl" evalfile } else
      {"DCL" use_keymap
       "dcl" setmode } if
) dcl

;;; scroll other window macros-- bind them yourself
( nwindows 1 -
  otherwindow
  "page_up" call
  { otherwindow } loop
) next_wind_up  
;; "next_wind_up"  "^W^[[A"  setkey
  
( nwindows 1 -
  otherwindow
  "page_down" call
  { otherwindow } loop
) next_wind_dn 
;; "next_wind_dn" "^W^[[B"  setkey




;; some file hooks
(
  {"c"   strcmp not : "cmode" setmode }
  {"h"   strcmp not : "cmode" setmode }
  {"tex" strcmp not : "wrap" setmode }
  {"txt" strcmp not : "wrap" setmode }
  {"doc" strcmp not : "wrap" setmode }
  {"f"   strcmp not : fortran }
  {"for" strcmp not : fortran }
  {"com" strcmp not "_VMS" defined? and : dcl }
  {"sl"  strcmp not : "nomode" setmode }
  {"rc"  strcmp not : "nomode" setmode }
  {pop "wrap" setmode} ;;  default
  switch
) mode_hook

;; sets buf modified flag
(
   [mod] =mod
   getbuf_info
   mod { 1 | }{1 ~ &} else
   setbuf_info
) set_buffer_modified_flag


;; apropos function

( [n cbuf]

  "apropos:" "" read_mini
  slapropos =n
  
  whatbuf =cbuf
  "*apropos*" pop2buf erase_buffer
  
  {n}{ 
    0 4 1 { 
       14 * 1 + goto_column 
       eolp {n 1 - =n insert } if
       n {break} !if
    } for
    "\n" insert
  } while
  bob
  0 set_buffer_modified_flag
  cbuf pop2buf
) apropos

;;
;; most hook
;;


( "Most" defined? { "most.sl" evalfile } !if
  "most" setmode
  "Most_Map" use_keymap
  "'Q' quits MOST file viewing mode." message
) most

( "( pop most ) mode_hook" eval ) do_most


;; occur function
;;
(
  [str cbuf tmp]  ;; local variables
  "Find All:" "" read_mini =str
  "*occur*" =tmp whatbuf =cbuf
  tmp bufferp { tmp delbuf } if
  push_spot
  {str fsearch}
    {
       whatline string 
       push_mark
       narrow
       tmp setbuf
       insert 5 goto_column ":"  insert
       cbuf insbuf "\n" insert
       cbuf setbuf
       widen
       eol             ;; so we do not find another occurance on same line
    } while
    pop_spot
    ;; did we make it
    tmp bufferp { tmp pop2buf bob } if
 ) occur 


( "Line:" whatline string strcat
  " Column:" what_column string strcat strcat message ) whatpos
  
  "whatpos" "^X?" setkey
  
  "showkey" "^HC" setkey 
  "apropos" "^HA" setkey
  
;;
;;  utility routines
;;
"trim_buffer"	"util.sl"	autoload   ;; trims excess lines and space
"bol_fsearch"	"util.sl"	autoload
"bol_bsearch"	"util.sl"	autoload
"dircat"	"util.sl"	autoload


;;
;;  This next function requires a doc file to be produced.  This is made
;;  by loading mkdoc.sl  which is a batch file.  Simply do: 
;;    
;;      jed -l mkdoc.sl
;;
;;  to produce it. It should be placed in JED_LIBRARY.
;;


( 
  [tmp help f cbuf]  " *tmp*" =tmp "*help*" =help  whatbuf =cbuf
  "Enter Function:" "" read_mini =f
  f strlen {return} !if
  tmp setbuf  "JED_LIBRARY" getenv "jed_funs.hlp" dircat
  insert_file 0 < {"doc file not found." error} if
  bob "@" f strcat
  fsearch {"Function not found." error} !if
  push_mark "@" bol_fsearch {eob} !if
  help setbuf erase_buffer
  tmp setbuf
  help copy_region
  tmp delbuf
  help pop2buf bob
  "@" looking_at {del} if {1 down}{bol ";;" looking_at {del del} if} while
  bob
  0 set_buffer_modified_flag
  cbuf pop2buf
) help_fun       "help_fun" "^Hf" setkey
  

;; exch was removed for some reason
(
   [x y] =x  =y x y 
) exch
