
	TITLE	OVERLAY
;
; define all the segments in order
;
OVERLAY_TEXT	SEGMENT  WORD PUBLIC 'CODE'
OVERLAY_TEXT	ENDS
;
CONST	SEGMENT  WORD PUBLIC 'CONST'
CONST	ENDS
;
_BSS	SEGMENT  WORD PUBLIC 'BSS'
_BSS	ENDS
;
_DATA	SEGMENT  WORD PUBLIC 'DATA'
	extrn	_stktop:word
_DATA	ENDS
;
DGROUP	GROUP	CONST,	_BSS,	_DATA
	ASSUME  CS: OVERLAY_TEXT, DS: DGROUP, SS: DGROUP, ES: DGROUP
;
;**********************************************
;**********************************************
; uncomment this to get overlays working again
;**********************************************
;	EXTRN	_overlayDriver:FAR
;**********************************************
;**********************************************
;
OVERLAY_TEXT	SEGMENT  WORD PUBLIC 'CODE'
;
	PUBLIC	_overlay
_overlay PROC	FAR
;
; save all the registers on entry
;
	push	bp
	mov	bp,sp
;
; save registers
;
	mov	cs:oldds,ds
	mov	cs:oldes,es
	mov	cs:oldss,ss
;
; set up the interrupt
;
	mov	ah,25H		; set interrupt vector
	mov	al,[bp+6]	; interrupt vector to use
				; dx gets offset of the int handler
	mov	dx,OFFSET OVERLAY_TEXT:intProc
	push	ds		; save ds
	push	cs		; move cs to ds for set interrupt call
	pop	ds
	int	21H		; set up the interrupt
	pop	ds		; restore ds
;
; return
;
	mov	sp,bp
	mov	ax,sp		; return value
	pop	bp
	ret
;
_overlay ENDP
;
;
;************************ _criterr *************************
;
	PUBLIC	_criterr
_criterr PROC	FAR
;
; save all the registers on entry
;
	push	bp
	mov	bp,sp
;
; set up the interrupt
;
	mov	ah,25H		; set interrupt vector
	mov	al,24H		; interrupt vector to use
	mov	dx,OFFSET OVERLAY_TEXT:criProc
	push	ds		; save ds
	push	cs		; move cs to ds for set interrupt call
	pop	ds
	int	21H		; set up the interrupt
	pop	ds		; restore ds
;
; return
;
	mov	sp,bp
	mov	ax,sp		; return value
	pop	bp
	ret
;
_criterr ENDP
;
;
;
criProc PROC	FAR
;
	pop	ax	; discard DOS IP
	pop	ax	; discard DOS CS
	pop	ax	; discard DOS flags

	mov	ah,19H	; stablize DOS with a dummy call to function 19
	int	21H	;  (get current drive) which cannot cause an error

	pop	ax	; restore application's registers
	pop	bx
	pop	cx
	pop	dx
	pop	si
	pop	di
	pop	bp
	pop	ds
	pop	es
	push	bp	; set the carry flag (on the stack)
	mov	bp,sp
	or	WORD PTR [bp+6],1
	pop	bp
	mov	ax,97	; Point-defined error code 97 ==> critical error
	iret
;
criProc ENDP
;
;
;************************ _getstk *************************
;
;
	public	_getstk
_getstk	PROC	far
	mov	dx,ss
	mov	ax,sp
	ret
_getstk	endp
	public	_gethqq
	extrn	STKHQQ:word
_gethqq	PROC	far
	mov	ax,STKHQQ
	ret
_gethqq	endp
;
;
;
oldds		DW	0
oldes		DW	0
oldss		DW	0
;
;
myStackPtr	DW	0
savess1		DW	0
savesp1		DW	0
savess2		DW	0
savesp2		DW	0
;
intProc PROC	FAR
;
; save all the registers on entry
;
	push	ds		; onto the caller's stack
	mov	ds,cs:oldds	; restore ds addressability
	cmp	myStackPtr,0	; determine save stack (ss,sp) area
	je	firstCall	; this is the first call
secondCall:
	mov	savess2,ss	; use the second area
	mov	savesp2,sp
	jmp	setupStack
firstCall:
	mov	savess1,ss
	mov	savesp1,sp
;
; set up the new stack frame
;
setupStack:
	inc	myStackPtr
	mov	ss,oldss
	mov	sp,_stktop
;
; call the C procedure
; pass it all the registers
;
;
	push	es
	mov	es,oldes
	push	bp
	push	di
	push	si
	push	dx
	push	cx
	push	bx
	push	ax
	sti		; re-enable interrupts since this may take awhile
			; we know that no one will make this interrupt call
			; while we are doing this since this is a software
			; interrupt
;**********************************************
;**********************************************
; uncomment this to get overlays working again
;**********************************************
;	call	FAR PTR _overlayDriver
;**********************************************
;**********************************************
;
; now restore the registers with their new values
; this gets the affect of call by value-result
; disable interrupts while we are changing the stack
;
	cli
	pop	ax
	pop	bx
	pop	cx
	pop	dx
	pop	si
	pop	di
	pop	bp
	pop	es
;
; return
;
	dec	myStackPtr
	jz	retFirstCall
retSecondCall:
	mov	sp,savesp2
	mov	ss,savess2
	jmp	retAll
retFirstCall:
	mov	sp,savesp1
	mov	ss,savess1
	mov	myStackPtr,0
retAll:
	pop	ds
	iret
;
intProc ENDP
;
OVERLAY_TEXT	ENDS
END
