/***********************************************************************/
/* MANEXT - Extract manual pages from C source code.                   */
/***********************************************************************/
/*
 * MANEXT - A program to extract manual pages from C source code.
 * Copyright (C) 1991,1992 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@itc.gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 7877
 * QLD 4121
 * Australia
 */
#include <stdio.h>

void display_info();

/*---------------------------------------------------------------------*/
/* Following are for getopt function(s).                               */
/*---------------------------------------------------------------------*/
extern char *optarg;
extern int optind;

#define MAX_LINE 255

/***********************************************************************/
int main(argc,argv)
int argc;
char *argv[];
/***********************************************************************/
{
 char    s[MAX_LINE + 1];        /* input line */
 register int     i = 0;
 FILE *fp,*fpo;
 char outfile[MAX_LINE+1];
 char c;
 strcpy(outfile,"");

 while ((c = getopt(argc,argv,"h?o:")) != (-1))
   switch(c)
     {
      case 'o':        /* profile file name */
	       strcpy(outfile,optarg);
	       break;
      default:
               display_info();
	       exit(1);
	       break;
     }
 if (strcmp(outfile,"") == 0)
   {
    fprintf(stderr,"\nNo output file name specified\n");
    exit(1);
   }

 if ((fpo = fopen(outfile,"w")) == NULL)
   {
    fprintf(stderr,"\nCould not open %s for output\n",outfile);
    exit(1);
   }

 while(optind<argc)
    {
     if ((fp = fopen(argv[optind],"r")) == NULL)
       {
        fprintf(stderr,"\nCould not open %s\n",argv[optind]);
        continue;
       }
     while(1)
       {
        if (fgets(s, (int)sizeof(s), fp) == NULL)
          {
	   if (ferror(fp) != 0)
             {
              fprintf(stderr, "*** Error reading %s.  Exiting.\n",argv[optind]);
              exit(1);
             }
	   break;
          }

        /* check for manual entry marker at beginning of line */
        if (strncmp(s, "/*man-start*", 12) != 0)
            continue;

        /* inner loop */
        for (;;)
           {
            /* read next line of manual entry */
	    if (fgets(s, (int)sizeof(s), fp) == NULL)
              {
	       if (ferror(fp) != 0)
		 {
		  fprintf(stderr, "*** Error reading %s.  Exiting.\n",argv[optind]);
		  exit(1);
		 }
		break;
	      }
	    /* check for end of entry marker */
	    if (strncmp(s, "**man-end", 9) == 0)
	       break;

	    fprintf(fpo,"     %s",s);
            }
	fputs("\n\n\n     --------------------------------------------------------------------------\n", fpo);

        /* check if end of file */
        if (feof(fp) != 0)
            break;
       }
     fclose(fp);
     optind++;
    }
 fputs("\n\n\n\n\n", fpo);
 fclose(fpo);
 return(0);
}
/***********************************************************************/
void display_info()
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/

 fprintf(stderr,"\nMANEXT 1.00 Copyright (C) 1991,1992 Mark Hessling\n");
 fprintf(stderr,"All rights reserved.\n");
 fprintf(stderr,"MANEXT is distributed under the terms of the GNU\n");
 fprintf(stderr,"General Public License and comes with NO WARRANTY.\n");
 fprintf(stderr,"See the file COPYING for details.\n");
 fprintf(stderr,"\nUsage: MANEXT -o outfilename sourcefile [...]\n\n");
 fflush(stderr);
 return;
}
