program trived;  {trivial editor}

{

KNOWN SHORTCOMINGS (but don't let them scare you away)

unable to search
unable to search regexp's
unable to replace
single-file (possible feature)
  unable to yank in parts of files in a specific directory (if provided)
limited to 400 79-column lines
insert is only one line at a time
takes minimal advantage of terminal capabilities (possible feature)
ansi/vt100 hardwired in for cursor movement, clear screen, clear to end of line
implements only trivial subset of vi
doesn't implement counters (eg. 15+, 10x) let alone modifiers (eg. d3w)
8-bit non-clean - assumes all input >126 is line noise (easily fixed)

uses vi keystrokes :-)
  (possible feature)


CREDITS:

Bill Joy, for the (incredibly more powerful) vi editor

}

{$undef debug}

{$M 4096,0,2048}

uses dos,crt;

const

  editorname='trived';
  editorversion='0.8';

  maxlines=400;
  lpp=23;

type
  linet=string[79];

var
  lines: array[1..maxlines] of linet;
  port: integer;
  console: boolean;
  filename: string;
  thefile: text;
  numlines: integer;
  done: boolean;
  topline: integer;
  currline: integer;
  currcol: integer;
  counter: integer;
  trusted: boolean;
  minutes: integer;
  minstart: integer;

function mitoday: integer; {minutes into today}

var
  h,m,s,s00: word;

begin
  gettime(h,m,s,s00);
  mitoday := 60*h+m;
end;

{$I rusn-io.pas}

procedure usage;

begin
  xwritelns('trived: usage:');
  xwritelns('  local:  trived filename');
  xwritelns('  fossil (com1): trived minutes filename');
  xwritelns('    eg: (from waffle) trived %O filename');
  xwritelns('  fossil (com2): trived -minutes filename');
  xwritelns('    eg: (from waffle) trived -%O filename');
  halt(1);
end;

function trim(s: string): string;

var
  result: string;

begin
  result := s;
  while ((result[length(result)]=' ') or (result[length(result)]=^I)) and
   (length(result)>0) do
    result := copy(result,1,length(result)-1);
  trim := result;
end;

function unslash(s: string): string;

var
  i: integer;
  result: string;

begin
  result := s;
  for i := 1 to length(result) do
    if result[i]='/' then
      result[i] := '\';
  unslash := result;
end;

function atoi(s: string): integer;

var
  code: word;
  result: integer;

begin
  val(s,result,code);
  atoi := result;
end;

procedure readfile;

var
  wastec: char;

begin
  numlines := 0;
  assign(thefile,filename);
  {$I-}
  reset(thefile);
  {$I+}
  if ioresult<>0 then
    begin
      xwritelnss('trived: could not read file ',filename);
      halt(1);
    end;
  while (numlines<maxlines) and not eof(thefile) do
    begin
      inc(numlines);
      readln(thefile,lines[numlines]);
    end;
  if not eof(thefile) then
    begin
      xwrites('warning: unable to read in complete file: press any key ');
      wastec := xreadkey;
    end;
  close(thefile);

  if numlines=0 then
    begin
      inc(numlines);
      lines[numlines] := '';
    end;
end;

{ --- editing stuff --- }

procedure insertlineat(newl: integer);

var
  i: integer;

begin
  for i := numlines+1 downto newl+1 do
    lines[i] := lines[i-1];
  inc(numlines);
end;

procedure deletelineat(oldl: integer);

var
  i: integer;

begin
  if numlines<2 then
    begin
      lines[1] := '';
      numlines := 1;
    end
  else
    begin
      for i := oldl to numlines-1 do
        lines[i] := lines[i+1];
      dec(numlines);
    end;
end;

procedure delcharat(var s: linet; col: integer);

begin
  if col<=length(s) then
    begin
      if col=1 then
        s := copy(s,2,255)
      else if col=length(s) then
        s := copy(s,1,col-1)
      else
        s := copy(s,1,col-1)+copy(s,col+1,255);
    end;
end;

function botline: integer;

begin
  botline := topline+lpp-3;
end;

function offscreen(lineno: integer): boolean;

begin
  offscreen := (lineno>botline) or (lineno<topline);
end;

procedure restorecurs;

begin
  xgotoxy(currcol,currline-topline+1);
end;

procedure refreshaline(i: integer);

begin
  xclreolxy(1,i);
  xwrites(lines[topline+i-1]);
end;

procedure refreshline;

begin
  refreshaline(currline-topline+1);
  restorecurs;
end;

procedure clrbotliner;

begin
  xclreolxy(1,lpp);
  restorecurs;
end;

procedure fixcol;

begin
  if currcol>length(lines[currline]) then
    begin
      currcol := length(lines[currline]);
      if currcol=0 then
        currcol := 1;
    end;
end;

procedure refreshpart(top, bottom: integer);

var
  i: integer;

begin
  for i := top to bottom do
    if topline+i-1<=numlines then
      refreshaline(i);
  restorecurs;
end;

procedure refreshall;

begin
  xclrscr;
  refreshpart(1,lpp-2);
end;

procedure help;

var
  wastec: char;

begin
  writexy(1,lpp,
   'z=bighelp,q:uit,j=down,k=up,h=left,l=right,x=del,i:ns,r:efresh: any key ');
  wastec := xreadkey;
  clrbotliner;
end;

procedure bighelp;

var
  wastec: char;

begin
  xclrscr;
  xgotoxy(1,1);
  xwritessss('trivial editor: ',editorname,' version ',editorversion);
  writexy(1,3 ,'Russell Schulz      small memory, local+remote use');
  writexy(1,4 ,'russell@alpha3.ersys.edmonton.ab.ca (921205)');
  writexy(1,6 ,'vi cursor keys: h=left, l=right     f=forward page');
  writexy(1,7 ,'                j=down, k=up        b=back page');
  writexy(1,9 ,'x=delete current character');
  writexy(1,10,'i=insert characters at, a=append characters after cursor');
  writexy(1,11,'  enter or esc to exit  (restricted to one line right now.)');
  writexy(1,13,'s=split line after cursor   c=combine line with next');
  writexy(1,14,'o=open a new line below current one (and insert)');
  writexy(1,15,'O=open a new line above current one (and insert)');
  writexy(1,16,'D=delete current line');
  writexy(1,18,'^=start of line   $=end');
  writexy(1,19,'F=top of file  G=bottom        H=top of screen  L=bottom');
  writexy(1,21,'r=refresh screen    w=write and continue editing     q=quit');
  writexy(1,lpp,'press any key ');
  wastec := xreadkey;
  refreshall;
end;

procedure downaline;

begin
  if currline<numlines then
    begin
      inc(currline);
      fixcol;
      if offscreen(currline) then
        begin
          inc(topline);
          refreshall;
        end;
      restorecurs;
    end;
end;

procedure upaline;

begin
  if currline>1 then
    begin
      dec(currline);
      fixcol;
      if offscreen(currline) then
        begin
          dec(topline);
          refreshall;
        end;
      restorecurs;
    end;
end;

procedure rightachar;

begin
  if (currcol<79) and (currcol<length(lines[currline])) then
    begin
      inc(currcol);
      restorecurs;
    end;
end;

procedure leftachar;

begin
  if currcol>1 then
    begin
      dec(currcol);
      restorecurs;
    end;
end;

procedure delchar;

begin
  if currcol<=length(lines[currline]) then
    begin
      delcharat(lines[currline],currcol);

{trivial screen optimization}

      if currcol>length(lines[currline]) then
        begin
          restorecurs;
          xwrites(' ');
          fixcol;
          restorecurs;
        end
      else
        begin
          refreshline;
        end;
    end;
end;

procedure insert;

var
  c: char;
  doneins: boolean;

begin
  doneins := false;
  while (length(lines[currline])<79) and not doneins do
    begin
      c := xreadkey;
      if (c=#8) or (c=#127) then
        begin
          if (currcol>1) and (currcol<=length(lines[currline])+1) then
            begin

{trivial screen optimization if this is last char on line - common case}

              if currcol>length(lines[currline]) then
                begin
                  dec(currcol);
                  delcharat(lines[currline],currcol);
                  xgotoxy(currcol,currline-topline+1);
                  xwrites(' ');
                  restorecurs;
                end
              else
                begin
                  dec(currcol);
                  delcharat(lines[currline],currcol);
                  refreshline;
                end;
            end;
        end
      else if (c=#13) then
        begin
          doneins := true;
        end
      else if (c=#27) then
        begin
          doneins := true;
        end
      else if (ord(c)>=32) and (ord(c)<127) then
        begin

{trivial screen optimization if this is last character - very common case}

          if currcol>length(lines[currline]) then
            begin
              lines[currline] := lines[currline]+c;
              xgotoxy(currcol,currline-topline+1);
              xwrites(c);
              inc(currcol);
            end
          else
            begin
              if currcol=1 then
                lines[currline] := c+lines[currline]
              else
                lines[currline] := copy(lines[currline],1,currcol-1)+c+
                 copy(lines[currline],currcol,255);
              inc(currcol);
              refreshline;
            end;
        end;
  end;
  fixcol;
  restorecurs;
end;

procedure append;

begin
  inc(currcol);
  restorecurs;
  insert;
end;

procedure split;

var
  oldline: string;

begin
  if (numlines<maxlines) and (currcol<length(lines[currline])) then
    begin
      insertlineat(currline+1);
      oldline := lines[currline];
      lines[currline] := copy(oldline,1,currcol);
      lines[currline+1] := copy(oldline,currcol+1,255);

{trivial screen optimization}

      refreshpart(topline-currline+1,lpp-2);
    end;
end;

procedure combine;

begin
  if currline<numlines then
    if length(lines[currline])+length(lines[currline+1])<79 then
      begin
        lines[currline] := lines[currline]+' '+lines[currline+1];
        deletelineat(currline+1);

{trivial screen optimization}

        refreshpart(currline-topline+1,lpp-2);
      end;
end;

procedure openbelow;

begin
  if numlines<maxlines then
    begin
      inc(currline);
      insertlineat(currline);
      lines[currline] := '';
      fixcol;

{trivial screen optimization}

      if offscreen(currline) then
        begin
          inc(topline);
          refreshall;
        end
      else
        begin
          refreshpart(currline-topline+1,lpp-2);
        end;
      insert;
    end;
end;

procedure openabove;

begin
  if numlines<maxlines then
    begin
      insertlineat(currline);
      lines[currline] := '';
      fixcol;
      refreshpart(currline-topline+1,lpp-2);
      insert;
    end;
end;

procedure deleteline;

begin
  if not offscreen(numlines) then
    xclreolxy(1,numlines-topline+1);

  deletelineat(currline);

{trivial screen optimization}

  if currline>numlines then
    begin
      dec(currline);
      fixcol;
      if offscreen(currline) then
        begin
          dec(topline,3*(lpp div 4));
          if topline<1 then
            topline := 1;
          refreshall;
        end;
      restorecurs;
    end
  else
    begin
      fixcol;
      refreshpart(currline-topline+1,lpp-2);
    end;

{$ifdef gooba}

  if (currline<=numlines) and offscreen(currline+1) then
    begin
      xclreolxy(1,currline-topline+1);
      fixcol;
      refreshline;
    end
  else if (currline>numlines) and not offscreen(currline-1) then
    begin
      xclreolxy(1,currline-topline+1);
      dec(currline);
      fixcol;
      restorecurs;
    end
  else
    begin
      if currline>numlines then
        dec(currline);
      fixcol;
      if offscreen(currline) then
        begin
          dec(topline);
          if topline=0 then
            begin
              topline := 1;
              currline := 1;
              lines[currline] := '';
            end;
        end;
      refreshall;
    end;

{$endif}

end;

procedure gofirstcol;

begin
  currcol := 1;
  restorecurs;
end;

procedure golastcol;

begin
  currcol := length(lines[currline]);
  restorecurs;
end;

procedure gofirstline;

begin
  currline := 1;
  if topline<>1 then
    begin
      topline := 1;
      refreshall;
    end;
  restorecurs;
end;

procedure golastline;

begin
  currline := numlines;
  fixcol;
  if offscreen(currline) then
    begin
      topline := numlines-lpp+5;
      if topline<1 then
        topline := 1;
      refreshall;
    end;
  restorecurs;
end;

procedure goforwardpg;

begin
  if offscreen(numlines) then
    begin
      inc(currline,lpp-4);
      inc(topline,lpp-4);
      if topline>numlines then
        topline := numlines;
      if currline>numlines then
        currline := numlines;
      refreshall;
    end
  else
    begin
      currline := numlines;
    end;
  restorecurs;
end;

procedure gobackpg;

begin
  if offscreen(1) then
    begin
      dec(currline,lpp-4);
      dec(topline,lpp-4);
      if topline<1 then
        topline := 1;
      if currline<1 then
        currline := 1;
      refreshall;
    end
  else
    begin
      currline := 1;
    end;
  restorecurs;
end;

procedure gohighline;

begin
  currline := topline;
  fixcol;
  restorecurs;
end;

procedure golowline;

begin
  currline := botline;
  if currline>numlines then
    currline := numlines;
  fixcol;
  restorecurs;
end;

procedure writefile;

var
  i: integer;

begin
  writexy(1,lpp,'writing...');
  assign(thefile,filename);
  {$I+}
  rewrite(thefile);
  {$I-}
  if ioresult<>0 then
    begin
      xwritelnss('trived: could not write file ',filename);
      halt(1);
    end;
  for i := 1 to numlines do
    writeln(thefile,trim(lines[i]));
  close(thefile);
  clrbotliner;
end;

procedure displayinfo;

var
  wastec: char;

begin
  xgotoxy(1,lpp);
  xwritesss('file: ',filename,'  line: ');
  xwritei(currline);
  xwrites(' of ');
  xwritei(numlines);
  xwrites('  press any key ');
  wastec := xreadkey;
  clrbotliner;
end;

procedure quit;

var
  c: char;

begin
  writexy(1,lpp,'quit: save first? y=yes, n=no, e=edit some more ');
  repeat
    c := xreadkey;
  until (c='y') or (c='n') or (c='e');
  if c='y' then
    begin
      xwrites('yes: quit+save');
      writefile;
      done := true;
    end
  else if c='n' then
    begin
      xwrites('no: quit+no save');
      done := true;
    end
  else
    begin
      clrbotliner;
    end;
end;

procedure editfile;

var
  cmd: char;

begin
  done := false;
  topline := 1;
  currline := 1;
  currcol := 1;
  counter := -1;
  refreshall;
  while not done do
    begin
      cmd := xreadkey;
      if cmd='?' then help
      else if cmd='z' then bighelp
      else if cmd='j' then downaline
      else if cmd=^M  then begin downaline; gofirstcol; end
      else if cmd='+' then begin downaline; gofirstcol; end
      else if cmd='k' then upaline
      else if cmd='-' then begin upaline; gofirstcol; end
      else if cmd='l' then rightachar
      else if cmd=' ' then rightachar
      else if cmd='h' then leftachar
      else if cmd='r' then refreshall
      else if cmd='x' then delchar
      else if cmd='i' then insert
      else if cmd='a' then append
      else if cmd='s' then split
      else if cmd='c' then combine
      else if cmd='o' then openbelow
      else if cmd='O' then openabove
      else if cmd='D' then deleteline
      else if cmd='^' then gofirstcol
      else if cmd='$' then golastcol
      else if cmd='F' then gofirstline
      else if cmd='G' then golastline
      else if cmd='f' then goforwardpg
      else if cmd='b' then gobackpg
      else if cmd='H' then gohighline
      else if cmd='L' then golowline
      else if cmd='w' then writefile
      else if cmd=^G  then displayinfo

{$ifdef debug}
else if cmd='!' then
  begin
    gotoxy(40,2);write(' ---------------------- ');
    gotoxy(40,3);write('|                      |');
    gotoxy(40,4);write('|                      |');
    gotoxy(40,5);write('|                      |');
    gotoxy(40,6);write('|                      |');
    gotoxy(40,7);write(' ---------------------- ');
    gotoxy(42,3);write('topline=',topline);
    gotoxy(42,4);write('currline=',currline);
    gotoxy(42,5);write('currcol=',currcol);
    gotoxy(42,6);write('length=',length(lines[currline]));
    restorecurs;
  end
{$endif}

      else if cmd='q' then quit;
    end;
end;

procedure initialize;

begin
  console := true;
  port := -1;
  minutes := maxint;
  if paramcount=1 then
    filename := paramstr(1)
  else if paramcount=2 then
    begin
      console := false;
      port := 0;
      minutes := atoi(paramstr(1));
      if minutes<0 then
        begin
          minutes := -minutes;
          port := 1;
        end;
      filename := paramstr(2);
    end
  else
    usage;
  filename := unslash(filename);
  trusted := console;
  minstart := mitoday;
end;

begin

{$ifdef debug}
  exec('c:\usr\bin\freem.exe','');
  xwrites('trived: freem: doserror=');
  xwritei(doserror);
  xwriteln;
{$endif}

  initialize;
  readfile;
  editfile;
end.