/****************************************************************************
 *
 * 	Program Name : EXIST1.C
 *
 *	Written By : Eng-Huat Ong and Kian-Mong Low.
 *
 *	This program tests the existence of a given minterm (in array b)
 *	in a given larger array, a with size of m minterms.
 *
 *	Returns  0  if b is present in a
 *              -1  if b is not present in a
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
 *
 ****************************************************************************/

#include <stdio.h>
#include <string.h>

char     exist(b, a, m)

unsigned char       *a, *b;
unsigned short      m;                      /* no. of minterms in array a */

{
   unsigned char    nspm;                 /* no. of storage/minterm */
   unsigned short   i;                    /* no. of minterms counter */
   int              test;                 /* memory compare status */

   nspm = *(a+3);                        /* no. of bytes/minterm */

   for (i=0; i<m; i++)                   /* check with all minterms in a */
      {
	 test = memcmp(b, (a+4+nspm*i), nspm);
	 if (test == 0)                          /* b present in a */
	    return(0);
      }

   return(-1);                                   /* b not present in a */
}
