/*** SIMFLT10.C version 1.0: Turbo C pgm to extract dirs from SIMIBM.IDX ***/
/*** Written by Rein de Vries, PTT Research, The Netherlands.            ***/
/*** (E-MAIL: RJ_dVries@pttrnl.nl)                                       ***/
	 

/* SET DEFAULT TABSIZE TO 2 TO MAKE THIS FILE READABLE!	*/

/* Include:						Prototypes for functions: */
#include <conio.h>		/* getch() */
#include <ctype.h>		/* toupper() */
#include <dos.h>   		/* getdate() */
#include <stdio.h>		/* fclose(), fgets(), fopen(), fprintf(), perror(),
												 printf(), setvbuf(), sscanf() */
#include <stdlib.h>		/* exit(), malloc() */
#include <string.h>		/* strcpy(), strdup(), strlen(), strnicmp(), strupr() */

#define BUFSIZE		20000
#define MAXLL				150
#define OR					 ||
#define AND					 &&

typedef enum {FALSE, TRUE} boolean;

typedef struct elem
{
	struct elem *next;
	char *dir;
} elem;

/* HELP TEXT */
char usage[] = "\n\
SIMFLT version 1.0. Usage:\n\
 SIMFLT [-C] [-Sfile] [-Dfile] [-Ffile] [-?] [-H]  (file = [d:][path]filename)\n\
\n\
SIMFLT extracts directories from SIMTEL20's .IDX file. Options:\n\
 -C........ Perform the conversion.\n\
 -Sfile.... Set source to \"file\". Default SIMIBM.IDX\n\
 -Dfile.... Set destination to \"file\". Default SIMIBM.LST\n\
 -F[file].. Set filter to DEFAULT.FLT or \"file\". Default no filtering.\n\
 -?/H...... Show this help text.\n";

/* VARIABLES */
boolean filtering = FALSE, match = FALSE;
char *orgFile  = "SIMIBM.IDX";
char *destFile = "SIMIBM.LST";
char *fltFile  = "DEFAULT.FLT";
char fileName[13], oldFS[6], FS[6], oldDIR[25], DIR[25], line[MAXLL];
char *chrPtr1, *chrPtr2, BITS;
elem *first, *current, **temp;
FILE *inFile, *outFile;
struct date currDate;
unsigned long size, date, readCount = 0, sumCount = 0, writeCount = 0;


void error_exit(char *charPtr1, char *charPtr2)
{
		/* Error Exit */
	fprintf(stderr, charPtr1);
	perror(charPtr2);
	exit(1);
}


void help_exit(char *charPtr)
{
		/* Help Exit */
	fprintf(stdout, charPtr);
	fprintf(stdout, usage);
	exit(0);
}


void processCount(void)
{
	if (writeCount != 0)
	{
		fprintf(outFile," ---------------------------------\n"
										" Total %s: %d entries.\n", oldDIR, writeCount);
		sumCount += writeCount;
		writeCount = 0;
	}
}


int main(int argc, char *argv[])
{
		/* Look for command line arguments */
	if (argc == 1) help_exit(NULL);
	argv++;		/* skip program name */
	while (*argv)
	{
		char c;
		if (**argv != '-' AND **argv != '/')
			help_exit("Illegal argument(s)!\n");
		(*argv)++;		/* skip the '-' or '/' */
		c = (char) toupper(**argv);		/* option letter */
		(*argv)++;		/* skip the option letter */
		switch (c) {
		case 'C':
				/* One legal option: no help text but conversion.  */
			break;
		case 'D':
			if (**argv != '\0')
					/* Destination has been specified */
				destFile = strupr(*argv);
			else
				help_exit("Destination not specified!\n");
			break;
		case 'F':
				/* Do filtering */
			filtering = TRUE;
			if (**argv != '\0')	fltFile = strupr(*argv);
			break;
		case 'H':
		case '?':
			help_exit(NULL);
		case 'S':
			if (**argv != '\0')
					/* Source has been specified */
				orgFile = strupr(*argv);
			else
				help_exit("Source not specified!\n");
			break;
		default:
			fprintf(stdout, "Illegal option \"%s\"!\n", (*argv) - 2);
			help_exit(NULL);
		}		/* end switch */
		argv++;
	}		/* end while */

	if (filtering == TRUE)
	{
			/* Get items for filtering from file */
		if ((inFile = fopen(fltFile, "rt")) == NULL)
			error_exit("Cannot read filter file ", fltFile);
		else
		{
			printf("Filtering according to file %s\n", fltFile);
			first = (elem *) malloc(sizeof(elem));
			fgets(line, MAXLL, inFile);
			*(line + strlen(line) - 1) = 0;
			first->dir  = strdup(line);
			first->next = NULL;
				/* Get other items and perform insertion sorting */
			while (fgets(line, MAXLL, inFile) != NULL)
			{
				if (strlen(line) >= 2)
				{
					current = (elem *) malloc(sizeof(elem));
					*(line + strlen(line) - 1) = 0;
					current->dir = strdup(line);
					temp = &first;
					while ((stricmp(current->dir, (*temp)->dir) > 0) AND
							((*temp)->next != NULL))
						temp = &((*temp)->next);
					if (stricmp(current->dir, (*temp)->dir) > 0)
					{
						(*temp)->next = current;
						current->next = NULL;
					}
					else
					{
						current->next = *temp;
						*temp = current;
					}
				}
			}
			fclose(inFile);
			current = first;
		}
	}

		/* Open source file */
	if ((inFile = fopen(orgFile,"rt")) == NULL)
		error_exit("Cannot read source ", orgFile);
		/* Set up buffer */
	if (setvbuf(inFile, NULL, _IOFBF, BUFSIZE) != 0)
		error_exit("Failed to set up buffer for ", orgFile);

		/* Open destination file */
	if (fclose(fopen(destFile, "rt")) == 0)
	{
		char answer;
		printf("%s already exists! Overwrite (Y/N)?: ", destFile);
		printf("%c\n", answer = getch());
		if (toupper(answer) != 'Y') exit(0);
	}
	if ((outFile = fopen(destFile,"wt")) == NULL)
		error_exit("Cannot write to ", destFile);
		/* Set up buffer */
	if (setvbuf(outFile, NULL, _IOFBF, BUFSIZE) != 0)
		error_exit("Failed to set up buffer for ", destFile);

		/* Time for some action! */
	if (filtering == TRUE)
		printf("Extracting %s from %s ", destFile, orgFile);
	else
		printf("Converting %s to %s ", orgFile, destFile);

	getdate(&currDate);
	fprintf(outFile,
		"WSMR-SIMTEL20.ARMY.MIL PUBLIC DOMAIN LISTING AS OF "
		"%02d-%02d-%4d\n\nNOTE: Type B is Binary; Type A is ASCII\n",
		currDate.da_mon, currDate.da_day, currDate.da_year);

	while (((chrPtr1 = (chrPtr2 = fgets(line, MAXLL, inFile))) != NULL) AND
					((filtering == FALSE) OR (current != NULL)) )
	{
		if ((readCount++ % 500) == 0) printf(".");
		size = 0;		/* Variable size used to count line items */
		while (size < 7)
		{
			if (*chrPtr1 != '"')
			{
				if (*chrPtr1 == ',')
				{
					*chrPtr2 = ' ';
					size++;
				}
				else
					*chrPtr2 = *chrPtr1;
				chrPtr2++;
			}
			chrPtr1++;
		}
		while (*(++chrPtr2) != 0);
		*(chrPtr2 - 2) = 0;
		sscanf(line, "%5s %24s %13s %U %U %c %U",
			FS, DIR, fileName, &size, &size, &BITS, &date);
		if (strnicmp(oldFS, FS, 5) OR strnicmp(oldDIR, DIR, 24))
		{
			if (filtering == TRUE)
			{
					/* DIR or FS changed */
				if (match == TRUE)
				{
					processCount();
					if (strnicmp(current->dir, DIR + 7, strlen(current->dir)) != 0)
					{
						current = current->next;
						match = FALSE;
					}
				}
				if ((match == FALSE) AND (current != NULL) AND
						 (strnicmp(current->dir, DIR + 7, strlen(current->dir)) == 0) )
					match = TRUE;
			}
			if ((filtering == FALSE) OR (match == TRUE))
			{
				fprintf(outFile,"\nDirectory %s%s", FS, DIR);
				fprintf(outFile,
					"\n  Filename   Type Size   Date    Description"
					"\n ============================================\n");
			}
			strcpy(oldFS, FS);
			strcpy(oldDIR, DIR);
		}
		if ((filtering == FALSE) OR (match == TRUE))
		{
			writeCount++;
			fprintf(outFile, " %-13s %c", fileName, (BITS == '8') ? 'B' : 'A');
			fprintf(outFile, "%5luk  %6lu  %s\n", 1+size/1000, date, ++chrPtr1);
		}
	}
	printf(" done.\n%d entries processed.\n", readCount);
	if (filtering == TRUE)
	{
		processCount();
		printf("%d entries written to file.\n", sumCount);
	}
	fclose(inFile);
	fclose(outFile);
	return(0);
}
