;History:194,1
;Thu Feb 22 23:41:33 1990 make buffer_modified into a bitmap.
;Tue Feb 13 19:21:28 1990 If a file being read is read-only, return that information.
;09-07-88 22:03:25 remove extern margin: abs
	page	,132

	.xlist

	include	memory.def

	.list

bufseg	segment	public
	extrn	toptop: word
	extrn	topbot: word
	extrn	bottop: word
	extrn	botbot: word
	extrn	linecount: word
	extrn	linesbefore: word
	extrn	buffer_modified: byte
bufseg	ends


data	segment byte public

	extrn	textseg: word

data	ends


code	segment byte public

	assume	cs:code, ds:data, es:data

	extrn	count_lines: near
	extrn	read_mark$: near
	extrn	adjust_marks_ins: near
	extrn	paint_window: near
	extrn	buffer_free: near


	public	write_file
write_file:
;enter with si->filename desired, al=mark.
;exit with al=0 if ok, al=1 if disk full, or al=2 if directory full.
	push	si			;save a pointer to the filename.

	push	ax			;save the mark to write to.
	mov	dx,si
	mov	cx,0
	mov	ah,3ch			;create file.
	int	21h
	pop	bx			;get the mark back
	jc	write_2_5		;if any problem, report dir full.
	xchg	bx,ax			;put the mark in ax, handle in bx.

	push	ds
	mov	ds,textseg		;read_mark$ assumes ds:textseg
	push	bx
	call	read_mark$
	pop	bx
	mov	dx,si			;set the disk transfer address
	mov	ah,40h			;write out what they requested.
	int	21h
	pop	ds
	jc	write_2_4		;if any problems, disk full.

	cmp	ax,cx			;did we write the whole thing?
	jne	write_2_4		;no - disk full.

;close the file.
	mov	ah,3eh			;close file.
	int	21h
	jc	write_2_4		;if any problems, say disk full.
	pop	si
	mov	al,0
	ret
write_2_4:
	mov	ah,3eh			;close file.
	int	21h
	pop	si
	mov	dx,si			;delete their file.
	mov	ah,41h
	int	21h
	mov	al,1
	ret
write_2_5:
	pop	si
	mov	al,2
	ret


	public	read_file
read_file:
;enter with si->filename desired.
;exit with al=0 if ok, al=1 if file too large, or al=2 if file not found.
	mov	dx,si
	mov	ax,4300h		;get the files's attributes
	int	21h
	mov	bp,cx			;remember the attributes here.

	mov	ax,3d00h		;open for reading.
	int	21h
	jc	read_2_5
	mov	bx,ax

	mov	ax,4202h		;get the file's size.
	mov	cx,0
	mov	dx,cx
	int	21h
	mov	cx,ax			;remember the file's size lobyte.

	or	dx,dx			;is file too big?
	jne	read_2_2		;if it's more than one segment, it's too big.
	mov	ax,textseg
	call	buffer_free		;ensure that the file will fit.
	jc	read_2_2		;it won't.

;if the file's empty, don't try to read it in.
	jcxz	read_2_7

;seek to the beginning again.

	push	cx
	mov	ax,4200h		;rewind the file.
	mov	cx,0
	mov	dx,cx
	int	21h
	pop	cx

;read the file in.

	push	ds
	mov	ds,textseg
	assume	ds:bufseg
	mov	dx,topbot		;read the file before the cursor.
	mov	ah,3fh
	int	21h
	pop	ds
	assume	ds:data
	jc	read_2_4		;problem with read - give up.

	cmp	cx,ax			;compare the amount desired again the amount read.
	pushf
	mov	cx,ax			;adjust for the amount read.
	push	bx			;preserve the file handle.
	call	read_adjust
	pop	bx
	popf
	jnz	read_2_4		;if any not read, give up.


;close the file.
read_2_7:
	mov	ah,3eh			;close the file.
	int	21h
	jc	read_2_4		;if any trouble, give up.
	mov	al,4			;read-only file.
	test	bp,1			;is this a read-only file?
	jne	read_2_exit		;yes - return read-only.
	mov	al,0			;all okay.
	jmp	short read_2_exit
read_2_2:
	mov	al,1			;not enough memory.
	jmp	short read_2_exit
read_2_4:
	mov	ah,3eh			;close the file.
	int	21h
	mov	al,3			;other read error.
	jmp	short read_2_exit
read_2_5:
	mov	al,2			;file not found.
read_2_exit:
	ret


read_adjust:
;update topbot, line counters.
	push	cx			;save count
	mov	ds,textseg
	assume	ds:bufseg
	mov	ax,cx
	call	adjust_marks_ins
	mov	di,topbot
	push	es
	pop	ds
	assume	ds:data
	pop	cx			;get the count back.
	push	cx
	call	count_lines		;count NEWLINES in text we just read in.
	mov	ds,textseg
	assume	ds:bufseg
	add	linesbefore,bx		;the text is before the cursor, so add
	add	linecount,bx
	or	buffer_modified,1
	pop	cx			;restore count
	add	topbot,cx		;add the amount of file that was read in.
	push	es
	pop	ds
	assume	ds:data
	call	paint_window
	ret


	public	compute_free
compute_free:
;enter with dl=drive.
;exit with cy if invalid drive, or nc and:
;  ax=sectors/cluster,
;  bx=free clusters,
;  cx=bytes/sector,
;  dx=total clusters.
	mov	ah,30h			;get the version number
	int	21h
	cmp	al,2			;al<2 for versions 1.?
	jb	compute_free_5
	mov	ah,36h			;get disk stats for version 2.0+
	int	21h			;dl already set
	cmp	ax,-1			;valid drive?
	jne	compute_free_4		;yes.
	push	ds
compute_free_6:
	pop	ds
	stc
	ret
compute_free_5:
	push	ds
	mov	ah,1ch			;get the fat.
	int	21h
	or	bx,bx
	je	compute_free_6
	mov	ah,0
	push	ax			;save the sectors/cluster
	push	cx			;save the bytes/sector
	mov	cx,dx			;we need the count in cx.
	xor	ax,ax			;start with no free clusters.
	mov	si,2			;start at the first cluster.
compute_free_1:
	mov	di,si
	shr	di,1
	add	di,si
	mov	di,[bx+di]
	test	si,001
	jz	compute_free_2
	shr	di,1
	shr	di,1
	shr	di,1
	shr	di,1
compute_free_2:
	and	di,0fffh		;seperate out the bits.
	jnz	compute_free_3		;free? no.
	inc	ax			;count a free cluster.
compute_free_3:
	inc	si			;go to the next.
	loop	compute_free_1		;until we've looked at them all.
	mov	bx,ax			;save the free clusters in bx.
	pop	cx			;restore bytes/sector
	pop	ax			;restore sectors/cluster.
	pop	ds
compute_free_4:
	clc
	ret


code	ends

	end

