/* extract.c   6-5-92  genome extraction for the Tierra Simulator */
/* Tierra Simulator V3.11: Copyright (c) 1991, 1992 Tom Ray & Virtual Life */

#ifndef lint
static char sccsid[] = "%W%    %G%";
#endif

#include "license.h"
#include "tierra.h"
#include "extern.h"


#ifdef MEM_CHK
#include <memcheck.h>
#endif

void extract(ce)
    Pcells ce;
{
    I16u i, j;
    I32s size;
    Ind ip;
    Pgl g;

    isolate = 0;
    if (GeneBnker)
#ifdef IBM3090
    sprintf(Buff, "%04ld.gen.d", ce->d.gen.size);
#else
    sprintf(Buff, "%s%04ld.gen", GenebankPath, ce->d.gen.size);
#endif
    else
#ifdef IBM3090
    sprintf(Buff, "mut%ld.gen.d", ++ExtractCount);
#else
    sprintf(Buff, "mut%ld", ++ExtractCount);
#endif
    size = ce->d.gen.size;
    if (GeneBnker) g = sl[size]->g[ce->d.gi];
    else
    {   g = (Pgl) tcalloc(1, sizeof(GList));
        g->bits = 0;
        g->gen = ce->d.gen;
        g->parent = ce->d.parent;
        g->d1 = ce->d.d1;
        g->d2.inst = ce->d.inst + 1 - ce->d.d1.inst;
        g->d2.flags = ce->d.flags - ce->d.d1.flags;
        g->d2.mov_daught = ce->d.mov_daught;
        g->d2.BreedTrue = 2;
        g->originI = InstExe;
        g->originC = time(NULL);
        g->MaxPropPop = g->MaxPropInst = -1;
        g->mpp_time.m = g->mpp_time.i = 0;
        g->ploidy = ce->d.ploidy;
        g->track = ce->c.tr;
        g->genome = (FpInst) tcalloc(g->gen.size, sizeof(Instruction));
        g->gbits = (FpGenB) tcalloc(g->gen.size, sizeof(GenBits));
        for (i = 0, ip = ce->mm.p; ip < ce->mm.p + size; i++, ip++)
#if PLOIDY == 1
            g->genome[i] = soup[ip];
#else /* PLOIDY == 1 */
            for (j = 0; j < g->ploidy; j++) g->genome[i][j] = soup[ip][j];
#endif /* PLOIDY == 1 */
    }
    sprintf(ExtrG, "%04ld%s @ %ld", g->gen.size, g->gen.label,
           (GeneBnker)? g->pop : 0L);
#if FRONTEND == STDIO
sprintf(mes[0], "extract: %s", ExtrG);
FEMessage(1,mes);
#else /* FRONTEND == STDIO */
    if (Log) fprintf(tfp_log, "ex = %s\n", ExtrG);
#endif /* FRONTEND == STDIO */

    if (GeneBnker)
    {   FILE *fp;
        head_t head;
        indx_t *indx, gindx;

/* DAN open an archive, if it does not exist, create it */
        if (!(fp = open_ar(Buff, ce->d.gen.size, GFormat, -1)))
        {   FEError(-200,EXIT,NOWRITE,
                "Tierra extract() Unable to open extract file %s",Buff);
        }
        head = read_head(fp);
#ifdef __TURBOC__
        indx = &gindx;
#else  /* __TURBOC__ */
        indx = read_indx(fp, &head);
#endif /* __TURBOC__ */
        add_gen(fp, &head, &indx, g);
#ifndef __TURBOC__
        if (indx)
        {   thfree(indx);
            indx = NULL;
        }
#endif /* __TURBOC__ */
        fclose(fp);
        NumGenDG++;
    }
    else
    {   WritGenFile(g, Buff);
        if (g)
        {   if (g->genome)
            {   tfree(g->genome);
                g->genome = NULL;
            }
            if (g->gbits)
            {   tfree(g->gbits);
                g->gbits = NULL;
            }
            tfree(g);
            g = NULL;
        }
    }
}
