/* memalloc.c   6-5-92 memory allocation routines for the Tierra Simulator */
/* Tierra Simulator V3.11: Copyright (c) 1991, 1992 Tom Ray & Virtual Life */

#ifndef lint
static char     memalloc_sccsid[] = "%W%     %G%";
#endif

#include <sys/types.h>
#include "license.h"
#include "tierra.h"
#include "extern.h"

#ifdef ALCOMM
#include "tmonitor.h"
#include "trequest.h"
#include <mlayer.h>
#endif


#ifdef MEM_CHK
#include <memcheck.h>
#endif

/* check to see if cell has write privelage at address */
I8s  IsPriv(ce, a)
Pcells  ce;
Ind  a;
{
#ifdef ERROR
    if(a >= SoupSize || a < 0)
        FEError(-600,EXIT,WRITE,
            "Tierra IsPriv() error: address %ld not in soup", a);
#endif
    if(IsInsideCell(ce, a)) return 1;
    return IsFree(a);
}

I8s IsBitPriv(ce,a,mode,track)
Pcells  ce;
Ind     a; /* address being checked */
I32s    mode, track; /* modes: 1 bit = execute, 2 bit = write, 4 bit = read */
{   if(a < 0 || a >= SoupSize)
        return 0;
    if(IsInsideCell(ce,a))
        return 1;
    else
        switch(mode)
        {
#if PLOIDY == 1
            case 1: return !soup[a].exec;
            case 2: return !soup[a].write;
            case 4: return !soup[a].read;
            case 6: return (!soup[a].read) && (!soup[a].write);
#else /* PLOIDY > 1 */
            case 1: return !soup[a][track].exec;
            case 2: return !soup[a][track].write;
            case 4: return !soup[a][track].read;
            case 6: return (!soup[a][track].read) && (!soup[a][track].write);
#endif /* PLOIDY > 1 */
            default: return 0;
        }
}

/* check to see if address is inside allocated memory cell ce */
I8s  IsInsideCell(ce, a)
Pcells  ce;
Ind  a;
{
#ifdef ERROR
    if(a >= SoupSize || a < 0)
        FEError(-601,EXIT,WRITE,
            "Tierra IsInsideCell() error: address %ld not in soup", a);
#endif
    if((ce->mm.p <= a && a < ce->mm.p + ce->mm.s) || (ce->md.s > 0 &&
       (ce->md.p <= a && a < ce->md.p + ce->md.s)))
        return 1;
    return 0;
}

/* check to see if address is free, not allocated by any cell */
I8s  IsFree(a)
Ind  a;
{   I32s  j;
    I32s  mp;  /* index to element of FreeMem array */
    Pmf   f;

#ifdef ERROR
    if(a >= SoupSize || a < 0)
        FEError(-602,EXIT,WRITE,
            "Tierra IsFree() error: address %ld not in soup", a);
#endif
    f = FreeMem;     /* abbreviation for FreeMem */
    mp = FreeMem->n; /* this is the first free block */
    if(a < (f + mp)->p)
        return 0;
    j = 1;
        /* find block whose end is equal or above a: */
    while((f + mp)->p + (f + mp)->s < a)
    {   mp = (f + mp)->n; j++;
        if(j > FreeBlocks)
            return 0;
    } /* is a in free block: */
    if((f + mp)->p <= a && a < (f + mp)->p + (f + mp)->s)
        return 1;
    return 0;
}

void  WhichCell(a, ce, md) /* find cell with address a */
Ind        a;    /* note: a must be in a cell!, call IsFree() before */
Pcells Fp  ce;   /* WhichCell() to find out if a is in a cell or not */
I8s        *md;
{   I32s  ar, ci;
    Pcells  te;

    for(ar = 0; ar < NumCelAr; ar++) for(ci = 0; ci < CelArSiz; ci++)
    {   if (ar == 0 && ci < 2)
            continue;
        te = &cells[ar][ci];
        if(te->ld && te->mm.p <= a && (te->mm.p + te->mm.s - 1) >= a)
        {   *ce = te; *md = 'm'; return; }
        if(te->ld && te->md.p <= a && (te->md.p + te->md.s - 1) >= a)
        {   *ce = te; *md = 'd'; return; }
    }
}

Ind  MemAlloc(size)
I32s  *size;
{   I32s  j; /* counts the physical order of the free block we are indexing */
    I32s  mb; /* memory block index */
    I32s  pb; /* previous memory block index */
    Ind   ti; /* temporary instruction location index, for return value */

    if(!*size || !FreeBlocks) { *size = 0; return 0; }
    mb = FreeMem->n; /* this is the first free block */
    pb = 0; /* this is SoupBot */
    j = 1; /* counts the physical order of the free block we are indexing */
    while((FreeMem + mb)->s < *size)  /* find big enough free block */
    {   pb = mb;
        mb = (FreeMem + mb)->n;
        j++;
        if(j > FreeBlocks) /* if memory is very fragmented, reap some: */
        {   if(FreeMemCurrent > 3 * *size) fragment = 1;
            *size = 0; return 0;
        }
    }
    fragment = 0;
    FreeMemCurrent -= *size;
    if((FreeMem + mb)->s == *size)  /* free block is exactly the right size */
    {   (FreeMem + pb)->n = (FreeMem + mb)->n;
        (FreeMem + mb)->o = 0;
        FreeBlocks--;
        if((FreeMem + mb)->p > SoupSize)
            FEError(-603,EXIT,WRITE,"Tierra MemAlloc() error 1");
#ifdef ALCOMM
        if ( MIsDFEnabled( TrtOrgLifeEvent ) )
          {
          TRepBirth( (FreeMem + mb)->p, *size );
          }
#endif

        return (FreeMem + mb)->p;
    }
    if((FreeMem + mb)->s > *size)  /* free block bigger than needed */
    {   ti = (FreeMem + mb)->p;
        if(ti > SoupSize)
            FEError(-604,EXIT,WRITE,"Tierra MemAlloc() error 2");
        (FreeMem + mb)->p += *size;
        if((FreeMem + mb)->p > SoupSize)
            FEError(-605,EXIT,WRITE,"Tierra MemAlloc() error 3");
        (FreeMem + mb)->s -= *size;
        if((FreeMem + mb)->s > SoupSize)
            FEError(-606,EXIT,WRITE,"Tierra MemAlloc() error 4");
#ifdef ALCOMM
        if ( MIsDFEnabled( TrtOrgLifeEvent ) )
           {
          TRepBirth( ti, *size );
          }
#endif

        return ti;
    }
    return 0;
}

void MemDealloc(p, size)
Ind  p;
I32s  size;
{   I32s  i, j, a, b, ola, olb, bt;
    Ind   bb, ab, at, pt;
    Pmf   f, tf;

#ifdef ALCOMM
    if ( MIsDFEnabled( TrtOrgLifeEvent ) )
       {
      TRepDeath( p, size );
          }
#endif

#ifdef ERROR
    if(p < 0L || !size || p >= SoupSize)
        FEError(-607,EXIT,WRITE,"Tierra MemDealloc() error 1");
#endif
    f = FreeMem;          /* abbreviation for FreeMem */
    a = (f + SoupBot)->n; /* a will index free block above */
    b = SoupBot;          /* b will index free block below */
    j = 1L;
    while(p >= (f + a)->p) /* find free block above block to be deallocated */
    {   if(j > FreeBlocks) break;
        b = a; a = (f + a)->n; j++;
    }
#ifdef ERROR
    if(p > (f + a)->p)
        FEError(-608,EXIT,WRITE,"Tierra MemDealloc() error 2");
#endif
    bb = (f + b)->p;                   /* bb is address of bottom of b */
    bt = (f + b)->p + (f + b)->s - 1L; /* bt is address of top of b */
    ab = (f + a)->p;                   /* ab is address of bottom of a */
    at = (f + a)->p + (f + a)->s - 1L;  /* at is address of top of a */
    pt = p + size - 1L;                 /* pt is address of top of p */
    if(pt > SoupSize - 1L)
    {   FEError(-609,NOEXIT,NOWRITE, "Tierra MemDealloc() inconsistency 0");
        pt = SoupSize - 1L;
        size = pt - p + 1L;
    }
    if(bt > (p - 1L))
        FEError(-610,NOEXIT,NOWRITE, "Tierra MemDealloc() inconsistency 1");
    if(pt > ab - 1L)
        FEError(-611,NOEXIT,NOWRITE, "Tierra MemDealloc() inconsistency 2");
    if(bt >= p - 1L) olb = 1L; else olb = 0L;   /* overlap with block below */
    if(pt >= ab - 1L) ola = 1L; else ola = 0L;  /* overlap with block above */
        /* if block to be deallocated overlaps free blocks above and below: */
    if(ola && olb)
    {   if(b == SoupBot)
        {   FreeMemCurrent += ab - p;
            (f + a)->s = at - p + 1L;
            (f + a)->p = p; return ;
        }
        if(a == SoupTop)
        {   FreeMemCurrent += pt - bt;
            (f + b)->s = pt - bb + 1L; return;
        }
        FreeMemCurrent += ab - bt - 1L;
        (f + b)->s = at - bb + 1L;
        (f + b)->n = (f + a)->n;
            /* neutralize f + a: */
        (f + a)->o = (I8s ) 0; (f + a)->p = (f + a)->s = 0L; (f + a)->n = a;
        FreeBlocks--; return;
    }       /* block to be deallocated overlaps only free block above: */
    if(ola && a != SoupTop)
    {   FreeMemCurrent += ab - p;
        (f + a)->s = at - p + 1L;
        (f + a)->p = p; return ;
    }       /* block to be deallocated overlaps only free block below */
    if(olb && b != SoupBot)
    {   FreeMemCurrent += pt - bt;
        (f + b)->s = pt - bb + 1L; return ;
    }
    j = 0L;  /* block to be deallocated does not overlap any free block */
    while((FreeMem + j)->o)
    {   if(++j == MaxFreeBlocks)
        {   MaxFreeBlocks += 10L;
            tf = (Pmf) threcalloc((I8s Hp) FreeMem,
                sizeof(MemFr) * (I32u) MaxFreeBlocks,
                sizeof(MemFr) * (I32u) (MaxFreeBlocks - 10));
            if (tf)
                f = FreeMem = tf;
            else if (FreeMem)
            {   tfree(FreeMem);
                FreeMem = f = NULL;
                FEError(-612,EXIT,WRITE,
                    "Tierra MemDealloc() FreeMem trecalloc error, exiting");
            }
#ifdef __TURBOC__
            sprintf(mes[0],"coreleft = %lu  MemDealloc (FreeMem)",coreleft());
            FEMessage(1,mes);
#endif
            sprintf(mes[0],
                "Tierra MemDealloc() trecalloc, MaxFreeBlocks = %ld",
                MaxFreeBlocks);
            FEMessage(1,mes);
            for(i = MaxFreeBlocks - 10L; i < MaxFreeBlocks; i++)
            {   (f + i)->n = i;
                (f + i)->o = (I8s ) 0; (f + i)->p = (f + i)->s = 0L;
            }
        }
    }
    (f + j)->o = (I8s ) 1;
    (f + j)->n = a; (f + b)->n = j; FreeBlocks++;
    (f + j)->p = p;
    (f + j)->s = size;
    FreeMemCurrent += size;
}

/* ----------------------------------------------------------------------- */
 /* 1 bit = execute, 2 bit = write, 4 bit = read */
 /* only owner of memory has chmod privelages */
 /* return 0 on success, return 1 on error */

I8s chmode(ce, start, size, mode)
    Pcells  ce;
    I32s start, /* where in the soup to start */
         size,  /* how far to go, (will wrap around end of soup) */
         mode;  /* chmod bits, like unix, see above */
{
    Ind a = 0, t;
    I8s exec, write, read, ret = 0;

    exec =  IsBit(mode, 0);
    write = IsBit(mode, 1);
    read =  IsBit(mode, 2);
    while (a < size)
    {   t = ad(start + a);
        if (IsInsideCell(ce, t))
        {
#if PLOIDY == 1
            soup[t].exec = exec;
            soup[t].write = write;
            soup[t].read = read;
#else  /* PLOIDY > 1 */
            soup[t][ce->c.tr].exec = exec;
            soup[t][ce->c.tr].write = write;
            soup[t][ce->c.tr].read = read;
#endif  /* PLOIDY > 1 */
        }
        else ret = 1;
        a++;
    }
    return ret;
}

/* ----------------------------------------------------------------------- */

I32s mal(ce,sug_addr,sug_size)           /* allocate space for a new cell */
    Pcells  ce;
    I32s *sug_addr,        /* suggested address for mal, NOT IMPLEM YET */
                        /* also returns actuall address of block, */
         sug_size;        /* size of block to get */
                        /* function returns actual size, or 0 on fialure */
{
    Ind p;
    I32s size, osize;

    if (sug_size <= 0 || sug_size == ce->md.s || 
        sug_size > MaxMalMult * ce->mm.s)
        return 0;
    size = (I32s) sug_size + flaw(ce);
    if (!size)
        return 0;
    if (ce->md.s)
    {
#ifdef ERROR
        if (ce->md.p < 0 || ce->md.p >= SoupSize)
            FEError(-613,EXIT,WRITE, "Tierra mal() error 1");
#endif  /* DAN should check return val */
        chmode(ce,ce->md.p, ce->md.s,MemModeFree); 
        MemDealloc(ce->md.p, ce->md.s);
        ce->d.mov_daught = 0;
        ce->md.s = 0;
    }
    osize = size;
    p = MemAlloc(&size);
    /* while (!size && osize < MaxMalMult * AverageSize) */
    /* DAN - not clear why we did this ^^^^^^^^^ */
    while (!size )        /* kill till we get our size */
    {   reaper(1);
        size = osize;
        p = MemAlloc(&size);
    }
#ifdef ERROR
    if (p < 0 || p >= SoupSize)
        FEError(-614,EXIT,WRITE, "Tierra mal() error 2");
#endif
    if (!size)
        return 0;

    /* got a block, pass location (sug_addr) and size back  */

    *(sug_addr) = ce->md.p = ad(p);
    ce->md.s = size;
    ce->c.fl = 0;
    DownReperIf(ce);
    return size;
}

/* ----------------------------------------------------------------------- */
