/* parse.c   6-5-92  parser functions for the Tierra Simulator */
/* Tierra Simulator V3.11: Copyright (c) 1991, 1992 Tom Ray & Virtual Life */

#include "license.h"
#include "tierra.h"
#include "extern.h"


#ifdef MEM_CHK
#include <memcheck.h>
#endif

#if INST == 1

/* in INST == 1, the array of registers maps into the registers ax, bx, cx, dx
   as follows:  c.re[0] = ax, c.re[1] = bx, c.re[2] = cx, c.re[3] = dx */

void SetFlag(ce)
Pcells  ce;
{   ce->c.fl = 1; }

void pnop(ce) /* do nothing */
Pcells  ce;
{   is.iip = is.dib = 1; }

void por1(ce) /* flip low order bit of cx */
Pcells  ce;
{   is.dreg = &(ce->c.re[2]);
    is.dval = ce->c.re[2];
    is.iip = is.dib = 1;
    is.dran = SoupSize;
}

void pshl(ce) /* shift left all register of cx */
Pcells  ce;
{   is.dreg = &(ce->c.re[2]);
    is.dval = ce->c.re[2];
    is.iip = is.dib = 1;
    is.dran = SoupSize;
}

void pzero(ce) /* cx = 0 */
Pcells  ce;
{   is.dreg = &(ce->c.re[2]);
    is.sval = 0;
    is.iip = is.dib = 1;
}

void pif_cz(ce) /* execute next instruction only if cx == 0 */
Pcells  ce;
{   is.sval = ce->c.re[2];
    is.iip = is.dib = 1;
}

void psub_ab(ce) /* cx = ax - bx */
Pcells  ce;
{   is.dreg = &(ce->c.re[2]);
    is.sval = ce->c.re[0];
    is.sval2 = -ce->c.re[1];
    is.iip = is.dib = 1;
    is.dran = SoupSize;
}

void psub_ac(ce) /* ax = ax - cx */
Pcells  ce;
{   is.dreg = &(ce->c.re[0]);
    is.sval = ce->c.re[0];
    is.sval2 = -ce->c.re[2];
    is.iip = is.dib = 1;
    is.dmod = SoupSize;
}

void pinc_a(ce) /* ax++ */
Pcells  ce;
{   is.dreg = &(ce->c.re[0]);
    is.sval = ce->c.re[0];
    is.sval2 = 1;
    is.iip = is.dib = 1;
    is.dmod = SoupSize;
}

void pinc_b(ce) /* bx++ */
Pcells  ce;
{   is.dreg = &(ce->c.re[1]);
    is.sval = ce->c.re[1];
    is.sval2 = 1;
    is.iip = is.dib = 1;
    is.dmod = SoupSize;
}

void pdec_c(ce) /* cx-- */
Pcells  ce;
{   is.dreg = &(ce->c.re[2]);
    is.sval = ce->c.re[2];
    is.sval2 = -1;
    is.iip = is.dib = 1;
    is.dran = SoupSize;
}

void pinc_c(ce) /* cx++ */
Pcells  ce;
{   is.dreg = &(ce->c.re[2]);
    is.sval = ce->c.re[2];
    is.sval2 = 1;
    is.iip = is.dib = 1;
    is.dran = SoupSize;
}

void ppushax(ce) /* push ax onto stack */
Pcells  ce;
{   is.sval = ce->c.re[0];
    is.iip = is.dib = 1;
}

void ppushbx(ce) /* push bx onto stack */
Pcells  ce;
{   is.sval = ce->c.re[1];
    is.iip = is.dib = 1;
}

void ppushcx(ce) /* push cx onto stack */
Pcells  ce;
{   is.sval = ce->c.re[2];
    is.iip = is.dib = 1;
}

void ppushdx(ce) /* push dx onto stack */
Pcells  ce;
{   is.sval = ce->c.re[3];
    is.iip = is.dib = 1;
}

void ppop_ax(ce) /* pop ax off of stack */
Pcells  ce;
{   is.dreg = &(ce->c.re[0]);
    is.iip = is.dib = 1;
    is.dmod = SoupSize;
}

void ppop_bx(ce) /* pop bx off of stack */
Pcells  ce;
{   is.dreg = &(ce->c.re[1]);
    is.iip = is.dib = 1;
    is.dmod = SoupSize;
}

void ppop_cx(ce) /* pop cx off of stack */
Pcells  ce;
{   is.dreg = &(ce->c.re[2]);
    is.iip = is.dib = 1;
    is.dran = SoupSize;
}

void ppop_dx(ce) /* pop dx off of stack */
Pcells  ce;
{   is.dreg = &(ce->c.re[3]);
    is.iip = is.dib = 1;
    is.dran = SoupSize;
}

void ptjmp(ce) /* outward template jump */
Pcells  ce;
{   I32s    a, s = 0;

    is.dreg  = &(ce->c.ip); /* destination register for address */
    is.dreg2 = &(ce->c.re[3]); /* destination register for template size */
    a = ad(ce->c.ip + 1); /* a = address of start of template */
    while(1) /* find size of template, s = size */
    {   
#if PLOIDY == 1
	if(soup[ad(a + s)].inst != Nop0 &&
           soup[ad(a + s)].inst != Nop1)
#else /* PLOIDY > 1 */
	if(soup[ad(a + s)][ce->c.tr].inst != Nop0 &&
           soup[ad(a + s)][ce->c.tr].inst != Nop1)
#endif /* PLOIDY > 1 */
            break;
        s++;
    }
    is.sval2 = s;  /* size of template */
    is.dran2 = SoupSize;
    is.dmod  = SoupSize;
    is.dval  = ad(a + s + 1); /* start address for forward search */
    is.dval2 = ad(a - s - 1); /* start address for backward search */
    is.mode  = 0; /* outward jump */
    is.mode2 = 0; /* complementary templates */
    is.iip = 0; is.dib = 1;
}

void ptjmpb(ce) /* backward template jump */
Pcells  ce;
{   I32s    a, s = 0;

    is.dreg  = &(ce->c.ip); /* destination register for address */
    is.dreg2 = &(ce->c.re[3]); /* destination register for template size */
    a = ad(ce->c.ip + 1); /* a = address of start of template */
    while(1) /* find size of template, s = size */
    {   
#if PLOIDY == 1
	if(soup[ad(a + s)].inst != Nop0 &&
           soup[ad(a + s)].inst != Nop1)
#else /* PLOIDY > 1 */
	if(soup[ad(a + s)][ce->c.tr].inst != Nop0 &&
           soup[ad(a + s)][ce->c.tr].inst != Nop1)
#endif /* PLOIDY > 1 */
            break;
        s++;
    }
    is.sval2 = s;  /* size of template */
    is.dran2 = SoupSize;
    is.dmod  = SoupSize;
    is.dval  = ad(a + s + 1); /* start address for forward search */
    is.dval2 = ad(a - s - 1); /* start address for backward search */
    is.mode  = 2; /* backward jump */
    is.mode2 = 0; /* complementary templates */
    is.iip = 0; is.dib = 1;
}

void ptcall(ce) /* push ip to stack, outward template jump */
Pcells  ce;
{   I32s    a, s = 0;

    is.dreg  = &(ce->c.ip); /* destination register for address */
    is.dreg2 = &(ce->c.re[3]); /* destination register for template size */
    a = ad(ce->c.ip + 1); /* a = address of start of template */
    while(1) /* find size of template, s = size */
    {
#if PLOIDY == 1
	if(soup[ad(a + s)].inst != Nop0 &&
           soup[ad(a + s)].inst != Nop1)
#else /* PLOIDY > 1 */
	if(soup[ad(a + s)][ce->c.tr].inst != Nop0 &&
           soup[ad(a + s)][ce->c.tr].inst != Nop1)
#endif /* PLOIDY > 1 */
            break;
        s++;
    }
    is.sval  = ce->c.ip + s + 1;    /* address to be pushed onto stack */
    is.sval2 = s;  /* size of template */
    is.dran2 = SoupSize;
    is.dmod  = SoupSize;
    is.dval  = ad(a + s + 1); /* start address for forward search */
    is.dval2 = ad(a - s - 1); /* start address for backward search */
    is.mode  = 0; /* outward jump */
    is.mode2 = 0; /* complementary templates */
    is.iip = 0; is.dib = 1;
}

void pret(ce) /* pop ip from stack */
Pcells  ce;
{   is.dreg = &(ce->c.ip);
    is.iip = 0; is.dib = 1;
    is.dmod = SoupSize;
}

void pmov_dc(ce) /* dx = cx */
Pcells  ce;
{   is.dreg = &(ce->c.re[mo(3 + flaw(ce), NUM_REGS)]);
    is.sval = ce->c.re[mo(2 + flaw(ce), NUM_REGS)];
    is.iip = is.dib = 1;
    if (is.dreg == &(ce->c.re[0]) || is.dreg == &(ce->c.re[1]))
        is.dmod = SoupSize;
    else
        is.dran = SoupSize;
}

void pmov_ba(ce) /* bx = ax */
Pcells  ce;
{   is.dreg = &(ce->c.re[mo(1 + flaw(ce), NUM_REGS)]);
    is.sval = ce->c.re[mo(0 + flaw(ce), NUM_REGS)];
    is.iip = is.dib = 1;
    if (is.dreg == &(ce->c.re[0]) || is.dreg == &(ce->c.re[1]))
        is.dmod = SoupSize;
    else
        is.dran = SoupSize;
}

void pmoviab(ce)
Pcells  ce;
{
    is.dval = ad(ce->c.re[0] + flaw(ce));
    is.sval = ad(ce->c.re[1] + flaw(ce));
#if PLOIDY == 1
    is.dins = &soup[is.dval];
    is.sins = &soup[is.sval];
#else /* PLOIDY > 1 */
    is.dins = &soup[is.dval][ce->c.tr];
    is.sins = &soup[is.sval][ce->c.tr];
#endif /* PLOIDY > 1 */
    is.dtra = is.stra = ce->c.tr;
    is.iip = is.dib = 1;
}

void padr(ce) /* search outward for template, return address in ax */
Pcells  ce; /* return template size in cx */
{   I32s    a, s = 0;

    is.dreg  = &(ce->c.re[0]); /* destination register for address */
    is.dreg2 = &(ce->c.re[2]); /* destination register for template size */
    a = ad(ce->c.ip + 1); /* a = address of start of template */
    while(1) /* find size of template, s = size */
    {
#if PLOIDY == 1
	if(soup[ad(a + s)].inst != Nop0 &&
           soup[ad(a + s)].inst != Nop1)
#else /* PLOIDY > 1 */
	if(soup[ad(a + s)][ce->c.tr].inst != Nop0 &&
           soup[ad(a + s)][ce->c.tr].inst != Nop1)
#endif /* PLOIDY > 1 */
            break;
        s++;
    }
    is.sval2 = s;  /* size of template */
    is.dran2 = SoupSize;
    is.dmod  = SoupSize;
    is.dval  = ad(a + s + 1); /* start address for forward search */
    is.dval2 = ad(a - s - 1); /* start address for backward search */
    is.mode  = 0; /* outward jump */
    is.mode2 = 0; /* complementary templates */
    is.iip = 0; is.dib = 1;
}

void padrb(ce) /* search backward for template, return address in ax */
Pcells  ce; /* return template size in cx */
{   I32s    a, s = 0;

    is.dreg  = &(ce->c.re[0]); /* destination register for address */
    is.dreg2 = &(ce->c.re[2]); /* destination register for template size */
    a = ad(ce->c.ip + 1); /* a = address of start of template */
    while(1) /* find size of template, s = size */
    {
#if PLOIDY == 1
	if(soup[ad(a + s)].inst != Nop0 &&
           soup[ad(a + s)].inst != Nop1)
#else /* PLOIDY > 1 */
	if(soup[ad(a + s)][ce->c.tr].inst != Nop0 &&
           soup[ad(a + s)][ce->c.tr].inst != Nop1)
#endif /* PLOIDY > 1 */
            break;
        s++;
    }
    is.sval2 = s;  /* size of template */
    is.dran2 = SoupSize;
    is.dmod  = SoupSize;
    is.dval  = ad(a + s + 1); /* start address for forward search */
    is.dval2 = ad(a - s - 1); /* start address for backward search */
    is.mode  = 2; /* backward jump */
    is.mode2 = 0; /* complementary templates */
    is.iip = s + 1; is.dib = 1;
}

void padrf(ce) /* search forward for template, return address in ax */
Pcells  ce; /* return template size in cx */
{   I32s    a, s = 0;

    is.dreg  = &(ce->c.re[0]); /* destination register for address */
    is.dreg2 = &(ce->c.re[2]); /* destination register for template size */
    a = ad(ce->c.ip + 1); /* a = address of start of template */
    while(1) /* find size of template, s = size */
    {
#if PLOIDY == 1
	if(soup[ad(a + s)].inst != Nop0 &&
           soup[ad(a + s)].inst != Nop1)
#else /* PLOIDY > 1 */
	if(soup[ad(a + s)][ce->c.tr].inst != Nop0 &&
           soup[ad(a + s)][ce->c.tr].inst != Nop1)
#endif /* PLOIDY > 1 */
            break;
        s++;
    }
    is.sval2 = s;  /* size of template */
    is.dran2 = SoupSize;
    is.dmod  = SoupSize;
    is.dval  = ad(a + s + 1); /* start address for forward search */
    is.dval2 = ad(a - s - 1); /* start address for backward search */
    is.mode  = 1; /* forward jump */
    is.mode2 = 0; /* complementary templates */
    is.iip = s + 1; is.dib = 1;
}

void pmal(ce)  /* allocate space for a new cell */
Pcells  ce;  /* allocate space for a new cell */
{   is.dreg = &(ce->c.re[0]);
    is.sval = ce->c.re[2];
    is.dmod = SoupSize;
    is.dtra = ce->c.tr;
    is.mode = MemModeProt; /* only write privelages works at the moment */
    is.iip = is.dib = 1;
}

void pdivide(ce)  /* give life to new cell by puting in queue */
Pcells  ce;
{   is.mode = 2;  /* full division */
    is.iip = is.dib = 1;
}

#endif  /* end of INST 1 */
