/* sw_env.c - build a well formed MS-DOS environment.
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This file is part of SWAPLIB (the library), a library for efficient
   execution of child processes under MS-DOS.

   The library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/swaplib/RCS/sw_env.c'v 0.9 90/09/09 21:43:55 tho Stable $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>

#include "swaplib.h"

extern void *xmalloc (size_t size);
extern void *xrealloc (void *ptr, size_t size);
static int argv_p (char *s);


/* Test whether S is an environment entry used to pass
   commandline arguments.  We use it to filter such
   entries out that migth have been installed by lower
   shell levels.  */

int
argv_p (char *s)
{
  if (!strncmp (s, "_argc=", 6))	/* Easy match. */
    return 1;
  else
    {
      if (strncmp (s, "_argv", 5))	/* Prefix failed.  */
	return 0;
      else
	{
	  s += 5;
	  while (isdigit (*s))		/* Skip digits. */
	    s++;
	  if (*s == '=')
	    return 1;
	  else
	    return 0;
	}
    }
}


/* Build a well formed MS-DOS environment (ASCIZ strings,
   terminated by another '\0') from ENVV.  If ENVV is NULL,
   use ENVIRON.  If ARGV is not NULL,  prepend it by
   "_argv0="ARGV[0], "_argv1="ARGV[1], ..., "_argc="ARGC.
    This is the way to pass a 32k commandline.  Additional
   entries can be specified by the NULL terminated list of
   optional arguments.  Neither of the arguments will be freed.
   The result will be stored in BUFPTR and the total length of
   the environment (including '\0''s) is returned.  */

#define ALLOC_UNIT	0x0200
#define EXPAND_BUFFER						\
  while (allocated <= used + size)				\
    {								\
      allocated += ALLOC_UNIT;					\
      _swap_environ_buf						\
	= (char *) xrealloc (_swap_environ_buf, allocated);	\
    }

int
_swap_format_msdos_environment (char **argv, char **envv, ...)
{
  int allocated = 0;
  int size = 0;
  int used = 0;
  int argc = 0;

  /* further optional entries: */

  va_list optarg;
  char *entry = NULL;


  if (argv)
    {
      /* Format the commandline arguments as environment entries.  */

      while (*argv)
	{
	  size = strlen (*argv) + sizeof ("_argv32767=") + 1;
	  EXPAND_BUFFER;
	  used += sprintf (_swap_environ_buf + used, "_argv%d=%s",
			   argc++, *argv++) + 1;
	}

      /* Store the number of arguments.  */

      if (argc > 0)
	{
	  size = sizeof ("_argc=32767") + 1;
	  EXPAND_BUFFER;
	  used += sprintf (_swap_environ_buf + used, "_argc=%d", argc) + 1;
	}
    }

  /* Process the optional arguments.  */

  va_start (optarg, envv);

  while (1)
    {
      entry = va_arg (optarg, char *);
      if (!entry)
	break;

      size = strlen (entry) + 2;
      EXPAND_BUFFER;
      strcpy (_swap_environ_buf + used, entry);
      used += size - 1;
    }

  va_end (optarg);


  /* Maybe export the standard environment.  */

  if (!envv)
    envv = environ;

  /* Now copy the environment.  */

  while (*envv)
    {
      /*  Avoid stacking the commandline entries.  */

      if (!argv_p (*envv))
	{
	  size = strlen (*envv) + 2;
	  EXPAND_BUFFER;
	  strcpy (_swap_environ_buf + used, *envv);
	  used += size - 1;
	}
      envv++;
    }

  /* MS-DOS Environments end with "\000\000".  */

  _swap_environ_buf[used++] = '\0';

  /* Release useless storage.  */

  _swap_environ_buf = (char *) xrealloc (_swap_environ_buf, used);

  return used;
}

/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */

