/* sw_misc.c - helper routines for swaplib
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This file is part of SWAPLIB (the library), a library for efficient
   execution of child processes under MS-DOS.

   The library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/swaplib/RCS/sw_misc.c'v 0.9 90/09/09 21:44:02 tho Stable $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include <io.h>

#include "swaplib.h"

extern void *xmalloc (size_t size);
extern void *xrealloc (void *ptr, size_t size);

#define FSLASH		'/'
#define BSLASH		'\\'

/* Concatenate and copy ARGV[1], ... into CMDLINE_BUF.  */

int
_swap_build_cmdline (char **argv)
{
  int i = 0;

  /* paste arguments together */

  argv++;

  while (*argv)
    {
      int len = strlen (*argv);
      if (i + len > 126)
	{
	  /* commandline to long for MeSy-DOS */

	  strcpy (_swap_cmdline_buf, CMDLINE_TOO_LONG);
	  errno = E2BIG;
	  return -1;
	}

      strcpy (_swap_cmdline_buf + i, *argv++);
      i += len + 1;
      _swap_cmdline_buf[i - 1] = ' ';
    }

  /* Terminate */

  _swap_cmdline_buf[max(i - 1, 0)] = '\0';

  return 0;
}


/* Return pointer to last path component in PATH.  */

char *
swap_basename (char *path)
{
  char *ptr;
  char *base;

  ptr = strrchr (path, BSLASH);	/* first find last backslash.  */
  if (ptr == NULL)
    ptr = path;
  else
    ptr++;

  base = strrchr (ptr, FSLASH);	/* then find last slash.  */
  if (base == NULL)
    base = ptr;
  else
    base++;

  return base;
}


/* Get a unique filename in the temporary directory from the environment
   entry TMP or TEMP, if this fails, use current directory.  (replacement
   for tempnam(), whish is *too* touchy about trailing path separators!) */

char *
swap_mktmpname (char *prefix)
{
  register int len;
  register char *ptr;
  register char *tmpname;
  static char default_prefix[3] = "vm";

  if (!prefix[0] || !prefix[1])	/* did the user supply a prefix? */
    prefix = default_prefix;

  if (!(ptr = getenv ("TMP")) && !(ptr = getenv ("TEMP")))
    {

      ptr = ".";
      len = 1;
    }
  else
    {
      len = strlen (ptr) - 1;
      if ((ptr[len] == FSLASH) || (ptr[len] == BSLASH))
	ptr[len] = '\0';
    }

  tmpname = xmalloc (len + 10);

  sprintf (tmpname, "%s/%2sXXXXXX", ptr, prefix);
  mktemp (tmpname);

  return tmpname;
}


/* Some loosing Microsoft programs need backslashes in their
   filenames, give it to them.  */

char *
swap_back_slashify (char *path)
{
  char *p = path;
  while (*p)
    {
      if (*p == FSLASH)
	*p = BSLASH;
      p++;
    }
  return path;
}

/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
