/* sw_smart.c - look whether a command supports long commandlines.
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This file is part of SWAPLIB (the library), a library for efficient
   execution of child processes under MS-DOS.

   The library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/swaplib/RCS/sw_smart.c'v 0.9 90/09/09 21:44:11 tho Stable $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "swaplib.h"

extern void *xmalloc (size_t size);
static char *smart_programs (void);

#define DELIMITER ":"
#define SMART_PROGRAMS	"bash:make"

int
swap_smart_p (char *name)
{
  char *list = smart_programs ();
  char *tok;

  tok = strtok (list, DELIMITER);

  while (tok && strcmp (tok, name))
    tok = strtok (NULL, DELIMITER);

  free (list);
  return (tok != NULL);
}

char *
smart_programs (void)
{
  char *string = (char *) xmalloc (sizeof SMART_PROGRAMS);
  return strcpy (string, SMART_PROGRAMS);
}

/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
