/* sw_spve.c - spawn a child process.
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This file is part of SWAPLIB (the library), a library for efficient
   execution of child processes under MS-DOS.

   The library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/swaplib/RCS/sw_spve.c'v 0.9 90/09/09 21:44:18 tho Stable $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "swaplib.h"

char _swap_cmdline_buf[128] = "";
char *_swap_environ_buf = NULL;
char *_swap_respond_file_name = NULL;

/* This is the work horse and interface to the code in swap.c  */

int
swap_spawnve (char *cmd, char **argv, char **envvec)
{
  int length = -1;		/* failure */
  int rc = 0x02;		/* failure */
  int error = 0;
  int i = 0;
  char *swap_file_name;
  char *shell;
  enum swap_swapping_mode swapping;
  struct swap_respondfile_action *respondfiles;

  swap_file_name = swap_mktmpname ("vm");
  swapping = swap_set_swapping_mode (cmd, argv);


  /* Look whether we have to invoke a shell for executing
     this command.  */

  shell = swap_invoke_shell (cmd, &argv);
  if (shell)
    {
      cmd = shell;

      /* Provide a hook for doing fancy things with SHELL! */

      /* .... */
    }

  respondfiles = swap_set_respondfile_actions ();
  if (respondfiles)
    for (i = 0; respondfiles[i].prog; i++)
      if (strcmp (respondfiles[i].prog, argv[0]) == 0)
	break;

  if (respondfiles && respondfiles[i].prog)
    {
      /* This program requires special treatment.  */

      length = (*respondfiles[i].action) (argv, envvec);
    }
  else if (swap_smart_p (argv[0]))
    {
      /* This is a "smart" program, pass the arguments via the
	 environment.  */

      length = _swap_format_msdos_environment (argv, envvec, NULL);
    }
  else
    {
      /* This is a dumb program, use the MS-DOS commandline.  */

      if (_swap_build_cmdline (argv) == 0)
	length = _swap_format_msdos_environment (NULL, envvec, NULL);
    }

  if (length != -1)
    {
#ifdef TEST
  fprintf (stderr, "+ %s %s\n", cmd, _swap_cmdline_buf);
#endif

      /* We've given MS-DOS all the help we can offer, we will
	 rest now in a quieter storage medium and see what
	 happens.  */

      rc = _swap_spawn_child (swapping, cmd, _swap_cmdline_buf,
			      _swap_environ_buf, length, swap_file_name);


      /* Save ERRNO (the cleanup functions migth clobber it).  */
      if (rc == -1)
	error = errno;

#ifdef TEST
      fprintf (stderr, "child terminated with 0x%04x\n", rc);
#endif
    }

  /* Cleaning up  */

  strcpy (_swap_cmdline_buf, "");

  if (shell)
    {
      free (shell);

      /* We have to free this, since it is not the one
	 we've been passed!  */
      free (argv);
    }
  if (swap_file_name)
    free (swap_file_name);
  if (_swap_environ_buf)
    {
      free (_swap_environ_buf);
      _swap_environ_buf = NULL;
    }
  if (_swap_respond_file_name)	/* clean up disk */
    {
#ifndef TEST
      unlink (_swap_respond_file_name);
#else
      fprintf (stderr, "respondfile %s kept.\n", _swap_respond_file_name);
#endif
      free (_swap_respond_file_name);
      _swap_respond_file_name = NULL;
    }


  /* Set the ERRNO of COMMAND.  */
  errno = error;

  return rc;
}

/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
