/* sw_sys.c - invoke a shell to execute a command.
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This file is part of SWAPLIB (the library), a library for efficient
   execution of child processes under MS-DOS.

   The library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/swaplib/RCS/sw_sys.c'v 0.9 90/09/09 21:44:22 tho Stable $
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include "swaplib.h"

extern void *xmalloc (size_t size);

int
swap_system (char *command)
{
  char *argv[4];
  char *p = NULL;

  /* Find $SHELL or $COMSPEC  */

  argv[0] = getenv ("SHELL");
  if (argv[0])
    {
      argv[1] = "-c";
    }
  else
    {
      argv[0] = getenv ("COMSPEC");
      if (argv[0])
	{
	  argv[1] = "/c";
	}
      else
	{
	  errno = ENOENT;
	  return -1;
	}
    }

  if (command)
    {
      /* Let the shell execute COMMAND.  */

      argv[2] = command;
      argv[3] = NULL;

      return swap_spawnvpe (argv[0], argv, NULL);
    }
  else
    {
      /* Just check the existence of a shell.  */

      return 0;
    }
}

/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
