[ elec2.plt

# Electronics demo 2
#

paper size 11 by 8.5
format y 2
font 3

# Junction Field Effect Transistor (JFET) Mutual Characteristic
# drain current above pinch off

Ida(Vd)=Ido*(1-Vg/Vp)**2

# drain current below pinch off

Idb(Vd)=Ido*(2*Vd*(Vg-Vp)-Vd*Vd)/(Vp*Vp)

# drain current

Id(Vd)= (Vd>Vg-Vp) ? Ida(Vd) : Idb(Vd)

# drain current at zero gate voltage

Ido = 2.5

# pinch off voltage

Vp = -1.25

# gate voltage

Vg = 0
dummy Vd

title "JFET Mutual Characteristic"
map x 0 4 y 0 5
draw x y
frame
xlabel "Drain voltage Vd (V)"
ylabel "Drain current Id (mA)"

label "-0.5 Vp"     at 4.5, 2.75
label "-0.25 Vp"    at 4.5, 3.5
label "0"           at 4.5, 4.5
label "Vg = 0.5 Vp" at 4.5, 6

color lred

plot Vg=0.5*Vp,Id(Vd),Vg=0.25*Vp,Id(Vd),Vg=0,Id(Vd),Vg=-0.25*Vp,Id(Vd)
