VIDEO VOICE   version 1.0   August 13, 1987
Copyright 1986,1987 by Grassroots Computing
All Rights Reserved Worldwide

Note # 1:  If you are using your speech synthesizer to read
this documentation, DO NOT read it with the punctuation
turned off.

Note # 2:  There are some conflicts between the README.1ST
file on the disk, Appendix B and the rest of the
documentation.  In case of contradictory information, the
README.1ST file is the most current, followed by Appendix B,
followed by the rest of the documentation.

Appendix B:  Short description of each Command and Function.

DEFINE COORDINATES OF VIDEO VOICE WINDOW
PREFIX d w window-number ENTER

     Press the PREFIX key, followed by unshifted-"d" key (for
DEFINE), followed by the unshifted-"w" key (for WINDOW),
followed by a top row number key from "1" through "9",
followed by the ENTER key to choose the Video Voice window
that you want to define.  In response to the prompt, enter a
number from "1" through "25" using the top row number keys,
followed by the ENTER key to define the top row of the new
Video Voice window. In response to the prompt, enter a number
from "1" through "80" using the top row number keys, followed
by the ENTER key to define the left most column of the new
Video Voice window.  In response to the prompt, enter a
number from "1" through "25" using the top row number keys,
followed by the ENTER key to define the bottom row of the new
Video Voice window.  In response to the prompt, enter a
number from "1" through "80" using the top row number keys,
followed by the ENTER key to define the right most column of
the new Video Voice window.  Lastly, in response to the
prompt, type in a name, with a maximum length of 40
characters, for the window you have defined and press the
ENTER key.  Video Voice will now speak a status report
describing the window you just defined.
     While defining a window, press the ESCAPE key to abort. 
Window "0" is always the whole screen.

DEFINE MARKER
PREFIX d m marker-number ENTER

     Press the PREFIX key, followed by the unshifted-"d" key
(for DEFINE), followed by the unshifted-"m" key (for MARKER),
followed by a top row number key from "0" through "9",
followed by the ENTER key to cause a marker to be set at the
current Review Mode cursor location.

DEFINE NEW PREFIX
PREFIX d p New_Prefix ENTER

     Press the PREFIX key, followed by the unshifted-"d" key
(for DEFINE), followed by the unshifted-"p" key for PREFIX,
followed by a new PREFIX key, followed by the ENTER key to
define a new PREFIX.  If an invalid key is pressed for new
PREFIX an error message will be spoken.  If the cursor keys
are pressed the choice will cycle through the function keys. 
This New PREFIX key will stay in effect until either the
computer is restarted or the new PREFIX is again redefined. 
The new PREFIX key may be any Function Key (Function 1
through Function 10) or any CONTROL-Function key combination,
any ALT-Function key combination or any SHIFT-Function key
combination.  The default Prefix is the Function 9 key.

DESIGNATE NUMBER OF NON-SPACE DUPLICATE CHARACTERS TO COUNT
PREFIX ALT-0 number-of-non-spaces ENTER

     Press the PREFIX key, followed by the ALT-"0"
combination, followed by a number using the top row number
keys, followed by the ENTER key to designate the number of
adjacent duplicate characters to trigger the beginning of a
count.  If a number less than 4 is selected the count is
automatically reset to 4, which is the default.  If adjacent
duplicate characters have intervening spaces, all the
characters are counted.  If a run of duplicates is terminated
by any other character or the end of the line, the total is
announced and counting begins again at 0.  Duplicate digits
are never counted.

DESIGNATE NUMBER OF SPACES TO COUNT
PREFIX ALT-9 number-of-spaces ENTER

     Press the PREFIX key, followed by the ALT-"9"
combination, followed by a number using the top row number
keys, followed by the ENTER key to select the number of
spaces to count.  While reading text, the number of adjacent
spaces encountered is announced and counted until a nonspace
character is encountered.  If "0" is selected, spaces are NOT
counted or spoken.  If "1" is selected "space" is spoken for
every space.  The default is "0".

ENTER REVIEW MODE
PREFIX Function 10

     Press the PREFIX key, followed by the Function 10 key to
enter Review Mode.  It is only necessary to enter Review Mode
when you wish to freeze the screen, and move the Review Mode
cursor about the screen.  When Review Mode is entered, a
Review Mode cursor is created at the same location as the
real-time cursor.  When using a Video Voice search command in
Review Mode, it is often useful to first use the HOME key to
move the Review Mode cursor to the top row of the screen or
active Video Voice window.

ENUNCIATE CONTENTS OF DESIGNATED VIDEO VOICE WINDOW
PREFIX SHIFT-S w window-number ENTER

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the unshifted-"w" key (for WINDOW),
followed by a top row number key from "0" through "9",
followed by the ENTER key to enunciate the contents of the
designated Video Voice window.  The designated Video Voice
window need not be the active Video Voice window, but it must
have been previously defined.  Video Voice window "0" is
always the whole screen. The real-time cursor is not moved. 
The default window-number is "0": the Whole Screen.

ENUNCIATE CURRENT PARAGRAPH
PREFIX SHIFT-S l

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the unshifted-"l" key to enunciate
the whole current paragraph, regardless of the location of
the cursor within the paragraph.  The real-time cursor is not
moved.

ENUNCIATE CURRENT ROW
PREFIX SHIFT-S ' (apostrophe)

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the "'" (apostrophe) to enunciate
the contents of the current row in the screen or active Video
Voice window.  The real-time cursor is not moved.

ENUNCIATE CURRENT SCREEN
PREFIX SHIFT-S ` (back accent or grave accent)

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the "`" key (back-accent) to
enunciate the contents of the whole screen or active Video
Voice window.  The real-time cursor is not moved.

ENUNCIATE CURRENT SENTENCE
PREFIX SHIFT-S k

     Press the PREFIX key, followed by the unshifted-"k" key
to enunciate the whole current sentence, regardless of the
location of the cursor within the sentence.  The real-time
cursor is not moved.

ENUNCIATE CURRENT WORD
PREFIX SHIFT-S j

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the unshifted-"j" key to enunciate
the whole current word, regardless of the location of the
cursor within the word.  The real-time cursor is not moved.

ENUNCIATE FIRST PART OF CURRENT PARAGRAPH
PREFIX SHIFT-S SHIFT-L

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the SHIFT-"l" combination to
enunciate from the beginning of the paragraph to the end of
the row which contains the cursor.  The real-time cursor is
not moved.

ENUNCIATE FIRST PART OF CURRENT ROW
PREFIX SHIFT-S SHIFT-' (apostrophe)

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the SHIFT-"'" (SHIFT-apostrophe)
combination (quotation mark) to enunciate from the beginning
of the row to the location of the cursor.  The real-time
cursor is not moved.

ENUNCIATE FIRST PART OF CURRENT SENTENCE
PREFIX SHIFT-S SHIFT-K

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the SHIFT-"k" combination to
enunciate from the beginning of the sentence to the end of
the word which contains the cursor.  The real-time cursor is
not moved.

ENUNCIATE FIRST PART OF THE CURRENT WORD
PREFIX SHIFT-S SHIFT-J

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the SHIFT-"j" combination to
enunciate the first part of the current word.  The
enunciation will include the character the cursor is on.  The
real-time cursor is not moved.

ENUNCIATE FIRST PART OF SCREEN
PREFIX SHIFT-S SHIFT-` (back accent or grave accent)

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the SHIFT-"`" (SHIFT-back accent)
combination (tilde) to enunciate from the top left-hand
corner of the screen or active Video Voice window to the end
of the row that contains the cursor.  The real-time cursor is
not moved.

ENUNCIATE FOLLOWING PARAGRAPH
PREFIX SHIFT-S . (period)

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the unshifted-"." key (period) to
enunciate the contents of the following paragraph.  If the
new paragraph begins on a following row, descending beeps are
sounded.  The real-time cursor is not moved.

ENUNCIATE FOLLOWING ROW
PREFIX SHIFT-S ] (right bracket)

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the "]" key (right bracket) to
enunciate the contents of the following row.  Descending
beeps are sounded to indicate the location of the following
row.  The "]" (right bracket) key is an exception to the
normal Video Voice key pattern.  The real-time cursor is not
moved.

ENUNCIATE FOLLOWING SENTENCE
PREFIX SHIFT-S , (comma)

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the unshifted-"," key (comma) to
enunciate the contents of the following sentence.  If the new
sentence begins on a following row, descending beeps are
sounded.  The real-time cursor is not moved.

ENUNCIATE FOLLOWING WORD
PREFIX SHIFT-S m

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the unshifted-"m" key to enunciate
the following word.  If the new word is on a following row,
descending beeps are sounded.  The real-time cursor is not
moved.

ENUNCIATE LAST PART OF CURRENT PARAGRAPH
PREFIX SHIFT-S ALT-l

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the ALT-"l" combination to enunciate
from the beginning of the row which contains the cursor to
the end of the current paragraph.  The real-time cursor is
not moved.

ENUNCIATE LAST PART OF CURRENT ROW
PREFIX SHIFT-S ALT-' (apostrophe)

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the ALT-"'" (ALT-apostrophe)
combination to enunciate from the location of the cursor to
the end of the current row.  The real-time cursor is not
moved.

ENUNCIATE LAST PART OF CURRENT SENTENCE
PREFIX SHIFT-S ALT-k

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the ALT-"k" combination to enunciate
from the beginning of the word which contains the cursor to
the end of the sentence.  The real-time cursor is not moved.

ENUNCIATE LAST PART OF CURRENT WORD
PREFIX SHIFT-S ALT-j

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the ALT-"j" combination to enunciate
the last part of the current word.  The enunciating will
include the character the cursor is on.  The real-time cursor
is not moved.

ENUNCIATE LAST PART OF SCREEN
PREFIX SHIFT-S ALT-` (back accent or grave accent)

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the ALT-"`" (ALT-back accent)
combination to enunciate from the beginning of the row that
contains the cursor to the lower right-hand corner of the
screen or active Video Voice window. The real-time cursor is
not moved.

ENUNCIATE PREVIOUS PARAGRAPH
PREFIX SHIFT-S o

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the unshifted-"o" key to enunciate
the contents of the previous paragraph.  Ascending beeps are
sounded to indicate the row where the paragraph begins.  The
real-time cursor is not moved.

ENUNCIATE PREVIOUS ROW
PREFIX SHIFT-S [ (left bracket)

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the "[" key (left bracket) to
enunciate the contents of the previous row.  Ascending beeps
are sounded to indicate the row that was spoken.  The "[" key
(left bracket) is an exception to the normal key pattern. 
The real-time cursor is not moved.

ENUNCIATE PREVIOUS SENTENCE
PREFIX SHIFT-S i

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the unshifted-"i" key to enunciate
the contents of the previous sentence.  If the new sentence
begins on a previous row, ascending beeps are sounded.  The
real-time cursor is not moved.

ENUNCIATE PREVIOUS WORD
PREFIX SHIFT-S u

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the unshifted-"u" key to enunciate
the previous word.  If the new word is on a previous row,
ascending beeps are sounded.  The real-time cursor is not
moved.

ENUNCIATE ROW AT BOTTOM OF SCREEN
PREFIX SHIFT-S END

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the END key to have Video Voice
enunciate the row at the bottom of the screen.  This row is
also known as row 25.

ENUNCIATE ROW AT TOP OF SCREEN
PREFIX SHIFT-S HOME

     Press the PREFIX key, followed by the SHIFT-"s"
combination, followed by the HOME key to have Video Voice
enunciate the row at the top of the screen.  This row is also
known as row 1.

GET HELP
PREFIX Function 1

     Press the PREFIX key, followed by the Function key 1 to
enter the Video Voice help menu system.  The main menu title
will be spoken.  Use the cursor keys and letter keys to move
through the help menus.  If no help files are found, or the
help system is not in memory the program will speak an error
message.

LEAVE REVIEW MODE
ESCAPE

     Press the ESCAPE key to leave Review Mode.

MOVE REVIEW MODE CURSOR DOWN ONE CHARACTER
(in REVIEW MODE) DOWN-CURSOR

     While in Review Mode, press the DOWN-CURSOR key to move
the Review Mode cursor to the SAME COLUMN in the following
row.  A two-tone descending beep is sounded to indicate the
new row.  The new character is spoken.

MOVE REVIEW MODE CURSOR TO BOTTOM OF SCREEN
(in REVIEW MODE) END

     While in Review Mode, press the END key to move the
Review Mode cursor to the first column of the bottom row of
the screen or active Video Voice window.  A low-pitched beep
is sounded to indicate the bottom of the screen or active
Video Voice window.  The word "bottom", and the contents of
the new row are spoken.

MOVE REVIEW MODE CURSOR TO DESIGNATED COLUMN IN CURRENT ROW
(in REVIEW MODE) f c column-number ENTER

     While in Review Mode, press the unshifted-"f" key (for
FIND), followed by the unshifted-"c" key (for COLUMN),
followed by a number from "1" through "80" using the top row
number keys, followed by the ENTER key to move the Review
Mode cursor to the designated column on the current row.  The
character at the new column is spoken.  If a Video Voice
window is active (rather than the whole screen) and the
designated column is outside the active Video Voice window,
an error message is spoken.

MOVE REVIEW MODE CURSOR TO DESIGNATED MARKER
(in REVIEW MODE) f m marker-number ENTER

     While in Review Mode, press the unshifted-"f" key (for
FIND), followed by the unshifted-"m" key (for MARKER),
followed a top row number key from "0" through "9", followed
by the ENTER key to choose the marker to move the Review Mode
cursor to.  If the desired marker has previously been set
with the DEFINE MARKER command, the Review Mode cursor will
move to the location of the designated marker.  A beep is
sounded to indicate the row to which the Review Mode cursor
has moved.  The contents of the new row are spoken.  If the
designated marker does not exist, an error message is spoken. 
If a Video Voice window is active (rather than the whole
screen) and if the designated marker is outside the active
Video Voice window, an error message is spoken.

MOVE REVIEW MODE CURSOR TO DESIGNATED SCREEN ROW
(in REVIEW MODE) f r row-number ENTER

     While in Review Mode, press the unshifted-"f" key (for
FIND), followed by the unshifted-"r" key (for ROW), followed
by a number from "1" through "25" using the top row number
keys, followed by the ENTER key to move the Review Mode
cursor to the left most column of the designated row.  A beep
is sounded to indicate the new row.  The contents of the new
row are spoken. If a Video Voice window is active (rather
than the whole screen) and if the designated row is outside
the active Video Voice window, an error message is spoken.

MOVE REVIEW MODE CURSOR TO DESIGNATED TEXT
(in REVIEW MODE) f t text-to-find ENTER

     While in Review Mode, press the unshifted-"f" key (for
FIND), followed by the unshifted-"t" key (for TEXT), followed
by the text you want to find, followed by the ENTER key to
move the Review Mode cursor from the current location to the
first character of the next occurrence of the designated
text.  Press the unshifted-"f" key, followed by the
unshifted-"t" key, followed by the ENTER key to search again
for the last designated text.  A beep is sounded to indicate
the new row.  The contents of the new row are spoken.  If the
designated text is not found, an error message is spoken. 
The text search is not case specific.

MOVE REVIEW MODE CURSOR TO FOLLOWING CHARACTER
(in REVIEW MODE) n, or
(in REVIEW MODE) RIGHT-CURSOR

     While in Review Mode, press the unshifted-"n" key or the
RIGHT-CURSOR key to move the Review Mode cursor to the
following column in the same screen or active Video Voice
window.  The character at the new Review Mode cursor location
is spoken.  If the Review Mode cursor is in the right most
column of the screen or active Video Voice window, the Review
Mode cursor will move to the left most column of the
following row.

MOVE REVIEW MODE CURSOR TO FOLLOWING PARAGRAPH
(in REVIEW MODE) . (period)

     While in Review Mode, press the unshifted-"." key
(period) to move the Review Mode cursor to the first
character of the following paragraph.  The new paragraph is
spoken.  The new paragraph may begin on any following row;
descending beeps are sounded.  If there is no following
paragraph, a beep is sounded.

MOVE REVIEW MODE CURSOR TO FOLLOWING ROW
(in REVIEW MODE) ] (right bracket), or
(in REVIEW MODE) CONTROL-DOWN-CURSOR, or
(in REVIEW MODE) ENTER

     While in Review Mode, press the "]" key (right bracket),
or the CONTROL-DOWN-CURSOR combination to move the Review
Mode cursor to the left most column of the following row.  A
two-tone descending beep is sounded.  The contents of the new
row are spoken.  The ENTER key also moves the Review Mode
cursor forward one row, but only in Review Mode.  The "]" key
(right bracket) is an exception to the normal Video Voice key
pattern.

MOVE REVIEW MODE CURSOR TO FOLLOWING SENTENCE
(in REVIEW MODE) , (comma)

     While in Review Mode, press the unshifted-"," key
(comma) to move the Review Mode cursor to the first character
of the following sentence.  The new sentence is spoken.  The
new sentence may begin on any following row; descending beeps
are sounded.

MOVE REVIEW MODE CURSOR TO FOLLOWING WORD
(in REVIEW MODE) m, or
(in REVIEW MODE) CONTROL-RIGHT-CURSOR

     While in Review Mode, press the unshifted-"m" key or the
CONTROL-RIGHT-CURSOR combination to move the Review Mode
cursor to the first character of the following word.  The new
word is spoken.  The new word may be on any following row;
descending beeps are sounded.  If there is no following word,
a beep is sounded.

MOVE REVIEW MODE CURSOR TO PREVIOUS CHARACTER
(in REVIEW MODE) y, or
(in REVIEW MODE) LEFT-CURSOR

     While in Review Mode, press the unshifted-"y" key or the
LEFT-CURSOR key to move the Review Mode cursor to the
preceding column in the screen or active Video Voice window. 
The character at the new Review Mode cursor location is
spoken.  If the Review Mode cursor is in the left most column
of the screen or active Video Voice window, the Review Mode
cursor will move to the right most column of the previous
row.  If there is no previous character, a beep is sounded.

MOVE REVIEW MODE CURSOR TO PREVIOUS PARAGRAPH
(in REVIEW MODE) o

     While in Review Mode, press the unshifted-"o" key to
move the Review Mode cursor to the first character of the
paragraph previous to the current paragraph.  The new
paragraph is spoken.  The new paragraph may begin on any
previous row; ascending beeps are sounded.

MOVE REVIEW MODE CURSOR TO PREVIOUS ROW
(in REVIEW MODE) [ (left bracket), or
(in REVIEW MODE) CONTROL-UP-CURSOR

     While in Review Mode, press the "[" key (left bracket)
or the CONTROL-UP-CURSOR combination to move the Review Mode
cursor to the left most column of the previous row.  A
two-tone ascending beep is sounded.  The contents of the new
row are spoken.

MOVE REVIEW MODE CURSOR TO PREVIOUS SENTENCE
( in REVIEW MODE) i

     While in Review Mode, press the unshifted-"i" key to
move the Review Mode cursor to the first character of the
previous sentence.  The new sentence is spoken.  The new
sentence may be on any previous row; ascending beeps are
sounded.

MOVE REVIEW MODE CURSOR TO PREVIOUS WORD
(in REVIEW MODE) u, or
(in REVIEW MODE) CONTROL-LEFT-CURSOR

     While in Review Mode, press the unshifted-"u" key or the
CONTROL-LEFT-CURSOR combination to move the Review Mode
cursor to the first character of the previous word.  The new
word is spoken.  The new word may be on any previous row;
ascending beeps are sounded.

MOVE REVIEW MODE CURSOR TO REAL-TIME CURSOR LOCATION
(in REVIEW MODE) f HOME

     While in Review Mode, press the unshifted-"f" key (for
FIND), followed by the HOME key to move the Review Mode
cursor to the location of the real-time cursor.  A beep is
sounded to indicate the new row.

MOVE REVIEW MODE CURSOR TO TEXT IN DESIGNATED ATTRIBUTE
(in REVIEW MODE) f a attribute-number ENTER

     While in Review Mode, press the unshifted-"f" key (for
FIND), followed by the unshifted-"a" key (for ATTRIBUTE),
followed by a top row number key from "0" through "9",
followed by the ENTER key to move the Review Mode cursor to
text in the designated attribute.  The valid attribute
designations are : (1) blue on color monitors, underline on
high-resolution monochrome monitors, (2) green, (3) cyan,
also turquoise, (4) red, also pink, (5) magenta, also purple,
(6) yellow, also orange and brown depending on the individual
monitor, (7) normal white, (8) dim white (also grey), (9)
bright white, also high intensity white, (0) reverse video,
also inverse video.  After the unshifted-"a" key (for
ATTRIBUTE) is pressed, the attribute last designated will be
spoken.  If you want to search again for that attrubute,
press the ENTER key without entering a number.  The cursor
keys can also be used to select the desired attribute.  The
designated attribute will be found whether it is a foreground
or background attribute.  If the designated attribute is not
found, an error message is spoken.  The default attribute is
"0": Reverse Video.

MOVE REVIEW MODE CURSOR TO TEXT IN DESIGNATED BACKGROUND
ATTRIBUTE
(in REVIEW MODE) f a ALT-attribute-number ENTER

     While in Review Mode, press the unshifted-"f" key (for
FIND), followed by the unshifted-"a" key (for ATTRIBUTE),
followed by an ALT-top row number key combination from "0"
through "9", followed by the ENTER key to move the Review
Mode cursor to text in the designated background attribute. 
The valid attribute designations are : (1) blue on color
monitors, underline on high-resolution monochrome monitors,
(2) green, (3) cyan, also turquoise, (4) red, also pink, (5)
magenta, also purple, (6) yellow, also orange and brown
depending on the individual monitor, (7) normal white, (8)
dim white (also grey), (9) bright white, high intensity
white, (0) reverse video, also inverse video.  After the
unshifted-"a" key (for ATTRIBUTE) is pressed, the attribute
last designated will be spoken.  If you want to search again
for that attrubute, press the ENTER key without entering a
number.  The cursor keys can also be used to select the
desired attribute.  The designated attribute ONLY APPLIES TO
THE BACKGROUND COLOR, not the color of the foreground.  If
the designated attribute is not found, an error message is
spoken.  The default attribute is "0": Reverse Video.

MOVE REVIEW MODE CURSOR TO TEXT IN DESIGNATED FOREGROUND
ATTRIBUTE
(in REVIEW MODE) f a SHIFT-attribute-number ENTER

     While in Review Mode, press the unshifted-"f" key (for
FIND), followed by the unshifted-"a" key (for ATTRIBUTE),
followed by a shifted top row number key from "0" through
"9", followed by the ENTER key to move the Review Mode cursor
to text in the designated foreground attribute.  The valid
attribute designations are: (1) blue on color monitors,
underline on high-resolution monochrome monitors, (2) green,
(3) cyan, also turquoise, (4) red, also pink, (5) magenta,
also purple, (6) yellow, also orange and brown depending on
the individual monitor, (7) normal white, (8) dim white (also
grey), (9) bright white, also high intensity white, (0)
reverse video, also inverse video.  After the unshifted-"a"
key (for ATTRIBUTE) is pressed, the attribute last designated
will be spoken.  If you want to search again for that
attrubute, press the ENTER key without entering a number. 
The cursor keys can also be used to select the desired
attribute.  The designated attribute ONLY APPLIES TO THE
FOREGROUND COLOR, not the color of the background.  If the
designated attribute is not found, an error message is
spoken.  The default attribute is "0": Reverse Video.

MOVE REVIEW MODE CURSOR TO TOP OF SCREEN
(in REVIEW MODE) HOME

     While in Review Mode, press the HOME key to move the
Review Mode cursor to the first column of the top row of the
screen or active Video Voice window.  A high-pitched beep is
sounded to indicate the top of the screen or active Video
Voice window.  The word "top", and the contents of the new
row are spoken.

MOVE REVIEW MODE CURSOR UP ONE CHARACTER
(in REVIEW MODE) UP-CURSOR

     While in Review Mode, press the UP-CURSOR key to move
the Review Mode cursor to the SAME COLUMN in the previous
row.  A two-tone ascending beep is sounded to indicate the
new row.  The new character is spoken.

PREFIX command

     Press the Function 9 key followed by any non-movement
Video Voice command key to perform that Video-Voice command. 
Press the Function 9 key twice in a row to send a Function 9
keystroke to the applications program.  If you have redefined
your PREFIX key in the configuration file or by using the
DEFINE NEW PREFIX command, then the Function 9 key will have
no meaning to Video Voice.

QUIET
left-SHIFT and right-SHIFT, or
PREFIX ESCAPE

     Press the PREFIX key, followed by the ESCAPE key to
cause the synthesizer to stop speaking, and remain silent
until the next key has been pressed.  Pressing the left-SHIFT
key and the right-SHIFT key at the same time will also cause
the synthesizer to stop speaking.  The double-SHIFT
combination gives faster response than the PREFIX-ESCAPE
sequence, but may not work on some compatibles.  Depending on
the model synthesizer and how much text has been sent to it,
there may occasionally be a delay before the synthesizer
stops speaking.

READ CHARACTER AT DESIGNATED COLUMN IN CURRENT ROW
PREFIX f c column-number ENTER

     Press the PREFIX key, followed by the unshifted-"f" key
(for FIND), followed by the unshifted-"c" key (for COLUMN),
followed by a number from "1" through "80" using the top row
number keys, followed by the ENTER key to read the character
at the designated column on the current row.  If a Video
Voice window is active (rather than the whole screen) and if
the designated column is outside the active Video Voice
window, an error message is spoken.  The Review Mode cursor
is not moved.

READ COLUMN OF CHARACTERS
PREFIX ALT-SHIFT-H

     Press the PREFIX key, followed by the ALT-SHIFT-"h"
combination to read all the characters that are in the same
screen column, starting at the top row of the screen or
active Video Voice window and continuing downward until the
bottom of the screen or active Video Voice window is reached.
The real-time cursor is not moved.

READ COLUMN OF WORDS
PREFIX ALT-SHIFT-J

     Press the PREFIX key, followed by the ALT-SHIFT-"j"
combination to read all the words that are in the same screen
column, starting at the top row of the screen or active Video
Voice window and continuing downward until the bottom of the
screen or active Video Voice window is reached.  The
real-time cursor is not moved.

READ CONTENTS OF BOX
PREFIX f b

     Press the PREFIX key, followed by the unshifted-"f" key
(for FIND), followed by the unshifted-"b" key (for BOX) to
read the contents of the first box (also known as a "pop-up
window") on the screen.  A "pop-up window" that does not have
a "frame" will NOT be found.  Any active Video Voice window
is ignored.
     If the box is found from inside Review Mode by typing an
unshifted-"f" followed by an unshifted-"b" with no PREFIX,
then a temporary window is automatically defined and made
active.  Thus, it is possible to move about within the box,
disregarding the rest of the screen.  Press the ESCAPE key to
exit from the box.  The real-time cursor is not moved.

READ CONTENTS OF DESIGNATED VIDEO VOICE WINDOW
PREFIX r w window-number ENTER

     Press the PREFIX key, followed by the unshifted-"r" key
(for READ), followed by the unshifted-"w" key (for WINDOW),
followed by a top row number key from "0" through "9",
followed by the ENTER key to read the contents of the
designated Video Voice window.  The designated Video Voice
window need not be the active Video Voice window, but it must
have been previously defined.  Video Voice window "0" is
always the whole screen.  The real-time cursor is not moved. 
The default window-number is "0": the Whole Screen.

READ CURRENT CHARACTER
PREFIX h

     Press the PREFIX key, followed by the unshifted-"h" key
to read the character at the current real-time cursor
location. The real-time cursor is not moved.

READ CURRENT PARAGRAPH
PREFIX l

     Press the PREFIX key, followed by the unshifted-"l" key
to read the whole current paragraph, regardless of the
location of the cursor within the paragraph.  The real-time
cursor is not moved.

READ CURRENT ROW
PREFIX ' (apostrophe)

     Press the PREFIX key, followed by the "'" (apostrophe)
to read the contents of the current row in the screen or
active Video Voice window.  The real-time cursor is not
moved.

READ CURRENT SCREEN
PREFIX ` (back accent or grave accent)

     Press the PREFIX key, followed by the "`" key
(back-accent) to read the contents of the whole screen or
active Video Voice window. The real-time cursor is not moved.

READ CURRENT SENTENCE
PREFIX k

     Press the PREFIX key, followed by the unshifted-"k" key
to read the whole current sentence, regardless of the
location of the cursor within the sentence.  The real-time
cursor is not moved.

READ CURRENT WORD
PREFIX j

     Press the PREFIX key, followed by the unshifted-"j" key
to read the whole current word, regardless of the location of
the cursor within the word.  The real-time cursor is not
moved.

READ DESIGNATED FIRST PART OF SCREEN
PREFIX PAGE UP row-number ENTER

     Press the PREFIX key, followed by the PAGE UP key,
followed by a number from "1" through "25" using the top row
number keys, followed by the ENTER key to read from the top
left-hand corner of the screen or active Video Voice window
to the end of the designated row.  The real-time cursor is
not moved.

READ DESIGNATED LAST PART OF SCREEN
PREFIX PAGE DOWN row-number ENTER

     Press the PREFIX key, followed by the PAGE DOWN key,
followed by a number from "1" through "25" using the top row
number keys, followed by the ENTER key to read from the
beginning of the designated row to the lower right-hand
corner of the screen or active Video Voice window.  The
real-time cursor is not moved.

READ DESIGNATED SCREEN ROW
PREFIX f r row-number ENTER

     Press the PREFIX key, followed by the unshifted-"f" key
(for FIND), followed by the unshifted-"r" key (for ROW),
followed by a number from "1" through "25" using the top row
number keys, followed by the ENTER key to read the contents
of the designated row.  A beep is sounded to indicate the
row.  If a Video Voice window is active (rather than the
whole screen) and if the designated row is outside the active
Video Voice window, an error message is spoken.  The
real-time cursor is not moved.

READ FIRST PART OF COLUMN OF CHARACTERS
PREFIX SHIFT-H

     Press the PREFIX key, followed by the SHIFT-"h"
combination to read all the characters that are in the same
screen column, starting at the top row of the screen or
active Video Voice window and continuing downward until the
character in the current row has been spoken.  The real-time
cursor is not moved.

READ FIRST PART OF COLUMN OF WORDS
PREFIX SHIFT-J

     Press the PREFIX key, followed by the SHIFT-"j"
combination to read all the words that are in the same screen
column, starting at the top row of the screen or active Video
Voice window and continuing downward until the word in the
current row has been spoken.  The real-time cursor is not
moved.

READ FIRST PART OF CURRENT PARAGRAPH
PREFIX SHIFT-L

     Press the PREFIX key, followed by the SHIFT-"l"
combination to read from the beginning of the paragraph to
the end of the row which contains the cursor.  The real-time
cursor is not moved.

READ FIRST PART OF CURRENT ROW
PREFIX SHIFT-' (apostrophe)

     Press the PREFIX key, followed by the SHIFT-"'"
(SHIFT-apostrophe) combination (quotation mark) to read from
the beginning of the row to the location of the cursor.  The
real-time cursor is not moved.

READ FIRST PART OF CURRENT SENTENCE
PREFIX SHIFT-K

     Press the PREFIX key, followed by the SHIFT-"k"
combination to read from the beginning of the sentence to the
end of the word which contains the cursor.  The real-time
cursor is not moved.

READ FIRST PART OF SCREEN
PREFIX SHIFT-` (back accent or grave accent)

     Press the PREFIX key, followed by the SHIFT-"`"
(SHIFT-back accent) combination (tilde) to read from the top
left-hand corner of the screen or active Video Voice window
to the end of the row that contains the cursor.  The
real-time cursor is not moved.

READ FOLLOWING CHARACTER
PREFIX n

     Press the PREFIX key, followed by the unshifted-"n" key
to read the following character.  If the new character is on
the following row, a descending beep is sounded.  The
real-time cursor is not moved.

READ FOLLOWING PARAGRAPH
PREFIX . (period)

     Press the PREFIX key, followed by the unshifted-"." key
(period) to read the contents of the following paragraph.  If
the new paragraph begins on a following row, descending beeps
are sounded.  The real-time cursor is not moved.

READ FOLLOWING ROW
PREFIX ] (right bracket)

     Press the PREFIX key, followed by the "]" key (right
bracket) to read the contents of the following row. 
Descending beeps are sounded to indicate the location of the
following row.  The "]" (right bracket) key is an exception
to the normal Video Voice key pattern.  The real-time cursor
is not moved.

READ FOLLOWING SENTENCE
PREFIX , (comma)

     Press the PREFIX key, followed by the unshifted-"," key
(comma) to read the contents of the following sentence.  If
the new sentence begins on a following row, descending beeps
are sounded.  The real-time cursor is not moved.

READ FOLLOWING WORD
PREFIX m

     Press the PREFIX key, followed by the unshifted-"m" key
to read the following word.  If the new word is on a
following row, descending beeps are sounded.  The real-time
cursor is not moved.

READ LAST PART OF COLUMN OF CHARACTERS
PREFIX ALT-h

     Press the PREFIX key, followed by the ALT-"h"
combination to read all the characters that are in the same
screen column, starting at the current row and continuing
downward until the bottom of the screen or active Video Voice
window has been reached.  The real-time cursor is not moved.

READ LAST PART OF COLUMN OF WORDS
PREFIX ALT-j

     Press the PREFIX key, followed by the ALT-"j"
combination to read all the words that are in the same screen
column, starting at the current row and continuing downward
until the bottom of the screen or active Video Voice window
has been reached.  The real-time cursor is not moved.

READ LAST PART OF CURRENT PARAGRAPH
PREFIX ALT-l

     Press the PREFIX key, followed by the ALT-"l"
combination to read from the beginning of the row which
contains the cursor to the end of the current paragraph.  The
real-time cursor is not moved.

READ LAST PART OF CURRENT ROW
PREFIX ALT-' (apostrophe)

     Press the PREFIX key, followed by the ALT-"'"
(ALT-apostrophe) combination to read from the location of the
cursor to the end of the current row.  The real-time cursor
is not moved.

READ LAST PART OF CURRENT SENTENCE
PREFIX ALT-k

     Press the PREFIX key, followed by the ALT-"k"
combination to read from the beginning of the word which
contains the cursor to the end of the sentence.  The
real-time cursor is not moved.

READ LAST PART OF SCREEN
PREFIX ALT-` (back accent or grave accent)

     Press the PREFIX key, followed by the ALT-"`" (ALT-back
accent) combination to read from the beginning of the row
that contains the cursor to the lower right-hand corner of
the screen or active Video Voice window.  The real-time
cursor is not moved.

READ PREVIOUS CHARACTER
PREFIX y

     Press the PREFIX key, followed by the unshifted-"y" key
to read the previous character. If the previous character is
on a previous row, an ascending beep is sounded. The
real-time cursor is not moved.

READ PREVIOUS PARAGRAPH
PREFIX o

     Press the PREFIX key, followed by the unshifted-"o" key
to read the contents of the previous paragraph.  Ascending
beeps are sounded to indicate the row where the paragraph
begins.  The real-time cursor is not moved.

READ PREVIOUS ROW
PREFIX [ (left bracket)

     Press the PREFIX key, followed by the "[" key (left
bracket) to read the contents of the previous row.  Ascending
beeps are sounded to indicate the row that was spoken.  The
"[" key (left bracket) is an exception to the normal key
pattern.  The real-time cursor is not moved.

READ PREVIOUS SENTENCE
PREFIX i

     Press the PREFIX key, followed by the unshifted-"i" key
to read the contents of the previous sentence.  If the new
sentence begins on a previous row, ascending beeps are
sounded.  The real-time cursor is not moved.

READ PREVIOUS WORD
PREFIX u

     Press the PREFIX key, followed by the unshifted-"u" key
to read the previous word.  If the new word is on a previous
row, ascending beeps are sounded.  The real-time cursor is
not moved.

READ ROW AT BOTTOM OF SCREEN
PREFIX END

     Press the PREFIX key, followed by the END key to have
Video Voice read the row at the bottom of the screen.  This
row is also known as row 25.

READ ROW AT TOP OF SCREEN
PREFIX HOME

     Press the PREFIX key, followed by the HOME key to have
Video Voice read the row at the top of your screen.  This row
is also known as row 1.

READ ROW WITH DESIGNATED MARKER
PREFIX f m marker-number ENTER

     Press the PREFIX key, followed by the unshifted-"f" key
(for FIND), followed by the unshifted- "m" key (for MARKER),
followed by a top row number key from "0" through "9",
followed by the ENTER key to read the row with the designated
marker number.  Video Voice searches for the designated
marker, which had previously been set with the DEFINE MARKER
command.  If the marker is encountered, the contents of the
row in which the marker is encountered will be spoken.  A
beep is sounded to indicate the row the marker is on.  If no
marker is found, an error message is spoken.  If a Video
Voice window is active (rather than the whole screen) and if
the designated marker is outside the active Video Voice
window, an error message is spoken. The real-time cursor is
not moved.

READ ROWS WITH DESIGNATED TEXT
PREFIX f t text-to-find ENTER

     Press the PREFIX key, followed by the unshifted-"f" key
(for FIND), followed by the unshifted-"t" key (for TEXT),
followed by the text you want to find, followed by the ENTER
key to read the contents of all rows with the designated
text.  Press the PREFIX key, followed by the unshifted-"f"
key, followed by the unshifted-"t" key, followed by the ENTER
key to search again for the last designated text.  The search
begins at the top of the screen or active Video Voice window
and continues to the bottom of the screen or active Video
Voice window.  If the designated text is found, the text of
that whole row is spoken and the search continues.  A beep is
sounded to indicate the row which is spoken.  If the
designated text is not found, an error message is spoken. 
The real-time cursor is not moved.  Text searches are not
case specific.

READ TEXT IN DESIGNATED ATTRIBUTE
PREFIX f a attribute-number ENTER

     Press the PREFIX key, followed by the unshifted-"f" key
(for FIND), followed by the unshifted-"a" key (for
ATTRIBUTE), followed by a top row number key from "0" through
"9", followed by the ENTER key to read text in the designated
attribute.  The valid attribute designations are : (1) blue
on color monitors, underline on high-resolution monochrome
monitors, (2) green, (3) cyan, also turquoise, (4) red, also
pink, (5) magenta, also purple, (6) yellow, also orange and
brown depending on the individual monitor, (7) normal white,
(8) dim white (also grey), (9) bright white, also high
intensity white, (0) reverse video, also inverse video. 
After the unshifted-"a" key (for ATTRIBUTE) is pressed, the
attribute last designated will be spoken.  If you want to
search again for that attribute, press the ENTER key without
entering a number.  The cursor keys can also be used to
select the desired attribute.  The designated attribute will
be found whether it is a foreground or background attribute. 
If the DESIGNATED ATTRIBUTE is not found, an error message is
spoken.  The real-time cursor is not moved.  The default
attribute is "0": Reverse Video.

READ TEXT IN DESIGNATED BACKGROUND ATTRIBUTE
PREFIX f a ALT-attribute-number ENTER

     Press the PREFIX key, followed by the unshifted-"f" key
(for FIND), followed by the unshifted-"a" key (for
ATTRIBUTE), followed by an ALT-top row number key combination
from "0" through "9", followed by the ENTER key to read text
in the designated background attribute.  The valid attribute
designations are : (1) blue on color monitors, underline on
high-resolution monochrome monitors, (2) green, (3) cyan,
also turquoise, (4) red, also pink, (5) magenta, also purple,
(6) yellow, also orange and brown depending on the individual
monitor, (7) normal white, (8) dim white (also grey), (9)
bright white, also high intensity white, (0) reverse video,
also inverse video.  After the unshifted-"a" key (for
ATTRIBUTE) is pressed, the attribute last designated will be
spoken.  If you want to search again for that attrubute,
press the ENTER key without entering a number.  The cursor
keys can also be used to select the desired attribute.  The
designated attribute ONLY APPLIES TO THE BACKGROUND COLOR,
not the color of the foreground.  If the designated attribute
is not found, an error message is spoken.  The real-time
cursor is not moved.  The default attribute is "0": Reverse
Video.

READ TEXT IN DESIGNATED FOREGROUND ATTRIBUTE
PREFIX f a SHIFT-attribute-number ENTER

     Press the PREFIX key, followed by the unshifted-"f" key
(for FIND), followed by the unshifted-"a" key (for
ATTRIBUTE), followed by a shifted top row number key from "0"
through "9", followed by the ENTER key to read text in the
designated foreground attribute.  The valid attribute
designations are : (1) blue on color monitors, underline on
high-resolution monochrome monitors, (2) green, (3) cyan,
also turquoise, (4) red, also pink, (5) magenta, also purple,
(6) yellow, also orange and brown depending on the individual
monitor, (7) normal white, (8) dim white (also grey), (9)
bright white, also high intensity white, (0) reverse video,
also inverse video.  After the unshifted-"a" key (for
ATTRIBUTE) is pressed, the attribute last designated will be
spoken.  If you want to search again for that attrubute,
press the ENTER key without entering a number.  The cursor
keys can also be used to select the desired attribute.  The
designated attribute ONLY APPLIES TO THE FOREGROUND COLOR,
not the color of the background.  If the designated attribute
is not found, an error message is spoken.  The real-time
cursor is not moved.  The default attribute is "0": Reverse
Video.

RE-INITIALIZE SYNTHESIZER
PREFIX ALT-\ (backslash)

     Press the PREFIX key, followed by the ALT-"\"
(backslash) combination to send control sequences to
re-initialize the synthesizer and the serial port.  Re-
initializing is simply a way of "turning everything off" for
a fraction of a second and then "turning it back on again" to
re-start both Video Voice's synthesizer control routines and
the synthesizer itself.  Some programs, such as IBM's BASIC
interpreter, telecommunications, and multitasking software 
"kick" Video Voice off the serial port.  This command is
provided to "re-attach Video Voice to its port".  All control
sequences to command the synthesizer are sent again to the
synthesizer when it is initialized.  This command works best
if the synthesizer is first turned off, then turned back on,
then the PREFIX is pressed, followed by the ALT-backslash
combination.

SELECT ACTIVE VIDEO VOICE WINDOW
PREFIX a w window-number ENTER

     Press the PREFIX key, followed by the unshifted-"a" key
(for ACTIVATE), followed by the unshifted-"w" key (for
WINDOW), followed by a top row number key from "0" through
"9", followed by the ENTER key to select the active Video
Voice window.  Selecting an active Video Voice window causes
Video Voice to treat the selected active Video Voice window
as though it were the whole screen.  Review mode movement
commands cannot be used outside the active Video Voice
window.  Video Voice window "0" is always the whole screen.

SELECT ATTRIBUTE CHANGE INDICATION
PREFIX SHIFT-5 number ENTER

     Press the PREFIX key, followed by the SHIFT-"5"
combination (percent sign), followed by a top row number key
from "1" through "4", followed by the ENTER key to select the
attribute change indicator mode.  The attribute changes are
announced when encountered.  The modes are as follows: (1) No
announcing attribute changes, (2) Announce only background
attribute changes, (3) Announce only foreground changes, (4)
Announce all attribute changes.

SELECT BEEPS
PREFIX SHIFT-0 beep-type-number ENTER

     Press the PREFIX key, followed by the SHIFT-"0"
combination (right parenthesis), followed by a top row number
key from "1" through "3", followed by the ENTER key to select
the type of musical beeps used to indicate cursor movement to
a new row.  The options are (1) no beeps, (2) review beeps
only, (3) "singing cursor" (beeps at EVERY cursor line
change).  The default beep-type is "2": Review Beeps Only.

SELECT ENVIRONMENT
PREFIX ALT-2 environment-number ENTER

     Press the PREFIX key, followed by the ALT-"2"
combination, followed by a top row number key from "0"
through "9" or an ALT-top row number key combination from "0"
through "9", followed by the ENTER key to select between
environments.  Environments tell Video Voice which
application keys to link to which Video Voice speak unit
commands.  The available environments are:

   1  WordStar diamond     ALT-1  Alternate WordStar diamond
   2  WordPerfect          ALT-2  Alternate WordPerfect
   3  some Databases       ALT-3  Alternate some Databases
   4  undefined            ALT-4  undefined
   5  undefined            ALT-5  undefined
   6  undefined            ALT-6  undefined
   7  Slow Generic         ALT-7  Alternate Slow Generic
   8  Normal Generic       ALT-8  Alternate Normal Generic
   9  Fast Generic         ALT-9  Alternate Fast Generic
   0  User Defined         ALT-0  Alternate User Defined

     The default environment is ALT-"2": Alternate
WordPerfect.


SELECT PUNCTUATION LEVEL
PREFIX SHIFT-4 punctuation-level-number ENTER

     Press the PREFIX key, followed by the SHIFT-"4"
combination (dollar sign), followed by a top row number key
from "1" through "3", followed by the ENTER key to determine
the amount of punctuation that is spoken.  The options are:
(1) all punctuation, (2) text punctuation ignored, (3) no
punctuation spoken.  The default punctuation level is "1":
All Punctuation.

SELECT SKILL LEVEL
PREFIX SHIFT-1 skill-level-number ENTER

     Press the PREFIX key, followed by the SHIFT-"1"
combination (the exclamation point), followed by a top row
number key from "1" through "4", followed by the ENTER key to
select the type of messages Video Voice will speak.  The
choices are (1) Verbose for beginners, (2) Clear for
intermediate users, (3) Cryptic for experts and (4) no
messages for macros.  The default skill level is "1": Verbose
for Beginners.

SELECT SPEECH RATE
PREFIX SHIFT-\ (backslash) speech-rate-number ENTER

     Press the PREFIX key, followed by the SHIFT-"\"
(SHIFT-backslash) combination (vertical bar), followed by a
number using the top row number keys, followed by the ENTER
key to select the rate at which the text is spoken.  The
cursor keys can also be used to move from one rate to the
next.  When the cursor keys are used each new speech rate can
be heard.  The ENTER key must be pressed to confirm a choice. 
The number of speech rates for each synthesizer are:

Artic Synphonix                 7       default: 3
BOSS                            6       default: 2
DECtalk I                       7       default: 3
DECtalk II                      9       default: 3
Echo PC and GP                  2       default: 1
Intextalker and MicroVox        4       default: 2
Votrax Personal Speech System   4       default: 2
Votrax PSS Model B              9       default: 3
Votrax Type N Talk              none
Votrax Votalker                 6       default: 3

SELECT SPEECH STYLE
PREFIX CONTROL-\ (backslash) speech-style-number ENTER

     Press the PREFIX key, followed by the CONTROL-"\"
(CONTROL-backslash) combination, followed by a number using
the top row number keys, followed by the ENTER key to select
the style in which the text is spoken.  The ENTER key must be
pressed to confirm a choice.  The speech styles for each
synthesizer are:

Artic Synphonix: 
  9 pitch changes, 1 is lowest and 9 is highest.  Default: 4.
BOSS: 
  Not available.
DECtalk (I & II): 
  (1) Paul, (2) Harry, (3) Frank, (4) Dennis, (5) Rita, (6)
Wendy, (7) Kit, (8) Ursala, (9) Betty.  Default: 1.
Echo PC and GP: 
  9 pitch changes, 1 is lowest and 9 is highest.  Default: 4.
Intextalker and MicroVox:
  Toggles between flat and inflected.  Default: Inflected.
Votrax Personal Speech System:
  3 pitch changes, 1 is lowest and 3 is highest.  Default: 3.
Votrax PSS Model B:
  3 pitch changes, 1 is lowest and 3 is highest.  Default: 3.
Votrax Type N Talk:
  Not available.
Votrax Votalker:
  9 pitch changes, 1 is lowest and 9 is highest.  Default: 4.

SELECT TEXT SOURCE
PREFIX \ (backslash) text-source-number ENTER

     Press the PREFIX key, followed by the "\" key
(backslash), followed by a top row number key from "1"
through "4", followed by the ENTER key to select the source
of the text that is to be spoken.  The options are: (1) no
speech, (2) keyboard characters only,  (3) screen only, (4)
screen plus non-character keys.  The default text-source is
"4": Screen plus Non-Character Keys.

SPEAK CURSOR COORDINATES
PREFIX SPACE

     Press the PREFIX key, followed by the SPACE BAR to speak
the current coordinates of the cursor.  If Review Mode is
active, the Review Mode cursor location is given, otherwise
the real-time cursor coordinates are given.

SPEAK STATUS OF VIDEO VOICE TOGGLES AND SELECTS
PREFIX 5

     Press the PREFIX key, followed by the top row number "5"
key to hear a long recitation of the status of the most
frequently used Video Voice toggles and selects.

SPEAK TIME
PREFIX 1

     Press the PREFIX key, followed by the top row number "1"
key to speak the current system time.  The computer's time
must previously have been set either by a real-time clock or
by answering the TIME prompt when the computer was booted.

SPEAK VIDEO VOICE STATUS
PREFIX 6

     Press the PREFIX key, followed by the top row number "6"
key to hear an announcement of Video Voice status.  This
includes the currently active synthesizer, its port, the
program version, the serial number, the Review Mode
interrupt, and the computer type.

SPELL CONTENTS OF DESIGNATED VIDEO VOICE WINDOW
PREFIX s w window-number ENTER

     Press the PREFIX key, followed by the unshifted-"s" key
(for SPELL), followed by the unshifted-"w" key (for WINDOW),
followed by a top row number key from "0" through "9",
followed by the ENTER key to spell the contents of the
designated Video Voice window.  The designated Video Voice
window need not be the active Video Voice window, but it must
have been previously defined.  Video Voice window "0" is
always the whole screen. The real-time cursor is not moved. 
The default window-number is "0": the Whole Screen.

SPELL CURRENT PARAGRAPH
PREFIX s l

     Press the PREFIX key, followed by the unshifted-"s" key
(for spell), followed by the unshifted-"l" key to spell the
whole current paragraph, regardless of the location of the
cursor within the paragraph.  The real-time cursor is not
moved.

SPELL CURRENT ROW
PREFIX s ' (apostrophe)

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the "'" (apostrophe) to spell the
contents of the current row in the screen or active Video
Voice window. The real-time cursor is not moved.

SPELL CURRENT SCREEN
PREFIX s ` (back accent or grave accent)

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the "`" key (back-accent) to spell
the contents of the whole screen or active Video Voice
window.  The real-time cursor is not moved.

SPELL CURRENT SENTENCE
PREFIX s k

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the unshifted-"k" key to spell the
whole current sentence, regardless of the location of the
cursor within the sentence.  The real-time cursor is not
moved.

SPELL CURRENT WORD
PREFIX s j

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the unshifted-"j" key to spell the
whole current word, regardless of the location of the cursor
within the word.  The real-time cursor is not moved.

SPELL FIRST PART OF CURRENT PARAGRAPH
PREFIX s SHIFT-L

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the SHIFT-"l" combination to spell
from the beginning of the paragraph to the end of the row
which contains the cursor.  The real-time cursor is not
moved.

SPELL FIRST PART OF CURRENT ROW
PREFIX s SHIFT-' (apostrophe)

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the SHIFT-"'" (SHIFT-apostrophe)
combination (quotation mark) to spell from the beginning of
the row to the location of the cursor.  The real-time cursor
is not moved.

SPELL FIRST PART OF CURRENT SENTENCE
PREFIX s SHIFT-K

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the SHIFT-"k" combination to spell
from the beginning of the sentence to the end of the word
which contains the cursor.  The real-time cursor is not
moved.

SPELL FIRST PART OF CURRENT WORD
PREFIX s SHIFT-J

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the SHIFT-"J" combination to spell
the first part of the current word.  The spelling will
include the character the cursor is on.  The real-time cursor
is not moved.

SPELL FIRST PART OF SCREEN
PREFIX s SHIFT-` (back accent or grave accent)

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the SHIFT-"`" (SHIFT-back accent)
combination (tilde) to spell from the top left-hand corner of
the screen or active Video Voice window to the end of the row
that contains the cursor.  The real-time cursor is not moved.

SPELL FOLLOWING PARAGRAPH
PREFIX s . (period)

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the unshifted-"." key (period) to
spell the contents of the following paragraph.  If the new
paragraph begins on a following row, descending beeps are
sounded.  The real-time cursor is not moved.

SPELL FOLLOWING ROW
PREFIX s ] (right bracket)

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the "]" key (right bracket) to spell
the contents of the following row.  Descending beeps are
sounded to indicate the location of the following row.  The
"]" (right bracket) key is an exception to the normal Video
Voice key pattern.  The real-time cursor is not moved.

SPELL FOLLOWING SENTENCE
PREFIX s , (comma)

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the unshifted-"," key (comma) to
spell the contents of the following sentence.  If the new
sentence begins on a following row, descending beeps are
sounded.  The real-time cursor is not moved.

SPELL FOLLOWING WORD
PREFIX s m

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the unshifted-"m" key to spell the
following word.  If the new word is on a following row,
descending beeps are sounded.  The real-time cursor is not
moved.

SPELL LAST PART OF CURRENT PARAGRAPH
PREFIX s ALT-l

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the ALT-"l" combination to spell
from the beginning of the row which contains the cursor to
the end of the paragraph.  The real-time cursor is not moved.

SPELL LAST PART OF CURRENT ROW
PREFIX s ALT-' (apostrophe)

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the ALT-"'" (ALT-apostrophe)
combination to spell from the location of the cursor to the
end of the current row.  The real-time cursor is not moved.

SPELL LAST PART OF CURRENT SENTENCE
PREFIX s ALT-k

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the ALT-"k" combination to spell
from the beginning of the word which contains the cursor to
the end of the sentence.  The real-time cursor is not moved.

SPELL LAST PART OF CURRENT WORD
PREFIX s ALT-j

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the ALT-"j" combination to spell the
last part of the current word.  The spelling will include the
character the cursor is on.  The real-time cursor is not
moved.

SPELL LAST PART OF SCREEN
PREFIX s ALT-` (back accent or grave accent)

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the ALT-"`" (ALT-back accent)
combination to spell from the beginning of the row that
contains the cursor to the lower right-hand corner of the
screen or active Video Voice window.  The real-time cursor is
not moved.

SPELL PREVIOUS PARAGRAPH
PREFIX s o

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the unshifted-"o" key to spell the
contents of the previous paragraph.  Ascending beeps are
sounded to indicate the row where the paragraph begins.  The
real-time cursor is not moved.

SPELL PREVIOUS ROW
PREFIX s [ (left bracket)

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the "[" key (left bracket) to spell
the contents of the previous row.  Ascending beeps are
sounded to indicate the row that was spoken.  The "[" key
(left bracket) an exception to the normal key pattern.  The
real-time cursor is not moved.

SPELL PREVIOUS SENTENCE
PREFIX s i

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the unshifted-"i" key to spell the
contents of the previous sentence.  If the new sentence
begins on a previous row, ascending beeps are sounded.  The
real-time cursor is not moved.

SPELL PREVIOUS WORD
PREFIX s u

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell) followed by the unshifted-"u" key to spell the
previous word.  If the new word is on a previous row,
ascending beeps are sounded.  The real-time cursor is not
moved.

SPELL ROW AT BOTTOM OF SCREEN
PREFIX s END

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the END key to have Video Voice
spell the row at the bottom of the screen.  This row is also
known as row 25.

SPELL ROW AT TOP OF SCREEN
PREFIX s HOME

     Press the PREFIX key, followed by the unshifted-"s" key
(for Spell), followed by the HOME key to have Video Voice
spell the row at the top of the screen.  This row is also
known as row 1.

TOGGLE ENUNCIATOR
PREFIX SHIFT-8 1-or-2 ENTER

     Press the PREFIX key, followed by the SHIFT-top row
number "8" key combination (asterisk), followed by a top row
number "1" or "2" key, followed by the ENTER key to toggle
between spelling alphabetic characters normally, or using
"military spelling" for easier understanding.  The top row
number "1" key turns the Enunciator "ON" and the top row
number "2" key turns the Enunciator "OFF".  The "*" key
(asterisk/print screen key) available on some keyboards, can
also be used.  The Enunciator defaults to "OFF".

TOGGLE GRAPHICS
PREFIX ALT-3 1-or-2 ENTER

     Press the PREFIX key, followed by the ALT-top row number
"3" key combination, followed by a top row number "1" or "2"
key, followed by the ENTER key to toggle between recognizing
graphics characters and substituting spaces for them.  The
top row number "1" key turns the Graphics "ON" and the top
row number "2" key turns the Graphics "OFF".  When graphics
is on the (decimal) ASCII value for all graphics characters
encountered will be spoken.  Otherwise all graphics
characters are treated like spaces.  The Graphics default to
"OFF".

TOGGLE NUMERIC SPEECH FORMAT
PREFIX ALT-4 1-or-2 ENTER

     Press the PREFIX key, followed by the ALT-top row number
"4" key combination, followed by a top row number "1" or "2"
key, followed by the ENTER key to toggle between speaking
multi-digit numbers as millions, thousands, hundreds, etc.,
and speaking them one by one.  The top row number "1" key
turns the speaking as millions "ON" and the speaking one by
one off, and the top row number "2" key turns the speaking as
millions "OFF" and the speaking one by one "ON".  Speaking as
millions defaults to "OFF".  This command is not available
for the Echo synthesizers.

TOGGLE READ ROW NUMBERS
PREFIX SHIFT-3 1-or-2 ENTER

     Press the PREFIX key, followed by the SHIFT-top row
number "3" key combination (number sign), followed by a top
row number "1" or "2" key, followed by the ENTER key to
toggle reading row numbers whenever the cursor keys are used
to change rows in real-time mode, and during ALL row changes
in Review Mode.  The top row number "1" key turns the reading
"ON" and the top row number "2" key turns the reading "OFF". 
Read Row Numbers defaults to "OFF".

TOGGLE SPEECH CUT-OFF
PREFIX ALT-5 1-or-2 ENTER

     Press the PREFIX key, followed by the ALT-top row number
"5" key combination, followed by a top row number "1" or "2"
key, followed by the ENTER key to toggle Speech Cut Off on
and off.  The top row number "1" key will turn the Speech Cut
Off "ON" and the top row number "2" key will turn the Speech
Cut Off "OFF".  When Speech Cut Off is on the synthesizer
will always halt speech at the press of the next key.  The
command is ineffective with synthesizers which do not have
instant shutup.  Speech Cut-Off defaults to "OFF".

TOGGLE TO ALTERNATE SYNTHESIZER
PREFIX SHIFT-7 1-or-2 ENTER

     Press the PREFIX key, followed by the SHIFT-top row
number "7" key combination (ampersand), followed by a top row
number "1" or "2" key, followed by the ENTER key to toggle
between the Primary and the Alternate synthesizer.  The
synthesizer's port designation, configuration, and control
parameters are changed.  If you have not specified an
Alternate synthesizer in the GRCONFIG.YAK data file, the
Primary and Alternate synthesizers are the same.  The top row
number "1" key turns the Primary synthesizer "ON" and the
Alternate synthesizer "OFF", and the top row number "2" key
turns the Alternate synthesizer "ON" and the Primary
synthesizer "OFF".  Video Voice defaults to the Primary
synthesizer.

TOGGLE TYPEMATIC
PREFIX ALT-6 1-or-2 ENTER

     Press the PREFIX key, followed by the ALT-top row number
"6" key combination, followed by a top row number "1" or "2"
key, followed by the ENTER key to toggle between normal
typematic and disabling the normal typematic action.  The top
row number "1" key turns Typematic "ON" and the top row
number "2" key turns Typematic "OFF".  Typematic defaults to
"ON".

TOGGLE WRITING TO ROW ONE
PREFIX SHIFT-6 1-or-2 ENTER

     Press the PREFIX key, followed by the SHIFT-top row
number "6" key combination, followed by a top row number "1"
or "2" key, followed by the ENTER key to toggle between
writing all output headed for the synthesizer simultaneously
to row 1 of the screen and leaving Writing-to-row-1 toggled
off.  The top row number "1" key turns Writing To Row One
"ON" and the top row number "2" key turns Writing To Row One
"OFF".  Writing-to-Row-One defaults to "OFF".

