/*

	pcvideo.cpp
	7-30-91
	Extended text attribute control for conio.

	Copyright 1991
	John W. Small
	All rights reserved
	Use freely but acknowledge authorship and copyright.

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#include <dos.h>
#include <pcvideo.hpp>


int  forcedmonochrome = 0;
static int prevattr = svideo(WHITE,BLACK);
static int origattr = svideo(WHITE,BLACK);


void reversevideo()
{
	struct text_info ti;

	gettextinfo(&ti);
	prevattr = ti.attribute;
	textattr(rvideo(ti.attribute));
}

void blinkvideo()
{
	struct text_info ti;

	gettextinfo(&ti);
	prevattr = ti.attribute;
	textattr(bvideo(ti.attribute));
}

void unblinkvideo(void)
{
	struct text_info ti;

	gettextinfo(&ti);
	prevattr = ti.attribute;
	textattr(ubvideo(ti.attribute));
}

void savevideo()
{
	struct text_info ti;

	gettextinfo(&ti);
	prevattr = ti.attribute;
}

void restorevideo()
{
	struct text_info ti;
	int oldprevattr = prevattr;

	gettextinfo(&ti);
	prevattr = ti.attribute;
	textattr(oldprevattr);
}

void saveAsOrigVideo()
{
	struct text_info ti;

	gettextinfo(&ti);
	origattr = ti.attribute;
}

void restoreOrigVideo()
{
	struct text_info ti;
	int oldorigattr = origattr;

	gettextinfo(&ti);
	origattr = ti.attribute;
	textattr(oldorigattr);
}


void putvideo(int left, int top, int right,
	int bottom, int attr, int buf[])
{
	int y, len, i;
	char attrch = (char) attr;
	char *cbuf = (char *) buf;

	len = (right - left + 1) * 2;
	for (y = top; y <= bottom; y++)  {
		gettext(left,y,right,y,cbuf);
		for (i = 1; i < len; i += 2)
			cbuf[i] = attrch;
		puttext(left,y,right,y,cbuf);
	}
}

int  istext()
{
	_AH = 0x0F;
	geninterrupt(0x10);
	switch (_AL)  {
		case 0:
		case 1:
		case 2:
		case 3:
		case 7:
			return 1;
	}
	return 0;
}

int  iscolor()
{
	if (forcedmonochrome)
		return 0;
	_AH = 0x0F;
	geninterrupt(0x10);
	switch (_AL)  {
		case 0:
		case 2:
		case 5:
		case 6:
		case 7:
		case 15:
		case 17:
			return 0;
			// must be 0 for mappalette
	}
	return 1;  // must be 1 for mappalette
}

void toggleRes()
{
	struct text_info ti;

	gettextinfo(&ti);
	switch (ti.currmode)  {
	case C80:
	      textmode(C4350);
	      break;
	case C4350:
		textmode(C80);
		break;
	}
}

void mapvideo(int attr_id, PalettE P)
{
	struct text_info ti;

	gettextinfo(&ti);
	prevattr = ti.attribute;
	textattr(mapattr(attr_id,P));
}
