#if !COMPILER
/*
 *  Main program if Icon is called as a subprogram.
 */

#ifdef IconCalling

novalue main(argc,argv)

int argc;
char *argv[];
   {
   int clargc;
   char **clargv;
   int i;
   struct descrip darg;

#if AMIGA
#if AZTEC_C
   struct Process *FindTask();
   struct Process *Process = FindTask(0L);
   ULONG stacksize = *((ULONG *)Process->pr_ReturnAddr);

   if (stacksize < ICONXMINSTACK) {
      fprintf(stderr,"Iconx needs \"stack %d\" to run\n",ICONXMINSTACK);
      exit(-1);
      }
#endif					/* AZTEC_C */
#endif					/* AMIGA */

   /*
    * Set up standard Icon interface.  This is only necessary so that
    *  Icon can behave normally as if it were the main program.
    *  It is not necessary if Icon is called by a C program for another
    *  purpose.
    */

#if VMS
   redirect(&argc, argv, 0);
#endif					/* VMS */

#ifdef CRAY
   argv[0] = "iconx";
#endif					/* CRAY */

#if SASC
   quite(1);			/* suppress C library diagnostics */
#endif					/* SASC */

   icon_setup(argc, argv, &i);
   while (i--) {			/* skip option arguments */
      argc--;
      argv++;
      }

   if (!argc) 
      error(NULL, "no icode file specified");

   /*
    * Read in the icode file argv[1] and initialize the Icon system.
    *  This must be done for any C program calling Icon.
    */
   icon_init(argv[1], &argc, argv);

   /*
    * Skip the names of the executable and the file it processes.  This
    *  is necessary only to get the right arguments from the command line
    *  to call Icon as if it were the main program and hence provide
    *  the correct values in the list that is the argument of Icon's main
    *  procedure. This is not necessary if Icon is called from C for
    *  another purpose.
    */
   clargv = argv + 2;
   clargc = argc - 2;

   /*
    * Set up a temporary stack and build the necessary list
    *  to call main.
    */
   sp = stack + Wsizeof(struct b_coexpr);

   PushNull;
   argp = (dptr)(sp - 1);
   for (i = 0; i < clargc; i++) {
      PushAVal(strlen(clargv[i]));
      PushVal(clargv[i]);
      }
   Ollist(clargc, argp);

   /*
    * Now that the list is computed, copy its descriptor off the
    *  stack (which is about to be destroyed), reset the argument
    *  pointer, and make the call to the Icon main procedure.
    */
 
   darg = *argp;
   argp = 0;
   icon_call("main", 1, &darg);	/* return signal and value ignored */
   c_exit(NormalExit);

   }
#else					/* IconCalling */
static char x;				/* avoid empty module */
#endif					/* IconCalling */
#endif					/* !COMPILER */
