/*
 * Prototypes for run-time functions.
 */

/*
 * Prototypes common to the compiler and interpreter.
 */

int	interp	Params((int fsig,dptr cargp));
novalue	EVInit	Params((char *exename,char *outname));
novalue	EVSetup	Params((noargs));
novalue	EVTerm	Params((int n,char *part2));
word	add	Params((word a,word b));
word	mul	Params((word a,word b));
word	sub	Params((word a,word b));
int	dp_pnmcmp	Params((struct pstrnm *pne,dptr dp));
int	getvar	Params((char *s,dptr vp));
word	neg	Params((word a));
int	pstrnmcmp	Params((struct pstrnm *a,struct pstrnm *b));
novalue	xmfree	Params((noargs));
novalue	icon_init	Params((char *name, int *argcp, char *argv[]));
novalue	inttrap	Params((noargs));
char	*alcstr			Params((char *s,word slen));
char	*blkreserve		Params((word nbytes));
char	*findfile		Params((word *ipc));
char	*strreserve		Params((word nbytes));
int	activate	Params((dptr val, struct b_coexpr *ncp, dptr result));
int	anycmp			Params((dptr dp1,dptr dp2));
int	bfunc			Params((noargs));
int	co_chng	Params((struct b_coexpr *ncp, struct descrip *valloc, struct descrip *rsltloc, int swtch_typ, int first));
int	cnv_c_dbl		Params((dptr s, double *d));
int	cnv_c_int		Params((dptr s, C_integer *d));
int	cnv_c_str		Params((dptr s, dptr d));
int	cnv_cset		Params((dptr s, dptr d));
int	cnv_ec_int		Params((dptr s, C_integer *d));
int	cnv_eint		Params((dptr s, dptr d));
int	cnv_int			Params((dptr s, dptr d));
int	cnv_real		Params((dptr s, dptr d));
int	cnv_str			Params((dptr s, dptr d));
int	cnv_tcset		Params((struct b_cset *cbuf, dptr s, dptr d));
int	cnv_tstr		Params((char *sbuf, dptr s, dptr d));
int	coswitch		Params((word *old, word *new, int first));
int	cplist			Params((dptr dp1,dptr dp2,word i,word j));
int	cpset			Params((dptr dp1,dptr dp2,word size));
int	csetcmp			Params((unsigned int *cs1,unsigned int *cs2));
int	cssize			Params((dptr dp));
int	def_c_dbl		Params((dptr s, double df, double * d));
int	def_c_int		Params((dptr s, C_integer df, C_integer * d));
int	def_c_str		Params((dptr s, char * df, dptr d));
int	def_cset		Params((dptr s, struct b_cset * df, dptr d));
int	def_ec_int		Params((dptr s, C_integer df, C_integer * d));
int	def_eint		Params((dptr s, C_integer df, dptr d));
int	def_int			Params((dptr s, C_integer df, dptr d));
int	def_real		Params((dptr s, double df, dptr d));
int	def_str			Params((dptr s, dptr df, dptr d));
int	def_tcset Params((struct b_cset *cbuf,dptr s,struct b_cset *df,dptr d));
int	def_tstr		Params((char *sbuf, dptr s, dptr df, dptr d));
int	doasgn			Params((dptr dp1,dptr dp2));
int	doimage			Params((int c,int q));
int	equiv			Params((dptr dp1,dptr dp2));
int	err			Params((noargs));
int	findipc			Params((int line));
int	findline		Params((word *ipc));
int	getstrg			Params((char *buf,int maxi,FILE *fd));
int	lexcmp			Params((dptr dp1,dptr dp2));
int	numcmp			Params((dptr dp1,dptr dp2,dptr dp3));
int	pushact		Params((struct b_coexpr *ce, struct b_coexpr *actvtr));
int	putstr			Params((FILE *f,dptr d));
int	qlcmp			Params((dptr  *q1,dptr  *q2));
int	qtos	Params((dptr dp,char *sbuf));
int     radix	Params((int sign, register int r, register char *s,
                       register char *end_s, union numeric *result));
novalue	addmem 	Params((struct b_set *ps,struct b_selem *pe, union block **pl));
novalue	adjust			Params((char *source,char *dest));
novalue	c_exit			Params((int i));
novalue	co_init			Params((struct b_coexpr *sblkp));
novalue	coacttrace	Params((struct b_coexpr *ccp,struct b_coexpr *ncp));
novalue	cofailtrace	Params((struct b_coexpr *ccp,struct b_coexpr *ncp));
novalue	corettrace	Params((struct b_coexpr *ccp,struct b_coexpr *ncp));
novalue	cofree			Params((noargs));
novalue	compact			Params((char *source));
novalue	datainit		Params((noargs));
novalue	deallocate		Params((union block *bp));
novalue	drunerr			Params((int n, double v));
novalue	env_int	Params((char *name,word *variable,int non_neg, uword limit));
novalue	error			Params((char *s1, char *s2));
novalue	err_msg			Params((int n, dptr v));
novalue	fatalerr		Params((int n,dptr v));
novalue	fpetrap			Params((noargs));
novalue	iconhost		Params((char *hostname));
novalue	irunerr			Params((int n, C_integer v));
novalue	markblock		Params((dptr dp));
novalue	markptr			Params((union block **));
novalue	mksubs	Params((dptr var,dptr val,word i,word j, dptr result));
novalue	mvc			Params((uword n,char *src,char *dest));
novalue	outimage		Params((FILE *f,dptr dp,int restrict));
novalue	postqual		Params((dptr dp));
#ifdef MultiThread
novalue	resolve			Params((struct progstate *pstate));
#else					/* MultiThread */
novalue	resolve			Params((noargs));
#endif					/* MultiThread */
novalue retderef		Params((dptr valp, word *low, word *high));
novalue	scollect		Params((word extra));
novalue	segvtrap		Params((noargs));
novalue	stkdump			Params((int));
novalue	sweep			Params((struct b_coexpr *ce));
novalue	syserr			Params((char *s));
struct	astkblk *alcactiv	Params((noargs));
struct	b_coexpr *popact	Params((struct b_coexpr *ce));
struct	b_coexpr *topact	Params((struct b_coexpr *ce));
struct	b_cset *alccset		Params((noargs));
struct	b_file *alcfile		Params((FILE *fd,int status,dptr name));
struct	b_lelem *alclstb	Params((uword nslots,uword first,uword nused));
struct	b_list *alclist		Params((uword size));
struct	b_real *alcreal		Params((double val));
struct	b_selem *alcselem	Params((dptr mbr,uword hn));
struct	b_slots *alcsegment	Params((word nslots));
struct	b_telem *alctelem	Params((noargs));
struct	b_tvtbl *alctvtbl	Params((dptr tbl,dptr ref,uword hashnum));
struct	b_proc	*bi_strprc	Params((dptr s, C_integer arity));
union block *alchash		Params((int tcode));
union block *hgfirst	Params((union block *bp, struct hgstate *state));
union block *hgnext	Params((union block*b,struct hgstate*s,union block *e));
union block *hmake	Params((int tcode,word nslots,word nelem));
union block **memb	Params((union block *pb,dptr x,uword hn, int *res));
union block **hchain		Params((union block *pb,uword hn));
uword	hash			Params((dptr dp));
word	cvpos			Params((long pos,long len));
word	longread		Params((char *s,int width,long len,FILE *fname));
word	prescan			Params((dptr d));

int	c_get		Params((struct b_list *hp, struct descrip *res));
void	c_put		Params((struct descrip *l, struct descrip *val));


#if !HIGHC_386
int	dup2		Params((int h1, int h2));
#endif					/* !HIGHC_386 */

char *qsearch	Params((char *key,char *base,int nel,int width, int (*cmp)()));

/*
 * Temporary fix
 */

#if ARM
FILE *popen
#endif					/* ARM */

#if ATARI_ST
char	*sbrk			Params((int incr));
#endif                                  /* ATARI_ST */

#if HIGHC_386
int	brk		Params((char *p));
#endif					/* HIGHC_386 */

#if MACINTOSH
#if MPW
char	*brk			Params((char *addr));
char	*sbrk			Params((int incr));
novalue	free			Params((char* addr));
#endif					/* MPW */
#endif					/* MACINTOSH */

#if MVS || VM
#if SASC
#define brk(x) sbrk(((char *)(x))-sbrk(0))
char    *sbrk                   Params((int incr));
#endif					/* SASC */
novalue free                    Params((void* addr));
#endif                                  /* MVS || VM */

#if UNIX || VMS
/*
 * We use old-style declarations instead of prototypes here to avoid conflicts
 *  with system definitions.  For example, some <stdio.h> files don't declare
 *  popen; some declare it with char * args; and some specify const char *.
 */
char	*brk	();
int	chdir	();
FILE	*popen	();
char	*sbrk	();
#endif                                  /* UNIX || VMS */

#ifdef Coexpr
novalue new_context		Params((int fsig, dptr cargp));
#endif					/* Coexpr */

#ifdef XIcon
#ifdef XWindows
int translate_key_event		Params((XKeyEvent *k1, char *s, KeySym *k2));
#endif					/* XWindows */
int wputc			Params((int ci, wbp w));
novalue wputstr			Params((wbp w, char *s, int len));
int wattrib			Params((wbp w, char *s, long len, char *answer));
char *strnchr			Params((char *s, int ci, long len));
#ifndef PresentationManager
int setfg			Params((wbp w, char *s));
int setbg			Params((wbp w, char *s));
#else					/* PresentationManager */
int setfg			Params((wbp w, ULONG rgb));
int setbg			Params((wbp w, ULONG rgb));
#endif					/* PresentationManager */
int wgetevent			Params((wbp w, dptr res));
int wgetchne			Params((wbp w, dptr res));
int wgetche			Params((wbp w, dptr res));
int wkbhit			Params((wbp w));
int wrow			Params((wbp w));
int wcol			Params((wbp w));
int pollevent			Params((noargs));
char *evquesub			Params((wbp w, int i));
novalue mystrncpy		Params((char *dest,char *src,int n));
int xyrowcol			Params((dptr dx));
wcp alc_context			Params((wbp w));
wsp alc_winstate		Params((noargs));
wbp alc_wbinding		Params((noargs));
wcp clone_context		Params((wbp w));
#ifndef PresentationManager
int wclose			Params((wbp w));
novalue wflush			Params((wbp w));
int wmap			Params((FILE *f, char *windowname));
int handle_misc			Params((wdp display, wbp w));
FILE *wopen			Params((char *windowname, struct b_list *hp, dptr attr, int n));
wdp alc_display			Params((char *s));
wclrp alc_rgb			Params((wbp w, char *s, unsigned int r, unsigned int g, unsigned int b));
novalue makeIcon		Params((wbp w, int x, int y));
int resizePixmap		Params((wbp w, int width, int height));
#else					/* PresentationManager */
/* XXX move prototypes from xwindow.h here */
#endif					/* PresentationManager */
#endif					/* XIcon */

#if UNIX
#ifdef KeyboardFncs
word getch(), getche(), kbhit();
#endif					/* KeyboardFncs */
#endif					/* UNIX */

#ifdef LargeInts
struct	b_bignum *alcbignum	Params((word n));
word	bigradix		Params((int sign, int r, char *s, char *x, union numeric *result));
double	bigtoreal		Params((dptr da));
int	realtobig		Params((dptr da, dptr dx));
int	bigtos			Params((dptr da, dptr dx));
novalue	bigprint		Params((FILE *f, dptr da));
int	cpbignum		Params((dptr da, dptr db));
int	bigadd			Params((dptr da, dptr db, dptr dx));
int	bigsub			Params((dptr da, dptr db, dptr dx));
int	bigmul			Params((dptr da, dptr db, dptr dx));
int	bigdiv			Params((dptr da, dptr db, dptr dx));
int	bigmod			Params((dptr da, dptr db, dptr dx));
int	bigneg			Params((dptr da, dptr dx));
int	bigpow			Params((dptr da, dptr db, dptr dx));
int	bigand			Params((dptr da, dptr db, dptr dx));
int	bigor			Params((dptr da, dptr db, dptr dx));
int	bigxor			Params((dptr da, dptr db, dptr dx));
int	bigshift		Params((dptr da, dptr db, dptr dx));
word	bigcmp			Params((dptr da, dptr db));
int	bigrand			Params((dptr da, dptr dx));
#endif					/* LargeInts */


/*
 * Prototypes for the run-time system.
 */

C_integer	iipow	Params((C_integer n1, C_integer n2));
int	bfunc	Params((noargs));
int	collect	Params((int region, word nbytes));
int	cvcset	Params((dptr dp,int * *cs,int *csbuf));
int	cvnum	Params((dptr dp,union numeric *result));
int	cvreal	Params((dptr dp,double *r));
int	eq	Params((dptr dp1,dptr dp2));
int	fixtrap	Params((noargs));
int	getimage	Params((dptr dp1, dptr dp2));
int	get_name	Params((dptr dp1, dptr dp2));
int	getstrg	Params((char *buf,int maxi,FILE *fd));
int	mkreal	Params((double r,dptr dp));
int	nthcmp	Params((dptr d1,dptr d2));
void	nxttab	Params((C_integer *col, dptr *tablst, dptr endlst, C_integer *last, C_integer *interval));
int	order	Params((dptr dp));
int	printable	Params((int c));
int	ripow	Params((double r, C_integer n, dptr rslt));
int	sig_rsm	Params((noargs));
int	subs_asgn	Params((dptr dest, const dptr src));
int	trcmp3	Params((struct dpair *dp1,struct dpair *dp2));
int	trefcmp	Params((dptr d1,dptr d2));
int	tvalcmp	Params((dptr d1,dptr d2));
int	tvcmp4	Params((struct dpair *dp1,struct dpair *dp2));
long	ckadd	Params((long i, long j));
long	ckmul	Params((long i, long j));
long	cksub	Params((long i, long j));
novalue	cmd_line	Params((int argc, char **argv, dptr rslt));
novalue	cotrace	Params((struct b_coexpr *ccp, struct b_coexpr *ncp, int swtch_typ, dptr valloc));
novalue	deref	Params((dptr dp1, dptr dp2));
novalue	envset	Params((noargs));
novalue	hgrow	Params((union block *bp));
novalue	hshrink	Params((union block *bp));
novalue	init	Params((char *name, int *argcp, char *argv[], int trc_init));
novalue	rtos			Params((double n,dptr dp,char *s));
novalue	tvtbl_asgn	Params((dptr dest, const dptr src));
novalue	varargs	Params((dptr argp, int nargs, dptr rslt));
#ifdef MultiThread
struct	b_coexpr *alccoexp	Params((long icodesize, long stacksize));
#else					/* MultiThread */
struct	b_coexpr *alccoexp	Params((noargs));
#endif					/* MultiThread */
struct	b_coexpr *create   Params((continuation fnc, struct b_proc *p, int ntemps, int wrk_size));
struct	b_external *alcextrnl	Params((int n));
struct	b_record *alcrecd	Params((int nflds,union block *recptr));
struct	b_proc *strprc	Params((dptr s, C_integer arity));
struct	b_tvsubs *alcsubs	Params((word len,word pos,dptr var));

#ifdef MemMon
novalue	MMInit	Params((char *name));
novalue	MMTerm	Params((char *part1, char *part2));
novalue	MMAlc	Params((word len, int type));
novalue	MMBGC	Params((int region));
novalue	MMEGC	Params((noargs));
novalue	MMMark	Params((char *block, int type));
novalue	MMOut	Params((char *prefix, char *msg));
novalue	MMShow	Params((dptr dp, int colr));
novalue	MMStat	Params((char *a, word n, int c));
novalue	MMStr	Params((word slen));
novalue	MMSMark	Params((char *saddr, word slen));
#endif					/* MemMon */

novalue EVVal	Params((word value, int event));

#ifdef EventMon
novalue EVQval	Params((dptr dp, int j));
novalue EVValD	Params((dptr dp, int event));
novalue vanquish Params((struct gf_marker *gfp));
novalue EVAsgn	Params((dptr dx));
#endif					/* EventMon */

#ifdef MultiThread
struct b_coexpr *loadicode Params((char *name, struct b_file *theInput,
				   struct b_file *theOutput,
				   struct b_file *theError,
				   C_integer bs, C_integer ss, C_integer stk));
novalue actparent Params((int eventcode));
novalue evcmd     Params((word addr, word len, int c));
int mt_activate   Params((dptr tvalp, dptr rslt, struct b_coexpr *ncp));
#endif					/* MultiThread */

#ifdef FixedRegions
struct region *AlcNewReg Params((word nbytes, word stdsize));
#endif					/* FixedRegions */

/* pointer	memcpy	Params((char *dest,char *src, int c)); */

#if COMPILER
novalue	tracebk	Params((struct p_frame *lcl_pfp,dptr argp));
int	invoke	Params((int nargs,dptr args, dptr rslt, continuation cont));
int	xdisp	Params((struct p_frame *fp,dptr dp,int count, FILE *f));
novalue	atrace	Params((noargs));
novalue	ctrace	Params((noargs));
novalue	failtrace	Params((noargs));
novalue	rtrace	Params((noargs));
novalue	strace	Params((noargs));
novalue	initalloc	Params((noargs));
struct	b_refresh *alcrefresh	Params((int na,int nl, int nt, int wk_sz));
#else					/* COMPILER */

#ifdef Xver
xver(rproto.1)
#else					/* Xver */
#define Fargs dptr cargp
#endif					/* Xver */

int	invoke	Params((int nargs, dptr *cargs, int *n));
int	xdisp	Params((struct pf_marker *fp,dptr dp,int count, FILE *f));

int	Obscan			Params((int nargs,Fargs));
int	Ocreate			Params((word *entryp,Fargs));
int	Oescan			Params((int nargs,Fargs));
int	Ofield			Params((int nargs,Fargs));
int	Olimit			Params((int nargs,Fargs));
int	Ollist			Params((int nargs,Fargs));
int	Omkrec			Params((int nargs,Fargs));
novalue	atrace	Params((dptr dp));
novalue	ctrace	Params((dptr dp, int nargs, dptr arg));
novalue	failtrace	Params((dptr dp));
novalue	rtrace	Params((dptr dp, dptr rval));
novalue	strace	Params((dptr dp, dptr rval));
#ifdef MultiThread
novalue	initalloc	Params((word codesize, struct progstate *p));
#else					/* MultiThread */
novalue	initalloc	Params((word codesize));
#endif					/* MultiThread */
struct	b_refresh *alcrefresh	Params((word *e, int nl, int nt));

#ifdef ExternalFunctions
dptr	extcall			Params((dptr x, int nargs, int *signal));
#endif					/* ExternalFunctions */

#endif					/* COMPILER */

