To: millsm
From:     Carl W Oakes <COMPCTR/OAKESCW>
Date:     12 May 92 16:00:21 PST
Subject:  Ipx software
X-mailer: Pegasus Mail v2.2 (R4b).

// IPX Interrupt Library

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>

struct {
	unsigned char	network_number[4] ;
	unsigned char	node_address[6] ;
} reply_buffer ;

void far	(*ipx_spx)(void) ;				// far pointer to ipx functions
int		get_ipx_spx_pointer (void) ;	// gets ipx address

int main ()
{
	int 	i ;

	if (get_ipx_spx_pointer()) {
		printf ("IPX Driver is not installed!\n") ;
		exit (1) ;
	}

	_BX = 0x09 ;
	_ES = FP_SEG (&reply_buffer) ;
	_SI = FP_OFF (&reply_buffer) ;
	ipx_spx () ;

	printf ("Network Number: ") ;
	for (i=0; i<4; i++)
		printf ("%02X", reply_buffer.network_number[i]) ;

	printf ("\tNode Address: ") ;
	for (i=0; i<6; i++)
		printf ("%02X", reply_buffer.node_address[i]) ;

	printf ("\n") ;
	return (0) ;
}

int	get_ipx_spx_pointer (void)
{
	union REGS	regs ;
	union SREGS	sregs ;

	regs.x.ax = 0x7a00 ;
	int86x (0x2f, &regs, &regs, &sregs) ;
	if (regs.h.al != 0xff)
		return -1 ;

	ipx_spx = (void (far *)()) MK_FP (sregs.es, regs.x.di) ;
	return 0 ;
}
-- Carl W. Oakes