#ifndef mfloat_cxx
#define mfloat_cxx

#include "mfloat.h"
#include <iomanip.h>
#include <math.h>
#pragma intrinsic -fabs
#undef mfloat

class mfloat {
#define fmo friend mfloat operator
#define fro friend mfloat& operator
#define fbo friend char operator
   public:
     mfloat()                                 { mf[0] = 0; }
     mfloat(const mfloat &a)                  { equm(this->mf,a.mf); }
     mfloat(const long double a)              { ldtomf(this->mf,a); }

     mfloat& operator = (const mfloat &a)     { equm(this->mf,a.mf); return(*this); }

     fmo + (const mfloat &a)      	      { return(a); }

     fro ++ (mfloat &a)      /*prefix*/       { addm(a.mf,onem); return(a); }
     fmo ++ (mfloat &a,int)  /*suffix*/       { mfloat t; equm(t.mf,a.mf); addm(a.mf,onem); return(t); }

     fro -- (mfloat &a)      /*prefix*/       { subm(a.mf,onem); return(a); }
     fmo -- (mfloat &a,int)  /*suffix*/       { mfloat t; equm(t.mf,a.mf); subm(a.mf,onem); return(t); }

     fmo - (mfloat a)        		      { negm(a.mf); return(a); }

     fmo + (mfloat a, const mfloat &b)        { addm(a.mf,b.mf); return(a); }

     fro += (mfloat &a, const mfloat &b)      { addm(a.mf,b.mf); return(a); }

     fmo - (mfloat a, const mfloat &b)        { subm(a.mf,b.mf); return(a); }

     fro -= (mfloat &a, const mfloat &b)      { subm(a.mf,b.mf); return(a); }

     fmo * (mfloat a, const mfloat &b)        { multm(a.mf,b.mf); return(a); }
     fmo * (mfloat a, const unsigned int b)   { mfloata t; multm(a.mf,ldtomf(t,b)); return(a); }
     fmo * (mfloat a, const int b)            { multi(a.mf,b); return(a); }
     fmo * (mfloat a, const unsigned long b)  { mfloata t; multm(a.mf,ldtomf(t,b)); return(a); }
     fmo * (mfloat a, const long b)           { mfloata t; multm(a.mf,ldtomf(t,b)); return(a); }
     fmo * (mfloat a, const double b)         { mfloata t; multm(a.mf,dtomf(t,b)); return(a); }
     fmo * (mfloat a, const long double b)    { mfloata t; multm(a.mf,ldtomf(t,b)); return(a); }
     fmo * (const unsigned int b   ,mfloat a) { mfloata t; multm(a.mf,ldtomf(t,b)); return(a); }
     fmo * (const int b            ,mfloat a) { multi(a.mf,b); return(a); }
     fmo * (const unsigned long b  ,mfloat a) { mfloata t; multm(a.mf,ldtomf(t,b)); return(a); }
     fmo * (const long b           ,mfloat a) { mfloata t; multm(a.mf,ldtomf(t,b)); return(a); }
     fmo * (const double b         ,mfloat a) { mfloata t; multm(a.mf,dtomf(t,b)); return(a); }
     fmo * (const long double b    ,mfloat a) { mfloata t; multm(a.mf,ldtomf(t,b)); return(a); }

     fro *= (mfloat &a, const mfloat &b)       { multm(a.mf,b.mf); return(a); }
     fro *= (mfloat &a, const unsigned int b)  { mfloata t; multm(a.mf,ldtomf(t,b)); return(a); }
     fro *= (mfloat &a, const int b)           { multi(a.mf,b); return(a); }
     fro *= (mfloat &a, const unsigned long b) { mfloata t; multm(a.mf,ldtomf(t,b)); return(a); }
     fro *= (mfloat &a, const long b)          { mfloata t; multm(a.mf,ldtomf(t,b)); return(a); }
     fro *= (mfloat &a, const double b)        { mfloata t; multm(a.mf,dtomf(t,b)); return(a); }
     fro *= (mfloat &a, const long double b)   { mfloata t; multm(a.mf,ldtomf(t,b)); return(a); }

     fmo / (mfloat a, const mfloat &b)        { divm(a.mf,b.mf); return(a); }
     fmo / (mfloat a, const unsigned int b)   { mfloata t; divm(a.mf,ldtomf(t,b)); return(a); }
     fmo / (mfloat a, const int b)            { divi(a.mf,b); return(a); }
     fmo / (mfloat a, const unsigned long b)  { mfloata t; divm(a.mf,ldtomf(t,b)); return(a); }
     fmo / (mfloat a, const long b)           { mfloata t; divm(a.mf,ldtomf(t,b)); return(a); }
     fmo / (mfloat a, const double b)         { mfloata t; divm(a.mf,dtomf(t,b)); return(a); }
     fmo / (mfloat a, const long double b)    { mfloata t; divm(a.mf,ldtomf(t,b)); return(a); }

     fro /= (mfloat &a, const mfloat &b)        { divm(a.mf,b.mf); return(a); }
     fro /= (mfloat &a, const unsigned int b)   { mfloata t; divm(a.mf,ldtomf(t,b)); return(a); }
     fro /= (mfloat &a, const int b)            { divi(a.mf,b); return(a); }
     fro /= (mfloat &a, const unsigned long b)  { mfloata t; divm(a.mf,ldtomf(t,b)); return(a); }
     fro /= (mfloat &a, const long b)           { mfloata t; divm(a.mf,ldtomf(t,b)); return(a); }
     fro /= (mfloat &a, const double b)         { mfloata t; divm(a.mf,dtomf(t,b)); return(a); }
     fro /= (mfloat &a, const long double b)    { mfloata t; divm(a.mf,ldtomf(t,b)); return(a); }

     fbo <  (const mfloat &a, const mfloat &b)   { return(gtm(b.mf,a.mf)); }
     fbo >  (const mfloat &a, const mfloat &b)   { return(gtm(a.mf,b.mf)); }
     fbo <= (const mfloat &a, const mfloat &b)   { return(!gtm(a.mf,b.mf)); }
     fbo >= (const mfloat &a, const mfloat &b)   { return(!gtm(b.mf,a.mf)); }
     fbo == (const mfloat &a, const mfloat &b)   { return(eqm(a.mf,b.mf)); }
     fbo != (const mfloat &a, const mfloat &b)   { return(!eqm(a.mf,b.mf)); }

     friend ostream& operator<< (ostream& os, const mfloat &a);
     friend istream& operator>> (istream& is, mfloat &a);

     /* basic functions */
     friend int    strtomf(mfloat &a, const char *s) { return(strtomf_(a.mf,s,strlen(s))); }
     friend char far * mftoa(char far * str, const mfloat &a, int len) { mftostr_(str,a.mf,&len,".32767F"); str[len]=0; return str; };
     friend char far * mftostr(char far * str, const mfloat &a, int len, const char far * format) { mftostr_(str,a.mf,&len,format); str[len]=0; return str; };
     friend double mftod(const mfloat &a)        { return(mftod(a.mf)); }
     friend long double mftold(const mfloat &a)  { return(mftold(a.mf)); }
     /* standard functions (Borland C: MATH.H */
     friend mfloat acos(mfloat a)		 { acosm(a.mf); return(a); }
     friend mfloat asin(mfloat a)		 { asinm(a.mf); return(a); }
     friend mfloat atan(mfloat a)		 { atanm(a.mf); return(a); }
     friend mfloat atan2(mfloat a, const mfloat &b) { atan2m(a.mf, b.mf); return(a); }
/*?*/friend mfloat atofm(const char *s)		 { mfloat t; strtomf_(t.mf,s,strlen(s)); return(t); }
     friend mfloat ceil(mfloat a)		 { ceilm(a.mf); return(a); }
     friend mfloat cos(mfloat a)		 { cosm(a.mf); return(a); }
     friend mfloat cosh(mfloat a)		 { coshm(a.mf); return(a); }
     friend mfloat exp(mfloat a)		 { expm(a.mf); return(a); }
     friend mfloat fabs(mfloat a)		 { fabsm(a.mf); return(a); }
     friend mfloat floor(mfloat a)		 { floorm(a.mf); return(a); }
     friend mfloat fmod(mfloat a, const mfloat &b) { fmodm(a.mf, b.mf); return(a); }
     friend mfloat frexp(mfloat a, int *b) 	 { frexpm(a.mf,b); return(a); }
     friend mfloat hypot(mfloat a, const mfloat &b) { hypotm(a.mf, b.mf); return(a); }
     friend mfloat ldexp(mfloat a, int b)        { ldexpm(a.mf, b); return(a); }
     friend mfloat log(mfloat a)		 { logm(a.mf); return(a); }
     friend mfloat log10(mfloat a)		 { log10m(a.mf); return(a); }
     friend mfloat modf(mfloat a, mfloat * b)    { modfm(a.mf, (*b).mf); return(a); }
     friend mfloat pow(mfloat a, const mfloat &b){ powm(a.mf, b.mf); return(a); }
/*?*/friend mfloat pow10m(int b)                  { mfloat a; pow10m(a.mf, b); return(a); }
     friend mfloat sin(mfloat a)		 { sinm(a.mf); return(a); }
     friend mfloat sinh(mfloat a)		 { sinhm(a.mf); return(a); }
     friend mfloat sqrt(mfloat a)		 { sqrtm(a.mf); return(a); }
     friend mfloat tan(mfloat a)		 { tanm(a.mf); return(a); }
     friend mfloat tanh(mfloat a)		 { tanhm(a.mf); return(a); }
/* extended standard functions */
     friend mfloat acosh(mfloat a)		 { acoshm(a.mf); return(a); }
     friend mfloat asinh(mfloat a)		 { asinhm(a.mf); return(a); }
     friend mfloat atanh(mfloat a)		 { atanhm(a.mf); return(a); }
     friend mfloat acot(mfloat a)		 { acotm(a.mf); return(a); }
     friend mfloat acoth(mfloat a)		 { acothm(a.mf); return(a); }
     friend mfloat cot(mfloat a)		 { cotm(a.mf); return(a); }
     friend mfloat coth(mfloat a)		 { cothm(a.mf); return(a); }
     friend mfloat exp10(mfloat a)		 { exp10m(a.mf); return(a); }
     friend mfloat sqr(mfloat a)		 { sqrm(a.mf); return(a); }
     friend mfloat trunc(mfloat a)		 { truncm(a.mf); return(a); }
//private:
     mfloata mf;

#undef fmo
#undef fro
#undef fbo
};

#define maxdigits (mfloatwords*24/5+8)

ostream& operator<< (ostream& os, const mfloat &a) {
  char ch[maxdigits];
  int len = maxdigits;
  char format[10];
  char * f = format;

  if (os.flags() & os.showpos)   *(f++) = '+';
  if (os.flags() & os.showpoint) *(f++) = '.';

  f +=5;
  int i = os.precision();
  if (i <= 0) i = 6;
  for (int j=0; j<5; j++) { *(--f) = i % 10 + '0'; i /= 10; }
  f += 5;

  if      (os.flags() & os.fixed)      *f = 'f';
  else if (os.flags() & os.scientific) *f = 'e';
  else                                 *f = 'g';

  if (os.flags() & os.uppercase) *f -= 'a'-'A';
  *(++f) = 0;

  mftostr_(ch,a.mf,&len,format);
  ch[len] = 0;

  os << ch;

  return os;
}

istream& operator>> (istream& is, mfloat &a) {
  char ch[maxdigits];
  int old = is.width(maxdigits);
  is >> ch;
  is.width(old);
  if (ch[0] == 0) {
    is.clear(ios::badbit | is.rdstate());
    equm(a.mf,zerom);
  }
  else if (strtomf(a.mf,ch) != 0) {
    is.clear(ios::failbit | is.rdstate());
    equm(a.mf,zerom);
  }
  return(is);
}

#undef maxdigits

const mfloat pi = 2 * acos((mfloat) 0);

#endif /* #ifndef mfloat_cxx */
