title SpeedSet

fast	equ	43h	; scan code for f9 key
slow	equ	44h	; scan code for f10 key
kb_data	equ	60h	; PIO port A - contains scan code
kb_ctl	equ	61h	; PIO port B - contains unused bit
                        ; and keyboard acknowledge bit

code	segment         ; everything goes in code segment
	org	100h

	assume	cs:code        

DOS_entry	label	far     
	jmp	setup

old_int dd	?       ; address of interrupt 9 code in ROM     

new_int	proc	far     ; beginning of our interrupt handler
        sti             ; INT 9 turns off interrupts, reenable
	push	ax      ; save registers
	push	bx
	push	dx
	mov	ah,2	; tell INT 16 to return kb_flag
	int	16h	        ; get kb_flag
	and	al,00001000b	; mask bits except alt status
	cmp	al,00001000b	; check alt key status
	jne	short no_act    ; don't act if alt not pressed
	in	al,kb_data	; get scan code
        cmp     al,fast         ; is it the f9 key?
        je      short faster    ; speed up if it is
        cmp     al,slow         ; is it the f10 key?
	je	short slower    ; slow down if it is

no_act:	pop	dx              ; restore registers
	pop	bx
	pop	ax
	jmp	old_int         ; let ROM code do it's thing

done:	in	al,kb_ctl	; get keyboard status
	or	al,10000000b	; set keyboard acknowledge bit
	out	kb_ctl,al	; write it back to port 
	pop	dx              ; restore registers
	pop	bx
	pop	ax
	jmp	old_int         ; jump to ROM code to finish

faster: in	al,kb_ctl       ; get value from PIO port B
	and	al,11110111b    ; reset unused bit  
	out	kb_ctl,al       ; write it back to port B
        jmp	short done      ; finish

slower: in	al,kb_ctl       ; get value from PIO port B
	or	al,00001000b    ; set unused bit
	out	kb_ctl,al       ; write it back to port B
        jmp	short done      ; finish

new_int	endp                    ; end of our interrupt 

end_res_code:

sign_on	db	13,10,18 dup (32),201,42 dup (205),187,13,10
	db	18 dup (32),186,'        SPEED SWITCH NOW '
        db      'INSTALLED        ',186,13,10,18 dup (32)
        db      186,' Alt F9 ',26,' Slow     ',1,'  '
	db	2,'    Alt F10 ',26,' Fast ',186,13,10
	db	18 dup (32),200,42 dup (205),188,13,10,'$'

err_msg	db	13,10,'SPEED SWITCH ALREADY INSTALLED'
        db      13,10,'$'

	assume	ds:code

setup   proc    near            ; install our routine
                                ; as resident code 
	mov	ax,3509h        ; get address of interrupt 9
	int	21h
	mov	ax,es           ; segment is returned in es
	cmp	ax,0f000h       ; is this address in ROM?
	je	short install   ; if so, install our code
	mov	dx,offset err_msg       ; if not, write msg
	mov	ah,9            ; that our code is already 
	int	21h             ; installed
	int	20h             ; exit to DOS
install:mov	dx,offset sign_on       ; write sign on msg
	mov	ah,9
	int	21h
	mov	word ptr old_int,bx     ; save ROM address
	mov	word ptr old_int+2,es   ; of interrupt 9
	mov	dx,offset new_int       ; set up new
	mov	ax,2509h                ; interrupt vector
	int	21h
	mov	dx,offset end_res_code  ; make our code
	int	27h                     ; resident

setup   endp
code	ends
	end	DOS_entry

