comment ~
Listing 1- Sample Program (file syhlt0.asm)

(C) Copyright 1987 Ken Berry- All rights reserved.
Copies may be made for non-commercial, private use only.
~

     title syhlt0.asm porting macros test program
     name syhlt0

     include syhl.mac    ; include porting defintions

     _cmplr              ; specify compiler and memory model

; external declarations

     _xb  xbyte          ; external byte label
     _xw  xword          ; external word label
     _xd  xdword         ; external double word label
     _xq  xqword         ; external quad word label
     _xt  xtbyte         ; external ten byte label
     _xnp xnearp         ; external near procedure label
     _xfp xfarp          ; external far procedure label
     _xp  xproc          ; external procedure label (depends on code size)
     _xcp xcodept        ; external code pointer label
     _xdp xdatapt        ; external data pointer label

; static data

     _begs data          ; begin static data segment

     _db dbyte,0,0,public ; byte
     _db dstring,1,30,public ; data string (30 characters)
     _dw dword,2         ; word
     _dd ddword,3        ; double word
     _dd dqword,4        ; quad word
     _dt dtbyte,5        ; ten byte
     _dcp dcodept,6      ; code pointer
     _lbw <public,ddatawpt> ; public symbol ddatawpt = ddatapt
     _ddp ddatapt,7      ; data pointer

     _ends               ; end static data segment

; code

     _begs code          ; begin code segment

     _dclp subr0,<public,far> ; subr0 function declaration

     _pb b0              ; parameter b0
     _pw w1              ; parameter w1

     _lw w2              ; local w2

     _begp               ; subr0 entry code

     _call subr1,<w2,w2> ; call subr1

     _endp               ; subr0 exit code

     _dclp subr1         ; subr1 function declaration

     _pw w0              ; parameter w0
     _pw w1              ; parameter w1

     _begp               ; subr1 entry code

     mov ax,w0           ; compute w0 + w1
     add ax,w1

     _endp               ; subr1 exit code

     _ends               ; end code segment

     end                 ; end of program

comment ~
end of Listing 1
~
