**************************************************
*** NAME: DRAWMENU.PRG
***
*** AUTHOR: BRETT FISHBURNE
***
*** PURPOSE: DRAW A MENU DEFINED IN THE MENUFILE DATABASE
***
**************************************************
PARAMETER Layout, Instruction, Menu

*** ESTABLISH ENVIRONMENT
SET TALK OFF
SET ECHO OFF
SET STATUS OFF
SET SCOREBOARD OFF
SET EXACT ON

*** PREPARE THE DATABASE
SELECT 1
USE MENUFILE
SET FILTER TO TRIM(TITLE)=TRIM(Menu)
GOTO TOP
SELECT 2
USE TILESETS
SELECT 1

*** DRAW BOX
@ 2,0 TO 2,79 DOUBLE
@ 0,0 TO 21,79 DOUBLE

*** FILL IN HEADER AND FOOTER
@ 1,2 SAY SYSTEM
@ 1,40-INT(LEN(TRIM(TITLE))/2) SAY TITLE
@ 1,55 SAY TIME()
@ 1,71 SAY DATE()
@ 22,40-INT(LEN(TRIM(Instruction))/2) SAY Instruction

*** ESTABLISH TILE BOUNDARIES
SELECT 2
GOTO Layout

*** DRAW TILES
i = '0'
temp2 = 1
DO WHILE temp2 # 0

  mline&i = VAL(LEFT(TILE&i,2)) + 1
  mHorz&i = VAL(SUBSTR(TILE&i,4,2)) + 2
  temp = TILE&i
  @ &temp

  i = STR(VAL(i) + 1)
  IF i = '10'
    EXIT
  ELSE
    i = LTRIM(i)
    temp2 = LEN(TRIM(TILE&i))
  ENDIF

ENDDO

*** PUT OPTIONS AND TITLES IN TILES
SELECT 1
DO WHILE .NOT. EOF()

  temp = STR(TILE,1)
  DO CASE

    CASE ELEMENT_TY = 1
      *** TITLE
      @ mline&temp, mHorz&temp + ELEMENT_NO SAY TRIM(ELEMENT)
      @ mline&temp + 1,mHorz&temp + ELEMENT_NO SAY ;
        REPLICATE('-',ELEMENT_SI)
      mline&temp = mline&temp + 2

    CASE ELEMENT_TY = 2
      *** OPTION
      @ mline&temp, mHorz&temp SAY CHR(64 + ELEMENT_NO) + ' -- ';
                                   + TRIM(ELEMENT)
      mline&temp = mline&temp + 1

    CASE ELEMENT_TY = 3
      *** CONTINUATION
      @ mline&temp, mHorz&temp + 5 SAY TRIM(ELEMENT)
      mline&temp = mline&temp + 1

    CASE ELEMENT_TY = 4
      *** MESSAGE
      @ mline&temp, ELEMENT_NO SAY TRIM(ELEMENT)

  ENDCASE

  SKIP
ENDDO
