**************************************************************
*** NAME: MAINMENU.PRG
***
*** AUTHOR: BRETT FISHBURNE
***
*** PURPOSE: MAINMENU FOR THE AIRPORT DATABASE
***
**************************************************************
*** ESTABLISH ENVIRONMENT
SET ECHO OFF
SET TALK OFF
SET STATUS OFF
SET SCOREBOARD OFF

*** INITIALIZE CONSTANTS
MaxLetter = 'F'

*** SET UP INFINITE LOOP
DO WHILE .T.
  
  *** DRAW MAIN SCREEN
  CLEAR
  @ 2,0 TO 2,79 DOUBLE
  @ 0,0 TO 21,79 DOUBLE
  @ 1,2 SAY "ATC Data Management System"
  SET COLOR TO W+
  @ 1,36 SAY "MAIN MENU"
  SET COLOR TO
  @ 1,55 SAY TIME()
  @ 1,70 SAY DATE()

  *** DRAW LIST OF OPTIONS

  *** DRAW MEMBERS OPTIONS
  @ 3,5 TO 12,35
  @  5,16 SAY "MEMBERS"
  @  6,16 SAY "-------"
  @  7,9  SAY "A -- Add a New Member"
  @  8,9  SAY "B -- Delete a Member"
  @  9,9  SAY "C -- Edit a Member"
  
  *** DRAW INVENTORY OPTIONS
  @ 3,44 TO 12,74
  @  5,54 SAY "INVENTORY"
  @  6,54 SAY "---------"
  @  7,49 SAY "D -- Add an Item"
  @  8,49 SAY "E -- Delete an Item"
  @  9,49 SAY "F -- Edit an Item"
  
  *** DRAW REPORT OPTIONS
  @ 13,5 TO 20,74
  @ 14,34 SAY "REPORT OPTIONS"
  @ 15,34 SAY "--------------"

  *** WRITE OUT MENU PROMPT
  @ 22,13 SAY "Strike a LETTER key to evoke the corresponding 
operation"

  *** WAIT FOR USER RESPONSE
  i = 0
  DO WHILE i = 0
    @ 1,55 SAY TIME()
    i = INKEY()
    
    *** CALL USER OPTION
    IF (UPPER(CHR(i)) >= 'A') .AND. (UPPER(CHR(i)) <= MaxLetter)
      SubProg = "main"+ CHR(i)
      DO &SubProg
    ELSE
      i = 0
    ENDIF

  ENDDO

ENDDO