******************************************************
*** NAME:  PICTWORD.PRG
***
*** AUTHOR: BRETT FISHBURNE
***
*** PURPOSE: ALLOW WORD ENTRY
***
*****************************************************
PARAMETERS Program, Menu, TileNo

*** ESTABLISH ENVIRONMENT
SET ECHO OFF
SET TALK OFF
SET STATUS OFF
SET SCOREBOARD OFF

*** DETERMINE THE NUMBER OF OPTIONS IN THE FILE
SELECT MENUFILE
SET FILTER TO TRIM(SYSTEM) + TRIM(TITLE) = TRIM(Program);
              + TRIM(Menu)
GOTO TOP
COUNT FOR ELEMENT_TY = 2 TO Last_Lett
Letter = CHR(Last_Lett + 64)
GOTO TOP

*** DETERMINE IF THIS IS A NEW TILE OR NOT
SET FILTER TO TRIM(SYSTEM) + TRIM(TITLE) + TRIM(STR(TILE)) =;
              TRIM(Program) + TRIM(Menu) + TRIM(STR(TileNo))
GOTO TOP
COUNT FOR ELEMENT_TY = 2 TO Last_Lett
GOTO TOP

*** INITIALIZE VARIABLES
FirstTime = .T.
QQuit = .F.
i = '13'
Pict = "'" + REPLICATE('X',75) + "'"
DO WHILE VAL(i) > 0
  Last&i = SPACE(75)
  i = LTRIM(STR(VAL(i) - 1))
ENDDO
GOTO TOP
FirstTime = .T.
DO WHILE ((.NOT. EOF()).AND.(ELEMENT_TY # 1))
  SKIP
ENDDO
IF .NOT. EOF()
  Editing = .T.
  Entry = ELEMENT
ELSE
  Editing = .F.
  ENTRY = SPACE(78)
ENDIF

*** DRAW SCREEN
CLEAR
@ 2,0 TO 2,79 DOUBLE
@ 0,0 TO 21,79 DOUBLE
@ 1,2 SAY Program
@ 1,(40-INT(LEN(Menu)/2)) SAY Menu
@ 1,55 SAY TIME()
@ 1,70 SAY DATE()

*** CREATE A LOOP TO GET ENTRIES
DO WHILE .NOT. QQuit

  *** UPDATE SCROLLED PART OF SCREEN
  @ 7,1 CLEAR TO 20,78
  @ 7,1 TO 20,78
  i = '1'
  DO WHILE VAL(i) < 13
    @ 7+VAL(i),2 SAY TRIM(Last&i)
    i = LTRIM(STR(VAL(i) + 1))
  ENDDO

  *** UPDATE TIME AND DATE
  @ 1,55 SAY TIME()
  @ 1,70 SAY DATE()

  *** INITIALIZE VARIABLES FOR INPUT
  IF FirstTime
    EType = 1
  ELSE
    EType = 2
  ENDIF

  *** GET NEXT ENTRY
  IF FirstTime
    @ 4,3 GET Entry PICTURE &Pict
  ELSE
    @ 6,3 CLEAR TO 6,78
    @ 6,3 GET Entry PICTURE &Pict
  ENDIF
  READ

  *** PROCESS ENTRY IF NECESSARY
  IF LEN(TRIM(Entry))=0
    QQuit = .T.
  ELSE
    IF FirstTime
      @ 4,2 CLEAR TO 4,78
      @ 4,(40-INT(LEN(TRIM(Entry))/2)) SAY TRIM(Entry)
      IF .NOT. EOF()
        REPLACE ELEMENT WITH Entry
        REPLACE ELEMENT_SI WITH LEN(TRIM(Entry))
        GOTO TOP
        DO WHILE ((ELEMENT_TY # 2).AND.(.NOT. EOF()))
          SKIP
        ENDDO
        IF .NOT. EOF()
          Entry = ELEMENT
        ELSE
          ENTRY = SPACE(73)
        ENDIF
      ELSE
        SET FILTER TO
        GOTO TOP
        APPEND BLANK
        REPLACE SYSTEM WITH Program
        REPLACE TITLE WITH Menu
        REPLACE TILE WITH TileNo
        REPLACE ELEMENT_TY WITH 1
        REPLACE ELEMENT_SI WITH LEN(TRIM(Entry))
        REPLACE ELEMENT WITH Entry
        GOTO BOTT
        SKIP
      ENDIF
      I_No = '1'
      FirstTime = .F.
    ELSE
      LAST&I_No = Entry
      IF I_NO # '13'
        I_No = LTRIM(STR(VAL(I_No) + 1))
      ENDIF
      IF .NOT. EOF()
        REPLACE ELEMENT_SI WITH LEN(TRIM(Entry))
        REPLACE ELEMENT WITH Entry
        SKIP
        DO WHILE ((.NOT. EOF()).AND.(ELEMENT_TY # 2))
          SKIP
        ENDDO
        IF .NOT. EOF()
          Entry = SPACE(75)
        ELSE
          Entry = ELEMENT
        ENDIF
      ELSE
        SET FILTER TO
        GOTO TOP
        APPEND BLANK
        REPLACE SYSTEM WITH Program
        REPLACE TITLE WITH Menu
        REPLACE TILE WITH TileNo
        REPLACE ELEMENT_TY WITH 2
        REPLACE ELEMENT_NO WITH Last_Lett
        REPLACE ELEMENT_SI WITH LEN(TRIM(Entry))
        REPLACE ELEMENT WITH Entry
        Last_Lett = Last_Lett+1
        GOTO BOTT
        SKIP
      ENDIF
    ENDIF
    i = '1'
    DO WHILE VAL(i) < 13
      Next_I = LTRIM(STR(VAL(i) + 1))
      LAST&i = LAST&Next_I
      i = Next_I
    ENDDO
  ENDIF
ENDDO
RETURN
