/* CHARGEN.C - generates file of character definitions for use with printer
               graphics library (PR-GRAPH.C) in Micro Cornucopia Magazine
               Issue #45.

               Byte 0 holds the bottom "scan line" of the character and byte
               11 holds the top line. Caps typically go from byte 2 to 11.
               Descenders use byte 0 through 2. */


#include <stdio.h>

char p_chars [256][11];       /* holds 11 byte definition for each character */




void load_array ()
{
  int i;

  for (i=0; i<256; i++)           /* squares for the ones I haven't done yet */
  {
    p_chars[i][0] = 0xff; p_chars[i][1] = 0x81; p_chars[i][2] = 0x81;
    p_chars[i][3] = 0x81; p_chars[i][4] = 0x81; p_chars[i][5] = 0x81;
    p_chars[i][6] = 0x81; p_chars[i][7] = 0x81; p_chars[i][8] = 0x81;
    p_chars[i][9] = 0x81; p_chars[i][10] = 0xff;
  }

  /* space */
  p_chars[32][0] = 0; p_chars[32][1] = 0; p_chars[32][2] = 0;
  p_chars[32][3] = 0; p_chars[32][4] = 0; p_chars[32][5] = 0;
  p_chars[32][6] = 0; p_chars[32][7] = 0; p_chars[32][8] = 0;
  p_chars[32][9] = 0; p_chars[32][10] = 0;

  /* ! */
  p_chars[33][0] = 0; p_chars[33][1] = 0; p_chars[33][2] = 0x18;
  p_chars[33][3] = 0x18; p_chars[33][4] = 0; p_chars[33][5] = 0x18;
  p_chars[33][6] = 0x18; p_chars[33][7] = 0x18; p_chars[33][8] = 0x18;
  p_chars[33][9] = 0x18; p_chars[33][10] = 0x18;

  /* " */
  p_chars[34][0] = 0; p_chars[34][1] = 0; p_chars[34][2] = 0;
  p_chars[34][3] = 0; p_chars[34][4] = 0; p_chars[34][5] = 0;
  p_chars[34][6] = 0; p_chars[34][7] = 0x24; p_chars[34][8] = 0x66;
  p_chars[34][9] = 0x66; p_chars[34][10] = 0x66;

  /* # */
  p_chars[35][0] = 0; p_chars[35][1] = 0; p_chars[35][2] = 0x6c;
  p_chars[35][3] = 0x6c; p_chars[35][4] = 0xfe; p_chars[35][5] = 0x6c;
  p_chars[35][6] = 0x6c; p_chars[35][7] = 0x6c; p_chars[35][8] = 0xfe;
  p_chars[35][9] = 0x6c; p_chars[35][10] = 0x6c;

  /* $ */
  p_chars[36][0] = 0x10; p_chars[36][1] = 0x7c; p_chars[36][2] = 0xd6;
  p_chars[36][3] = 0x96; p_chars[36][4] = 0x0c; p_chars[36][5] = 0x38;
  p_chars[36][6] = 0x60; p_chars[36][7] = 0xd2; p_chars[36][8] = 0xd6;
  p_chars[36][9] = 0x7c; p_chars[36][10] = 0x10;

  /* % */
  p_chars[37][0] = 0; p_chars[37][1] = 0; p_chars[37][2] = 0xc6;
  p_chars[37][3] = 0x66; p_chars[37][4] = 0x30; p_chars[37][5] = 0x18;
  p_chars[37][6] = 0x0c; p_chars[37][7] = 0xc6; p_chars[37][8] = 0xc2;
  p_chars[37][9] = 0; p_chars[37][10] = 0;

  /* & */
  p_chars[38][0] = 0; p_chars[38][1] = 0; p_chars[38][2] = 0x76;
  p_chars[38][3] = 0xcc; p_chars[38][4] = 0xcc; p_chars[38][5] = 0xdc;
  p_chars[38][6] = 0x76; p_chars[38][7] = 0x38; p_chars[38][8] = 0x6c;
  p_chars[38][9] = 0x6c; p_chars[38][10] = 0x38;

  /* ' */
  p_chars[39][0] = 0; p_chars[39][1] = 0; p_chars[39][2] = 0;
  p_chars[39][3] = 0; p_chars[39][4] = 0; p_chars[39][5] = 0;
  p_chars[39][6] = 0; p_chars[39][7] = 0xc0; p_chars[39][8] = 0x60;
  p_chars[39][9] = 0x60; p_chars[39][10] = 0x60;

  /* ( */
  p_chars[40][0] = 0; p_chars[40][1] = 0; p_chars[40][2] = 0x18;
  p_chars[40][3] = 0x30; p_chars[40][4] = 0x60; p_chars[40][5] = 0x60;
  p_chars[40][6] = 0x60; p_chars[40][7] = 0x60; p_chars[40][8] = 0x60;
  p_chars[40][9] = 0x30; p_chars[40][10] = 0x18;

  /* ) */
  p_chars[41][0] = 0; p_chars[41][1] = 0; p_chars[41][2] = 0x18;
  p_chars[41][3] = 0x0c; p_chars[41][4] = 0x06; p_chars[41][5] = 0x06;
  p_chars[41][6] = 0x06; p_chars[41][7] = 0x06; p_chars[41][8] = 0x06;
  p_chars[41][9] = 0x0c; p_chars[41][10] = 0x18;

  /* * */
  p_chars[42][0] = 0; p_chars[42][1] = 0; p_chars[42][2] = 0;
  p_chars[42][3] = 0; p_chars[42][4] = 0x66; p_chars[42][5] = 0x3c;
  p_chars[42][6] = 0xff; p_chars[42][7] = 0x3c; p_chars[42][8] = 0x66;
  p_chars[42][9] = 0; p_chars[42][10] = 0;

  /* + */
  p_chars[43][0] = 0; p_chars[43][1] = 0; p_chars[43][2] = 0;
  p_chars[43][3] = 0x18; p_chars[43][4] = 0x18; p_chars[43][5] = 0x18;
  p_chars[43][6] = 0xff; p_chars[43][7] = 0x18; p_chars[43][8] = 0x18;
  p_chars[43][9] = 0x18; p_chars[43][10] = 0;

  /* , */
  p_chars[44][0] = 0; p_chars[44][1] = 0x30; p_chars[44][2] = 0x18;
  p_chars[44][3] = 0x18; p_chars[44][4] = 0x18; p_chars[44][5] = 0;
  p_chars[44][6] = 0; p_chars[44][7] = 0; p_chars[44][8] = 0;
  p_chars[44][9] = 0; p_chars[44][10] = 0;

  /* - */
  p_chars[45][0] = 0; p_chars[45][1] = 0; p_chars[45][2] = 0;
  p_chars[45][3] = 0; p_chars[45][4] = 0; p_chars[45][5] = 0;
  p_chars[45][6] = 0xff; p_chars[45][7] = 0; p_chars[45][8] = 0;
  p_chars[45][9] = 0; p_chars[45][10] = 0;

  /* . */
  p_chars[46][0] = 0; p_chars[46][1] = 0; p_chars[46][2] = 0x18;
  p_chars[46][3] = 0x18; p_chars[46][4] = 0; p_chars[46][5] = 0;
  p_chars[46][6] = 0; p_chars[46][7] = 0; p_chars[46][8] = 0;
  p_chars[46][9] = 0; p_chars[46][10] = 0;

  /* / */
  p_chars[47][0] = 0; p_chars[47][1] = 0; p_chars[47][2] = 0;
  p_chars[47][3] = 0x80; p_chars[47][4] = 0xc0; p_chars[47][5] = 0x60;
  p_chars[47][6] = 0x30; p_chars[47][7] = 0x18; p_chars[47][8] = 0x0c;
  p_chars[47][9] = 0x06; p_chars[47][10] = 0x02;

  /* 0 */
  p_chars[48][0] = 0; p_chars[48][1] = 0; p_chars[48][2] = 0x7c;
  p_chars[48][3] = 0xc6; p_chars[48][4] = 0xc6; p_chars[48][5] = 0xc6;
  p_chars[48][6] = 0xd6; p_chars[48][7] = 0xc6; p_chars[48][8] = 0xc6;
  p_chars[48][9] = 0xc6; p_chars[48][10] = 0x7c;

  /* 1 */
  p_chars[49][0] = 0; p_chars[49][1] = 0; p_chars[49][2] = 0x7e;
  p_chars[49][3] = 0x18; p_chars[49][4] = 0x18; p_chars[49][5] = 0x18;
  p_chars[49][6] = 0x18; p_chars[49][7] = 0x18; p_chars[49][8] = 0x78;
  p_chars[49][9] = 0x38; p_chars[49][10] = 0x18;

  /* 2 */
  p_chars[50][0] = 0; p_chars[50][1] = 0; p_chars[50][2] = 0xfe;
  p_chars[50][3] = 0xc6; p_chars[50][4] = 0x60; p_chars[50][5] = 0x30;
  p_chars[50][6] = 0x18; p_chars[50][7] = 0x0c; p_chars[50][8] = 0x06;
  p_chars[50][9] = 0xc6; p_chars[50][10] = 0x7c;

  /* 3 */
  p_chars[51][0] = 0; p_chars[51][1] = 0; p_chars[51][2] = 0x7c;
  p_chars[51][3] = 0xc6; p_chars[51][4] = 0x06; p_chars[51][5] = 0x06;
  p_chars[51][6] = 0x3c; p_chars[51][7] = 0x06; p_chars[51][8] = 0x06;
  p_chars[51][9] = 0xc6; p_chars[51][10] = 0x7c;

  /* 4 */
  p_chars[52][0] = 0; p_chars[52][1] = 0; p_chars[52][2] = 0x3c;
  p_chars[52][3] = 0x18; p_chars[52][4] = 0x18; p_chars[52][5] = 0xfc;
  p_chars[52][6] = 0xd8; p_chars[52][7] = 0xd8; p_chars[52][8] = 0x78;
  p_chars[52][9] = 0x38; p_chars[52][10] = 0x18;

  /* 5 */
  p_chars[53][0] = 0; p_chars[53][1] = 0; p_chars[53][2] = 0x7c;
  p_chars[53][3] = 0xc6; p_chars[53][4] = 0x06; p_chars[53][5] = 0x06;
  p_chars[53][6] = 0xfc; p_chars[53][7] = 0xc0; p_chars[53][8] = 0xc0;
  p_chars[53][9] = 0xc0; p_chars[53][10] = 0xfe;

  /* 6 */
  p_chars[54][0] = 0; p_chars[54][1] = 0; p_chars[54][2] = 0x7c;
  p_chars[54][3] = 0xc6; p_chars[54][4] = 0xc6; p_chars[54][5] = 0xc6;
  p_chars[54][6] = 0xfc; p_chars[54][7] = 0xc0; p_chars[54][8] = 0xc0;
  p_chars[54][9] = 0x62; p_chars[54][10] = 0x3c;

  /* 7 */
  p_chars[55][0] = 0; p_chars[55][1] = 0; p_chars[55][2] = 0x30;
  p_chars[55][3] = 0x30; p_chars[55][4] = 0x30; p_chars[55][5] = 0x30;
  p_chars[55][6] = 0x18; p_chars[55][7] = 0x0c; p_chars[55][8] = 0x06;
  p_chars[55][9] = 0xc6; p_chars[55][10] = 0xfe;

  /* 8 */
  p_chars[56][0] = 0; p_chars[56][1] = 0; p_chars[56][2] = 0x7c;
  p_chars[56][3] = 0xc6; p_chars[56][4] = 0xc6; p_chars[56][5] = 0xc6;
  p_chars[56][6] = 0x7c; p_chars[56][7] = 0xc6; p_chars[56][8] = 0xc6;
  p_chars[56][9] = 0xc6; p_chars[56][10] = 0x7c;

  /* 9 */
  p_chars[57][0] = 0; p_chars[57][1] = 0; p_chars[57][2] = 0x78;
  p_chars[57][3] = 0x8c; p_chars[57][4] = 0x06; p_chars[57][5] = 0x06;
  p_chars[57][6] = 0x7e; p_chars[57][7] = 0xc6; p_chars[57][8] = 0xc6;
  p_chars[57][9] = 0xc6; p_chars[57][10] = 0x7c;

  /* : */
  p_chars[58][0] = 0; p_chars[58][1] = 0; p_chars[58][2] = 0;
  p_chars[58][3] = 0x18; p_chars[58][4] = 0x18; p_chars[58][5] = 0;
  p_chars[58][6] = 0; p_chars[58][7] = 0; p_chars[58][8] = 0x18;
  p_chars[58][9] = 0x18; p_chars[58][10] = 0;

  /* ; */
  p_chars[59][0] = 0; p_chars[59][1] = 0; p_chars[59][2] = 0x30;
  p_chars[59][3] = 0x18; p_chars[59][4] = 0x18; p_chars[59][5] = 0;
  p_chars[59][6] = 0; p_chars[59][7] = 0; p_chars[59][8] = 0x18;
  p_chars[59][9] = 0x18; p_chars[59][10] = 0;

  /* < */
  p_chars[60][0] = 0; p_chars[60][1] = 0; p_chars[60][2] = 0x0c;
  p_chars[60][3] = 0x18; p_chars[60][4] = 0x30; p_chars[60][5] = 0x60;
  p_chars[60][6] = 0xc0; p_chars[60][7] = 0x60; p_chars[60][8] = 0x30;
  p_chars[60][9] = 0x18; p_chars[60][10] = 0x0c;

  /* = */
  p_chars[61][0] = 0; p_chars[61][1] = 0; p_chars[61][2] = 0;
  p_chars[61][3] = 0; p_chars[61][4] = 0xfc; p_chars[61][5] = 0;
  p_chars[61][6] = 0; p_chars[61][7] = 0xfc; p_chars[61][8] = 0;
  p_chars[61][9] = 0; p_chars[61][10] = 0;

  /* > */
  p_chars[62][0] = 0; p_chars[62][1] = 0; p_chars[62][2] = 0xc0;
  p_chars[62][3] = 0x60; p_chars[62][4] = 0x30; p_chars[62][5] = 0x18;
  p_chars[62][6] = 0x0c; p_chars[62][7] = 0x18; p_chars[62][8] = 0x30;
  p_chars[62][9] = 0x60; p_chars[62][10] = 0xc0;

  /* ? */
  p_chars[63][0] = 0; p_chars[63][1] = 0; p_chars[63][2] = 0x18;
  p_chars[63][3] = 0x18; p_chars[63][4] = 0; p_chars[63][5] = 0x18;
  p_chars[63][6] = 0x18; p_chars[63][7] = 0x0c; p_chars[63][8] = 0xc6;
  p_chars[63][9] = 0xc6; p_chars[63][10] = 0x7c;

  /* @ */
  p_chars[64][0] = 0; p_chars[64][1] = 0; p_chars[64][2] = 0x60;
  p_chars[64][3] = 0xc0; p_chars[64][4] = 0xdc; p_chars[64][5] = 0xde;
  p_chars[64][6] = 0xde; p_chars[64][7] = 0xde; p_chars[64][8] = 0xc6;
  p_chars[64][9] = 0xc6; p_chars[64][10] = 0x7c;

  /* A */
  p_chars[65][0] = 0; p_chars[65][1] = 0; p_chars[65][2] = 0xc6;
  p_chars[65][3] = 0xc6; p_chars[65][4] = 0xc6; p_chars[65][5] = 0xfe;
  p_chars[65][6] = 0xc6; p_chars[65][7] = 0xc6; p_chars[65][8] = 0x6c;
  p_chars[65][9] = 0x38; p_chars[65][10] = 0x10;

  /* B */
  p_chars[66][0] = 0; p_chars[66][1] = 0; p_chars[66][2] = 0xfc;
  p_chars[66][3] = 0x66; p_chars[66][4] = 0x66; p_chars[66][5] = 0x66;
  p_chars[66][6] = 0x7c; p_chars[66][7] = 0x66; p_chars[66][8] = 0x66;
  p_chars[66][9] = 0x66; p_chars[66][10] = 0xfc;

  /* C */
  p_chars[67][0] = 0; p_chars[67][1] = 0; p_chars[67][2] = 0x3c;
  p_chars[67][3] = 0x66; p_chars[67][4] = 0xc2; p_chars[67][5] = 0xc0;
  p_chars[67][6] = 0xc0; p_chars[67][7] = 0xc0; p_chars[67][8] = 0xc2;
  p_chars[67][9] = 0x66; p_chars[67][10] = 0x103c;

  /* D */
  p_chars[68][0] = 0; p_chars[68][1] = 0; p_chars[68][2] = 0xf8;
  p_chars[68][3] = 0x6c; p_chars[68][4] = 0x66; p_chars[68][5] = 0x66;
  p_chars[68][6] = 0x66; p_chars[68][7] = 0x66; p_chars[68][8] = 0x66;
  p_chars[68][9] = 0x6c; p_chars[68][10] = 0xf8;

  /* E */
  p_chars[69][0] = 0; p_chars[69][1] = 0; p_chars[69][2] = 0xfe;
  p_chars[69][3] = 0x66; p_chars[69][4] = 0x62; p_chars[69][5] = 0x68;
  p_chars[69][6] = 0x78; p_chars[69][7] = 0x68; p_chars[69][8] = 0x62;
  p_chars[69][9] = 0x66; p_chars[69][10] = 0xfe;

  /* F */
  p_chars[70][0] = 0; p_chars[70][1] = 0; p_chars[70][2] = 0xf0;
  p_chars[70][3] = 0x60; p_chars[70][4] = 0x60; p_chars[70][5] = 0x68;
  p_chars[70][6] = 0x78; p_chars[70][7] = 0x68; p_chars[70][8] = 0x62;
  p_chars[70][9] = 0x66; p_chars[70][10] = 0xfe;

  /* G */
  p_chars[71][0] = 0; p_chars[71][1] = 0; p_chars[71][2] = 0x3a;
  p_chars[71][3] = 0x66; p_chars[71][4] = 0xc6; p_chars[71][5] = 0xde;
  p_chars[71][6] = 0xc0; p_chars[71][7] = 0xc0; p_chars[71][8] = 0xc2;
  p_chars[71][9] = 0x66; p_chars[71][10] = 0x3c;

  /* H */
  p_chars[72][0] = 0; p_chars[72][1] = 0; p_chars[72][2] = 0xc6;
  p_chars[72][3] = 0xc6; p_chars[72][4] = 0xc6; p_chars[72][5] = 0xc6;
  p_chars[72][6] = 0xfe; p_chars[72][7] = 0xc6; p_chars[72][8] = 0xc6;
  p_chars[72][9] = 0xc6; p_chars[72][10] = 0xc6;

  /* I */
  p_chars[73][0] = 0; p_chars[73][1] = 0; p_chars[73][2] = 0x78;
  p_chars[73][3] = 0x30; p_chars[73][4] = 0x30; p_chars[73][5] = 0x30;
  p_chars[73][6] = 0x30; p_chars[73][7] = 0x30; p_chars[73][8] = 0x30;
  p_chars[73][9] = 0x30; p_chars[73][10] = 0x78;

  /* J */
  p_chars[74][0] = 0; p_chars[74][1] = 0; p_chars[74][2] = 0x78;
  p_chars[74][3] = 0xcc; p_chars[74][4] = 0xec; p_chars[74][5] = 0x0c;
  p_chars[74][6] = 0x0c; p_chars[74][7] = 0x0c; p_chars[74][8] = 0x0c;
  p_chars[74][9] = 0x0c; p_chars[74][10] = 0x1e;

  /* K */
  p_chars[75][0] = 0; p_chars[75][1] = 0; p_chars[75][2] = 0xe6;
  p_chars[75][3] = 0x66; p_chars[75][4] = 0x6c; p_chars[75][5] = 0x6c;
  p_chars[75][6] = 0x78; p_chars[75][7] = 0x6c; p_chars[75][8] = 0x6c;
  p_chars[75][9] = 0x66; p_chars[75][10] = 0xe6;

  /* L */
  p_chars[76][0] = 0; p_chars[76][1] = 0; p_chars[76][2] = 0xfe;
  p_chars[76][3] = 0x66; p_chars[76][4] = 0x62; p_chars[76][5] = 0x60;
  p_chars[76][6] = 0x60; p_chars[76][7] = 0x60; p_chars[76][8] = 0x60;
  p_chars[76][9] = 0x60; p_chars[76][10] = 0xf0;

  /* M */
  p_chars[77][0] = 0; p_chars[77][1] = 0; p_chars[77][2] = 0xc3;
  p_chars[77][3] = 0xc3; p_chars[77][4] = 0xc3; p_chars[77][5] = 0xc3;
  p_chars[77][6] = 0xc3; p_chars[77][7] = 0xdb; p_chars[77][8] = 0xff;
  p_chars[77][9] = 0xe7; p_chars[77][10] = 0xc3;

  /* N */
  p_chars[78][0] = 0; p_chars[78][1] = 0; p_chars[78][2] = 0xc6;
  p_chars[78][3] = 0xc6; p_chars[78][4] = 0xc6; p_chars[78][5] = 0xce;
  p_chars[78][6] = 0xde; p_chars[78][7] = 0xfe; p_chars[78][8] = 0xf6;
  p_chars[78][9] = 0xe6; p_chars[78][10] = 0xc6;

  /* O */
  p_chars[79][0] = 0; p_chars[79][1] = 0; p_chars[79][2] = 0x38;
  p_chars[79][3] = 0x6c; p_chars[79][4] = 0xc6; p_chars[79][5] = 0xc6;
  p_chars[79][6] = 0xc6; p_chars[79][7] = 0xc6; p_chars[79][8] = 0xc6;
  p_chars[79][9] = 0x6c; p_chars[79][10] = 0x38;

  /* P */
  p_chars[80][0] = 0; p_chars[80][1] = 0; p_chars[80][2] = 0xf0;
  p_chars[80][3] = 0x60; p_chars[80][4] = 0x60; p_chars[80][5] = 0x60;
  p_chars[80][6] = 0x7c; p_chars[80][7] = 0x66; p_chars[80][8] = 0x66;
  p_chars[80][9] = 0x66; p_chars[80][10] = 0xfc;

  /* Q */
  p_chars[81][0] = 0x0e; p_chars[81][1] = 0x0c; p_chars[81][2] = 0x7c;
  p_chars[81][3] = 0xde; p_chars[81][4] = 0xd6; p_chars[81][5] = 0xc6;
  p_chars[81][6] = 0xc6; p_chars[81][7] = 0xc6; p_chars[81][8] = 0xc6;
  p_chars[81][9] = 0xc6; p_chars[81][10] = 0x7c;

  /* R */
  p_chars[82][0] = 0; p_chars[82][1] = 0; p_chars[82][2] = 0xe6;
  p_chars[82][3] = 0x66; p_chars[82][4] = 0x66; p_chars[82][5] = 0x6c;
  p_chars[82][6] = 0x7c; p_chars[82][7] = 0x66; p_chars[82][8] = 0x66;
  p_chars[82][9] = 0x64; p_chars[82][10] = 0xf8;

  /* S */
  p_chars[83][0] = 0; p_chars[83][1] = 0; p_chars[83][2] = 0x7c;
  p_chars[83][3] = 0xc6; p_chars[83][4] = 0xc6; p_chars[83][5] = 0x0c;
  p_chars[83][6] = 0x38; p_chars[83][7] = 0x60; p_chars[83][8] = 0xc6;
  p_chars[83][9] = 0xc6; p_chars[83][10] = 0x7c;

  /* T */
  p_chars[84][0] = 0; p_chars[84][1] = 0; p_chars[84][2] = 0x3c;
  p_chars[84][3] = 0x18; p_chars[84][4] = 0x18; p_chars[84][5] = 0x18;
  p_chars[84][6] = 0x18; p_chars[84][7] = 0x18; p_chars[84][8] = 0x99;
  p_chars[84][9] = 0xdb; p_chars[84][10] = 0xff;

  /* U */
  p_chars[85][0] = 0; p_chars[85][1] = 0; p_chars[85][2] = 0x7c;
  p_chars[85][3] = 0xc6; p_chars[85][4] = 0xc6; p_chars[85][5] = 0xc6;
  p_chars[85][6] = 0xc6; p_chars[85][7] = 0xc6; p_chars[85][8] = 0xc6;
  p_chars[85][9] = 0xc6; p_chars[85][10] = 0xc6;

  /* V */
  p_chars[86][0] = 0; p_chars[86][1] = 0; p_chars[86][2] = 0x10;
  p_chars[86][3] = 0x38; p_chars[86][4] = 0x6c; p_chars[86][5] = 0xc6;
  p_chars[86][6] = 0xc6; p_chars[86][7] = 0xc6; p_chars[86][8] = 0xc6;
  p_chars[86][9] = 0xc6; p_chars[86][10] = 0xc6;

  /* W */
  p_chars[87][0] = 0; p_chars[87][1] = 0; p_chars[87][2] = 0x24;
  p_chars[87][3] = 0x7e; p_chars[87][4] = 0xdb; p_chars[87][5] = 0xdb;
  p_chars[87][6] = 0xdb; p_chars[87][7] = 0xc3; p_chars[87][8] = 0xc3;
  p_chars[87][9] = 0xc3; p_chars[87][10] = 0xc3;

  /* X */
  p_chars[88][0] = 0; p_chars[88][1] = 0; p_chars[88][2] = 0xc6;
  p_chars[88][3] = 0xc6; p_chars[88][4] = 0x6c; p_chars[88][5] = 0x38;
  p_chars[88][6] = 0x10; p_chars[88][7] = 0x38; p_chars[88][8] = 0x6c;
  p_chars[88][9] = 0xc6; p_chars[88][10] = 0xc6;

  /* Y */
  p_chars[89][0] = 0; p_chars[89][1] = 0; p_chars[89][2] = 0x3c;
  p_chars[89][3] = 0x18; p_chars[89][4] = 0x18; p_chars[89][5] = 0x18;
  p_chars[89][6] = 0x3c; p_chars[89][7] = 0x66; p_chars[89][8] = 0xc3;
  p_chars[89][9] = 0xc3; p_chars[89][10] = 0xc3;

  /* Z */
  p_chars[90][0] = 0; p_chars[90][1] = 0; p_chars[90][2] = 0xff;
  p_chars[90][3] = 0xc3; p_chars[90][4] = 0x61; p_chars[90][5] = 0x30;
  p_chars[90][6] = 0x18; p_chars[90][7] = 0x0c; p_chars[90][8] = 0x86;
  p_chars[90][9] = 0xc3; p_chars[90][10] = 0xff;

  /* [ */
  p_chars[91][0] = 0; p_chars[91][1] = 0; p_chars[91][2] = 0x78;
  p_chars[91][3] = 0x60; p_chars[91][4] = 0x60; p_chars[91][5] = 0x60;
  p_chars[91][6] = 0x60; p_chars[91][7] = 0x60; p_chars[91][8] = 0x60;
  p_chars[91][9] = 0x60; p_chars[91][10] = 0x78;

  /* \ */
  p_chars[92][0] = 0; p_chars[92][1] = 0; p_chars[92][2] = 0;
  p_chars[92][3] = 0x02; p_chars[92][4] = 0x06; p_chars[92][5] = 0x0c;
  p_chars[92][6] = 0x18; p_chars[92][7] = 0x30; p_chars[92][8] = 0x60;
  p_chars[92][9] = 0xc0; p_chars[92][10] = 0x80;

  /* ] */
  p_chars[93][0] = 0; p_chars[93][1] = 0; p_chars[93][2] = 0x78;
  p_chars[93][3] = 0x18; p_chars[93][4] = 0x18; p_chars[93][5] = 0x18;
  p_chars[93][6] = 0x18; p_chars[93][7] = 0x18; p_chars[93][8] = 0x18;
  p_chars[93][9] = 0x18; p_chars[93][10] = 0x78;

  /* ^ */
  p_chars[94][0] = 0; p_chars[94][1] = 0; p_chars[94][2] = 0;
  p_chars[94][3] = 0; p_chars[94][4] = 0; p_chars[94][5] = 0;
  p_chars[94][6] = 0; p_chars[94][7] = 0xc6; p_chars[94][8] = 0x6c;
  p_chars[94][9] = 0x38; p_chars[94][10] = 0x10;

  /* _ */
  p_chars[95][0] = 0xfe; p_chars[95][1] = 0; p_chars[95][2] = 0;
  p_chars[95][3] = 0; p_chars[95][4] = 0; p_chars[95][5] = 0;
  p_chars[95][6] = 0; p_chars[95][7] = 0; p_chars[95][8] = 0;
  p_chars[95][9] = 0; p_chars[95][10] = 0;

  /* ` */
  p_chars[96][0] = 0; p_chars[96][1] = 0; p_chars[96][2] = 0;
  p_chars[96][3] = 0; p_chars[96][4] = 0; p_chars[96][5] = 0;
  p_chars[96][6] = 0; p_chars[96][7] = 0x06; p_chars[96][8] = 0x0c;
  p_chars[96][9] = 0x0c; p_chars[96][10] = 0x0c;

  /* a */
  p_chars[97][0] = 0; p_chars[97][1] = 0; p_chars[97][2] = 0x76;
  p_chars[97][3] = 0xcc; p_chars[97][4] = 0xcc; p_chars[97][5] = 0x7c;
  p_chars[97][6] = 0x0c; p_chars[97][7] = 0x78; p_chars[97][8] = 0;
  p_chars[97][9] = 0; p_chars[97][10] = 0;

  /* b */
  p_chars[98][0] = 0; p_chars[98][1] = 0; p_chars[98][2] = 0xdc;
  p_chars[98][3] = 0x66; p_chars[98][4] = 0x66; p_chars[98][5] = 0x66;
  p_chars[98][6] = 0x66; p_chars[98][7] = 0x7c; p_chars[98][8] = 0x60;
  p_chars[98][9] = 0x60; p_chars[98][10] = 0xe0;

  /* c */
  p_chars[99][0] = 0; p_chars[99][1] = 0; p_chars[99][2] = 0x7c;
  p_chars[99][3] = 0xc6; p_chars[99][4] = 0xc0; p_chars[99][5] = 0xc0;
  p_chars[99][6] = 0xc6; p_chars[99][7] = 0x7c; p_chars[99][8] = 0;
  p_chars[99][9] = 0; p_chars[99][10] = 0;

  /* d */
  p_chars[100][0] = 0; p_chars[100][1] = 0; p_chars[100][2] = 0x76;
  p_chars[100][3] = 0xcc; p_chars[100][4] = 0xcc; p_chars[100][5] = 0xcc;
  p_chars[100][6] = 0xcc; p_chars[100][7] = 0x7c; p_chars[100][8] = 0x0c;
  p_chars[100][9] = 0x0c; p_chars[100][10] = 0x1c;

  /* e */
  p_chars[101][0] = 0; p_chars[101][1] = 0; p_chars[101][2] = 0x7c;
  p_chars[101][3] = 0xc0; p_chars[101][4] = 0xfc; p_chars[101][5] = 0xc6;
  p_chars[101][6] = 0xc6; p_chars[101][7] = 0x7c; p_chars[101][8] = 0;
  p_chars[101][9] = 0; p_chars[101][10] = 0;

  /* f */
  p_chars[102][0] = 0; p_chars[102][1] = 0; p_chars[102][2] = 0xf0;
  p_chars[102][3] = 0x60; p_chars[102][4] = 0x60; p_chars[102][5] = 0x60;
  p_chars[102][6] = 0xf8; p_chars[102][7] = 0x60; p_chars[102][8] = 0x64;
  p_chars[102][9] = 0x6c; p_chars[102][10] = 0x78;

  /* g */
  p_chars[103][0] = 0x78; p_chars[103][1] = 0xcc; p_chars[103][2] = 0x0c;
  p_chars[103][3] = 0x7c; p_chars[103][4] = 0xcc; p_chars[103][5] = 0xcc;
  p_chars[103][6] = 0xcc; p_chars[103][7] = 0x76; p_chars[103][8] = 0;
  p_chars[103][9] = 0; p_chars[103][10] = 0;

  /* h */
  p_chars[104][0] = 0; p_chars[104][1] = 0; p_chars[104][2] = 0xe6;
  p_chars[104][3] = 0x66; p_chars[104][4] = 0x66; p_chars[104][5] = 0x66;
  p_chars[104][6] = 0x76; p_chars[104][7] = 0x6c; p_chars[104][8] = 0x60;
  p_chars[104][9] = 0x60; p_chars[104][10] = 0xe0;

  /* i */
  p_chars[105][0] = 0; p_chars[105][1] = 0; p_chars[105][2] = 0x3c;
  p_chars[105][3] = 0x18; p_chars[105][4] = 0x18; p_chars[105][5] = 0x18;
  p_chars[105][6] = 0x18; p_chars[105][7] = 0x38; p_chars[105][8] = 0;
  p_chars[105][9] = 0x18; p_chars[105][10] = 0x18;

  /* j */
  p_chars[106][0] = 0x78; p_chars[106][1] = 0xcc; p_chars[106][2] = 0xcc;
  p_chars[106][3] = 0x0c; p_chars[106][4] = 0x0c; p_chars[106][5] = 0x0c;
  p_chars[106][6] = 0x0c; p_chars[106][7] = 0x1c; p_chars[106][8] = 0;
  p_chars[106][9] = 0x0c; p_chars[106][10] = 0x0c;

  /* k */
  p_chars[107][0] = 0; p_chars[107][1] = 0; p_chars[107][2] = 0xe6;
  p_chars[107][3] = 0x66; p_chars[107][4] = 0x6c; p_chars[107][5] = 0x78;
  p_chars[107][6] = 0x6c; p_chars[107][7] = 0x66; p_chars[107][8] = 0x60;
  p_chars[107][9] = 0x60; p_chars[107][10] = 0xe0;

  /* l */
  p_chars[108][0] = 0; p_chars[108][1] = 0; p_chars[108][2] = 0x3c;
  p_chars[108][3] = 0x18; p_chars[108][4] = 0x18; p_chars[108][5] = 0x18;
  p_chars[108][6] = 0x18; p_chars[108][7] = 0x18; p_chars[108][8] = 0x18;
  p_chars[108][9] = 0x18; p_chars[108][10] = 0x38;

  /* m */
  p_chars[109][0] = 0; p_chars[109][1] = 0; p_chars[109][2] = 0xdb;
  p_chars[109][3] = 0xdb; p_chars[109][4] = 0xdb; p_chars[109][5] = 0xdb;
  p_chars[109][6] = 0xff; p_chars[109][7] = 0xe6; p_chars[109][8] = 0;
  p_chars[109][9] = 0; p_chars[109][10] = 0;

  /* n */
  p_chars[110][0] = 0; p_chars[110][1] = 0; p_chars[110][2] = 0x66;
  p_chars[110][3] = 0x66; p_chars[110][4] = 0x66; p_chars[110][5] = 0x66;
  p_chars[110][6] = 0x66; p_chars[110][7] = 0xdc; p_chars[110][8] = 0;
  p_chars[110][9] = 0; p_chars[110][10] = 0;

  /* o */
  p_chars[111][0] = 0; p_chars[111][1] = 0; p_chars[111][2] = 0x7c;
  p_chars[111][3] = 0xc6; p_chars[111][4] = 0xc6; p_chars[111][5] = 0xc6;
  p_chars[111][6] = 0xc6; p_chars[111][7] = 0x7c; p_chars[111][8] = 0;
  p_chars[111][9] = 0; p_chars[111][10] = 0;

  /* p */
  p_chars[112][0] = 0xf0; p_chars[112][1] = 0x60; p_chars[112][2] = 0x60;
  p_chars[112][3] = 0x7c; p_chars[112][4] = 0x66; p_chars[112][5] = 0x66;
  p_chars[112][6] = 0x66; p_chars[112][7] = 0xdc; p_chars[112][8] = 0;
  p_chars[112][9] = 0; p_chars[112][10] = 0;

  /* q */
  p_chars[113][0] = 0x1e; p_chars[113][1] = 0x0c; p_chars[113][2] = 0x0c;
  p_chars[113][3] = 0x7c; p_chars[113][4] = 0xcc; p_chars[113][5] = 0xcc;
  p_chars[113][6] = 0xcc; p_chars[113][7] = 0x76; p_chars[113][8] = 0;
  p_chars[113][9] = 0; p_chars[113][10] = 0;

  /* r */
  p_chars[114][0] = 0; p_chars[114][1] = 0; p_chars[114][2] = 0xf0;
  p_chars[114][3] = 0x60; p_chars[114][4] = 0x60; p_chars[114][5] = 0x62;
  p_chars[114][6] = 0x76; p_chars[114][7] = 0xdc; p_chars[114][8] = 0;
  p_chars[114][9] = 0; p_chars[114][10] = 0;

  /* s */
  p_chars[115][0] = 0; p_chars[115][1] = 0; p_chars[115][2] = 0x7c;
  p_chars[115][3] = 0xc6; p_chars[115][4] = 0x1c; p_chars[115][5] = 0x70;
  p_chars[115][6] = 0xc6; p_chars[115][7] = 0x7c; p_chars[115][8] = 0;
  p_chars[115][9] = 0; p_chars[115][10] = 0;

  /* t */
  p_chars[116][0] = 0; p_chars[116][1] = 0; p_chars[116][2] = 0x1c;
  p_chars[116][3] = 0x36; p_chars[116][4] = 0x30; p_chars[116][5] = 0x30;
  p_chars[116][6] = 0x30; p_chars[116][7] = 0xfc; p_chars[116][8] = 0x30;
  p_chars[116][9] = 0x30; p_chars[116][10] = 0x10;

  /* u */
  p_chars[117][0] = 0; p_chars[117][1] = 0; p_chars[117][2] = 0x76;
  p_chars[117][3] = 0xcc; p_chars[117][4] = 0xcc; p_chars[117][5] = 0xcc;
  p_chars[117][6] = 0xcc; p_chars[117][7] = 0xcc; p_chars[117][8] = 0;
  p_chars[117][9] = 0; p_chars[117][10] = 0;

  /* v */
  p_chars[118][0] = 0; p_chars[118][1] = 0; p_chars[118][2] = 0x10;
  p_chars[118][3] = 0x38; p_chars[118][4] = 0x6c; p_chars[118][5] = 0xc6;
  p_chars[118][6] = 0xc6; p_chars[118][7] = 0xc6; p_chars[118][8] = 0;
  p_chars[118][9] = 0; p_chars[118][10] = 0;

  /* w */
  p_chars[119][0] = 0; p_chars[119][1] = 0; p_chars[119][2] = 0x66;
  p_chars[119][3] = 0xff; p_chars[119][4] = 0xdb; p_chars[119][5] = 0xdb;
  p_chars[119][6] = 0xc3; p_chars[119][7] = 0xc3; p_chars[119][8] = 0;
  p_chars[119][9] = 0; p_chars[119][10] = 0;

  /* x */
  p_chars[120][0] = 0; p_chars[120][1] = 0; p_chars[120][2] = 0xc6;
  p_chars[120][3] = 0x6c; p_chars[120][4] = 0x38; p_chars[120][5] = 0x38;
  p_chars[120][6] = 0x6c; p_chars[120][7] = 0xc6; p_chars[120][8] = 0;
  p_chars[120][9] = 0; p_chars[120][10] = 0;

  /* y */
  p_chars[121][0] = 0x78; p_chars[121][1] = 0x0c; p_chars[121][2] = 0x06;
  p_chars[121][3] = 0x7e; p_chars[121][4] = 0xc6; p_chars[121][5] = 0xc6;
  p_chars[121][6] = 0xc6; p_chars[121][7] = 0xc6; p_chars[121][8] = 0;
  p_chars[121][9] = 0; p_chars[121][10] = 0;

  /* z */
  p_chars[122][0] = 0; p_chars[122][1] = 0; p_chars[122][2] = 0xfe;
  p_chars[122][3] = 0x66; p_chars[122][4] = 0x30; p_chars[122][5] = 0x18;
  p_chars[122][6] = 0xcc; p_chars[122][7] = 0xfe; p_chars[122][8] = 0;
  p_chars[122][9] = 0; p_chars[122][10] = 0;

}  /* load_array */




void make_file ()
{
  FILE *f;

  f = fopen ("PR_CHARS.DAT", "wb");
  fwrite (p_chars, 0xb00, 1, f);
}  /* p_load_chars */




main ()
{
  puts ("\n\nCreating character file - PR_CHARS.DAT ...\n\n");
  load_array ();
  make_file ();
  puts ("All done!\n\n");
}  /* main */
