/*	CALLER.c -  Routine to do Far Calls.

        Supports ISR article in Micro Cornucopia Magazine Issue #46
*/


#asm

codeseg	segment	para public 'code'

	public  _AX_,_BX_,_CX_,_DX_
	public  _AL_,_AH_,_BL_,_BH_,_CL_,_CH_,_DL_,_DH_
	public  _SI_,_DI_,_BP_
	public  _ESBX_, _DSDX_, _DXAX_, _BPSI_
	public  _DS_,_ES_
	public  _PC_,_IP_,_CS_
	public  _PSW_
	public  _STKPTR_,_SP_,_SS_

_ESBX_	label   dword
_BX_	label   word
_BL_	db      ?
_BH_	db      ?

_ES_	dw      ?

_CX_	label   word
_CL_	db      ?
_CH_	db      ?

_DXAX_	label   dword
_AX_	label   word
_AL_	db      ?
_AH_	db      ?

_DSDX_	label   dword
_DX_	label   word
_DL_	db      ?
_DH_	db      ?

_DS_	dw      ?

_DI_	dw      ?

_BPSI_	label   dword
_SI_	dw      ?
_BP_	dw      ?

_PC_	label   dword
_IP_	dw      ?
_CS_	dw      ?

_PSW_	dw      ?

_STKPTR_ label  dword
_SP_	dw      ?
_SS_	dw      ?

sav_ss	dw	?
sav_sp	dw	?

codeseg	ends

#endasm

#pragma vpindex caller
unsigned int far caller() /* returns CPU FLAGS */
{
#asm
	push	bx		;save the callers regs
	push	cx
	push	si
	push	di
	push	bp
	push	ds
	push	es

	mov	sav_ss, ss
	mov	sav_sp, sp

	mov	ds, _DS_
	mov	es, _ES_

	mov	ax, _AX_
	mov	bx, _BX_
	mov	cx, _CX_
	mov	dx, _DX_

	mov	si, _SI_
	mov	di, _DI_
	mov	bp, _BP_

	pushf			;in case we're faking an interrupt
	call	dword ptr _PC_

	mov	_AX_, ax
	mov	_BX_, bx
	mov	_CX_, cx
	mov	_DX_, dx

	mov	_SI_, si
	mov	_DI_, di
	mov	_BP_, bp
	mov	_DS_, ds
	mov	_ES_, es
	mov	_SP_, sp
	mov	_SS_, ss

	pushf
	pop	ax
	mov	_PSW_, ax

	mov	ss, sav_ss
	mov	sp, sav_sp

	pop	es
	pop	ds
	pop	bp
	pop	di
	pop	si
	pop	cx
	pop	bx
#endasm
}


