/*	ISRHT - isr handler template.

        Supports ISR article in Micro Cornucopia Magazine Issue #46
*/


#asm

dataseg	segment para public 'data'
	extrn	_Dorg_:byte

	public  _ISRHT_LENGTH_, _ISRHT_PTR_

_ISRHT_LENGTH_   dw (offset p2 - offset p1)
_ISRHT_PTR_      dw offset p1
	         dw seg p1

dataseg ends
 
	;This code gets moved later to a structure in RAM.
	;The correct SS and SP values, as well as the
	;address of the 'C function to call, are installed
	;at that time.

codeseg	segment para public 'code'

p1:
	public  isr_template
isr_template proc far	

		;flags
		;CS
		;IP
	push	bp		;save the callers registers
	push	si
	push	di
	push	ds
	push	dx
	push	ax
	push	cx
	push	es
	push	bx

	mov	ax, seg _Dorg_	;get the local data segment value
	mov	ds, ax
	mov	es, ax

	mov     ax, 0           ;push a pointer to the ISRH
	push    ax
	mov     ax, 0           ;(zeros will be replaced later)
	push    ax

	call    isr_template    ;(isr_template will also be replaced)

	pop     ax              ;restore the pointer that we pushed
	pop     ax

	pop	bx		;restore callers registers
	pop	es
	pop	cx
	pop	ax
	pop	dx
	pop	ds
	pop	di
	pop	si
	pop	bp
	jmp     isr_template    ;jump to previous handler

isr_template endp
	;
p2:

codeseg ends

#endasm
