;************************************************
;*  09/17/86  *  ROMCALLS.INC  *  Version 1.1   *
;************************************************

;--------- Equates ------------------------------
   CR		EQU 0DH
   LF		EQU 0AH
;------------------------------------------------

;--------- Macros -------------------------------
  ;--------- ROM BIOS calls -------------------
  rc_Video		equ 10h
    rc_SetMode		  equ 0
    rc_SetCursorSize	  equ 1
    rc_SetCursorPosition  equ 2
    rc_GetCursorPosition  equ 3
    rc_ScrollUp		  equ 6
    rc_WriteAttChar	  equ 9
    rc_TTYOut		  equ 14
  rc_Keyboard		equ 16h
    rc_GetKey		  equ 0
    rc_GetKeyStatus	  equ 1
    rc_GetShift		  equ 2
  rc_Serial		equ 14h
    rc_Initialize	  equ 0
    rc_Send		  equ 1
    rc_Receive		  equ 2
    rc_Status		  equ 3
  rc_Printer		equ 17h
    rc_PInitialize	  equ 1
    rc_PSend		  equ 0
    rc_PStatus		  equ 2
  rc_Timer		equ 1ah
    rc_GetTOD		  equ 0
    rc_SetTOD		  equ 1

RomCall	Macro i, f
	ifnb <f>
  mov	ah, rc_&f
	endif
  int	rc_&i
Endm
