IMPLEMENTATION MODULE RleDComp;

(*
   Michael S. Hunt   April 4, 1989
   released into the public domain

   Support code from Micro Cornucopia Magazine Issue #48

   Micro Cornucopia
   PO Box 223
   Bend, OR 97709

*)

IMPORT FileSystem;

TYPE	ShortCard = [0..255];

PROCEDURE RleCompBuff (src : ARRAY OF CHAR;
		      VAR dest : ARRAY OF CHAR;
                      repeatCode : CHAR;
		      srcSize : CARDINAL;
                      VAR destSize : CARDINAL);
VAR 	k, sPos, dPos : CARDINAL;
	repeatCount : ShortCard;
BEGIN
  repeatCount := 1;
  sPos := 0;
  dPos := 2;
  dest[0] := repeatCode;
  REPEAT
    sPos := sPos + 1;
    IF (sPos < srcSize) AND (src[sPos] = src[sPos+1] )
    				AND (ORD(repeatCount) < 255) THEN
      INC(repeatCount)
    ELSE
      IF repeatCount > 3 THEN
        dest[dPos] := repeatCode;
        dest[dPos+1] := src[sPos];
        dest[dPos+2] := CHR(repeatCount);
        INC(dPos,3);
        repeatCount := 1
      ELSE
        FOR k := 1 TO repeatCount DO
          dest[dPos+k-1] := src[sPos]
	END;  
        INC(dPos, repeatCount);
        repeatCount := 1
      END
    END
  UNTIL sPos = srcSize;
  destSize := dPos - 1
END RleCompBuff;

PROCEDURE RleDecompBuff (src : ARRAY OF CHAR;
			srcSize : CARDINAL;
			VAR dest : ARRAY OF CHAR);
VAR   dPos, sPos : CARDINAL;
      j : ShortCard;
BEGIN
  sPos := 2;
  dPos :=1;
  WHILE sPos <= srcSize DO
    IF src[sPos] = src[1] THEN
      FOR j := 1 TO ORD(src[sPos+2]) DO
        dest[dPos+j-1] := src[sPos+1]
      END;
      dPos := dPos + ORD(src[sPos+2]);
      INC(sPos, 3)
    ELSE
      dest[dPos] := src[sPos];
      INC(dPos);
      INC(sPos)
    END
  END
END RleDecompBuff;

PROCEDURE RleCompFile (VAR sFil, dFil : FileSystem.File; repeatCode : CHAR);
VAR   	k, repeatCount : ShortCard;
	curByte, repeatByte, nextByte : CHAR;
BEGIN
  repeatCount := 1;
  FileSystem.ReadBlock (sFil, curByte);
  IF sFil.count > 0 THEN
    FileSystem.WriteBlock (dFil, repeatCode);
    REPEAT
      FileSystem.ReadBlock (sFil, nextByte);
      IF (curByte = nextByte) AND (ORD(repeatCount) < 255)
                              AND (sFil.count = 1) THEN
        INC(repeatCount);
      ELSE
        IF repeatCount > 3 THEN
            FileSystem.WriteBlock(dFil, repeatCode);
            FileSystem.WriteBlock(dFil, curByte);
            FileSystem.WriteBlock(dFil, repeatCount);
            repeatCount := 1
        ELSE
          FOR k := 1 TO repeatCount DO
            FileSystem.WriteBlock(dFil, curByte)
          END;  
          repeatCount := 1
        END
      END;
      curByte := nextByte
    UNTIL sFil.count = 0
  END
END RleCompFile;

PROCEDURE RleDecompFile (VAR sFil, dFil: FileSystem.File);
VAR	repeatCount, i : ShortCard;
	repeatByte, repeatCode, curByte : CHAR;
BEGIN
  FileSystem.ReadBlock (sFil, repeatCode);
  IF sFil.count > 0 THEN
    FileSystem.ReadBlock (sFil, curByte);
    WHILE sFil.count > 0 DO
      IF curByte = repeatCode THEN
        FileSystem.ReadBlock (sFil, repeatByte);
        FileSystem.ReadBlock (sFil, repeatCount);
        FOR i := 1 TO repeatCount DO
          FileSystem.WriteBlock(dFil, repeatByte)
        END
      ELSE
        FileSystem.WriteBlock(dFil, curByte)
      END;
      FileSystem.ReadBlock(sFil, curByte);
    END
  END
END RleDecompFile;

BEGIN
END RleDComp.
