unit rledcomp;

(*
   Michael S. Hunt   April 4, 1989
   released into the public domain

   Support text from Micro Cornucopia Magazine Issue #48

   Micro Cornucopia
   PO Box 223
   Bend, OR 97709
*)

interface

procedure RleCompBuff (var src, dest;
                      repeatCode : byte;
                      srcSize : word;
                      var destSize : word);

procedure RleDecompBuff (var src, dest;
                        srcSize : word);

procedure RleCompFile (var sFil, dFil : file; repeatCode : byte);

procedure RleDecompFile (var sFil, dFil: file);

implementation

type  bytes = array [1..65535] of byte;

procedure RleCompBuff (var src, dest;
                      repeatCode : byte;
                      srcSize : word;
                      var destSize : word);
var   sPos, dPos : word;
      k, repeatCount : byte;
begin
  repeatCount := 1;
  sPos := 0;
  dPos := 2;
  bytes(dest)[1] := repeatCode;
  repeat
    sPos := sPos + 1;
    if (sPos < srcSize) AND (bytes(src)[sPos] = bytes(src)[sPos+1])
                        AND (repeatCount < 255) then
      repeatCount := repeatCount + 1
    else
      if repeatCount > 3 then
        begin
          bytes(dest)[dPos] := repeatCode;
          bytes(dest)[dPos+1] := bytes(src)[sPos];
          bytes(dest)[dPos+2] := repeatCount;
          dPos := dPos + 3;
          repeatCount := 1
        end
      else
        begin
          for k := 1 to repeatCount do
            bytes(dest)[dPos+k-1] := bytes(src)[sPos];
          dPos := dPos + repeatCount;
          repeatCount := 1
        end;
  until sPos = srcSize;
  destSize := dPos - 1
end; (* RleCompBuff *)

procedure RleDecompBuff (var src, dest;
                        srcSize : word);
var   dPos, sPos : word;
      j : byte;
begin
  sPos := 2;
  dPos :=1;
  while sPos <= srcSize do
    begin
      if bytes(src)[sPos] = bytes(src)[1] then
        begin
          for j := 1 to bytes(src)[sPos+2] do
            bytes(dest)[dPos+j-1] := bytes(src)[sPos+1];
          dPos := dPos + bytes(src)[sPos+2];
          sPos := sPos + 3
        end
      else
        begin
          bytes(dest)[dPos] := bytes(src)[sPos];
          dPos := dPos + 1;
          sPos := sPos + 1
        end
    end
end; (* RleDecompBuff *)

procedure RleCompFile (var sFil, dFil : file; repeatCode : byte);
var   bytesRead : word;
      k, repeatCount, curByte, repeatByte, nextByte : byte;
begin
  repeatCount := 1;
  BlockRead (sFil, curByte, 1, bytesRead);
  if bytesRead > 0 then
    BlockWrite (dFil, repeatCode, 1);
    repeat
      BlockRead (sFil, nextByte, 1, bytesRead);
      if (curByte = nextByte) AND (repeatCount < 255)
                              AND (bytesRead = 1) then
        repeatCount := repeatCount + 1
      else
        if repeatCount > 3 then
          begin
            BlockWrite(dFil, repeatCode, 1);
            BlockWrite(dFil, curByte, 1);
            BlockWrite(dFil, repeatCount, 1);
            repeatCount := 1
          end
        else
          begin
            for k := 1 to repeatCount do
              BlockWrite(dFil, curByte, 1);
            repeatCount := 1
          end;
      curByte := nextByte
    until bytesRead = 0
end; (* RleCompFile *)

procedure RleDecompFile (var sFil, dFil: file);
var   bytesRead : word;
      repeatByte, repeatcode, repeatCount, curByte, i : byte;
begin
  BlockRead (sFil, repeatCode, 1, bytesRead);
  if bytesRead > 0 then
    begin
      BlockRead (sFil, curByte, 1, bytesRead);
      while bytesread > 0 do
        begin
          if curByte = repeatCode then
            begin
              BlockRead (sFil, repeatByte, 1, bytesRead);
              BlockRead (sFil, repeatCount, 1, bytesRead);
              for i := 1 to repeatCount do
                BlockWrite(dFil, repeatByte, 1)
            end
          else
            BlockWrite(dFil, curByte, 1);
          BlockRead (sFil, curByte, 1, bytesRead);
        end
    end
end; (* RleDecompFile *)

begin
end.