{ Micro Cornucopia Magazine - Issue #49
  TidBits Figure 1 - Turbo Pascal objects }

unit my_io_handler;

interface

type

Prompt = string[80];

my_io_handler = object
  IOErr : boolean;
  IOCode: integer;
  constructor init;
  procedure report(Msg : Prompt); virtual;
  procedure IOCheck; virtual;
end;

implementation

uses
  DOS,
  Unit_win,
  Crt;

constructor my_io_handler.init;
begin {this is all we have to do: TP handles the work.}
end;

procedure my_io_handler.IOCheck;
begin
  IOCode := IOResult;
  IOErr := (IOCode <> 0);
  if IOErr then
    begin
     case IOCode of
       $02 : report('File not found');
       $03 : report('Path not found');
       $04 : report('File not open');
       $10 : report('Error in numeric format');
       $20 : report('Operation not allowed on logical device');
       $21 : report('Not allowed in direct mode');
       $22 : report('Assign to standard files not allowed');
       $90 : report('Record length mismatch');
       $91 : report('Seek beyond EOF');
       $99 : report('Unexpected EOF');
       $F0 : report('Disk write error');
       $F1 : report('Directory is full');
       $F2 : report('File size overflow');
       $F3 : report('Too many open files');
       $FF : report('File disappeared')
       else
         report('Unknown I/O error: ');
         write(IOCode:3);
    end {case}
  end {if}
end; {IOCheck}

procedure my_io_handler.report(Msg : Prompt);

var
   F : text;
   FileName, P : string;
   W1 : _WindowPtr;
   Window_status : boolean;
   C : char;

begin
  W1 := __MakeWin(3,5,74,18,22,20,Black,LightGray,
        _DLBORD_WIN,LightRed,Black);
  Window_status := __DispWin(W1);
  writeln(Msg);
  C := readkey;
  Window_status := __RemWin;
end;
