;** Micro Cornucopia Magazine - Issue #49
;** 86World Figure 2
;**
;**    mystuff.m - an example of a simple brief macro to
;**                add a couple key definitions to brief.
;**
;**    Laine Stump 6/10/89
;**

(macro _init
  (
    (autoload "wp" "reform") ;** tells brief where to find reform macro

    ;** first some simple redefinitions of existing commands
    (assign_to_key "<Ctrl-O>" "reform")    ;** reformat paragraph
    (assign_to_key "<Alt-D>"  "dos")       ;** escape to dos shell
    (assign_to_key "<Right>"  "next_char") ;** go to next char in buffer
    (assign_to_key "<Left>"   "prev_char") ;** go to prev char in buffer

    ;** now define a key to call our own new macro
    (assign_to_key "<Alt-Z>"  "zoom_window")

  )
)


(extern display_file_name)

(macro zoom_window   ;** zoom the current window to fill the screen
  (
    (int lines cols zbuffer)

    (inq_screen_size lines cols)      ;** see how big we can get
    (= zbuffer (inq_buffer))          ;** this is what is in the window
    (create_window 0 (- lines 3) (- cols 2) 0
                   "ZOOM MODE (alt+Z for WINDOW MODE)")
    (set_buffer    zbuffer)           ;make the window and attach current
    (attach_buffer zbuffer)           ; buffer
    (refresh)                         ;update the display
    (assign_to_key "<Alt-Z>" "exit")  ;provide a sure way out
    (display_file_name)
    (process)                         ;recursively call brief
    (delete_window)                   ;remove the zoom window
    (set_buffer    zbuffer)           ;reattach original window
    (attach_buffer zbuffer)           ;in case we switched
    (display_file_name)
    (assign_to_key "<Alt-Z>" "zoom_window")
  )
)   ;** end of zoom_window

