/* DISPLAY.H : declarations for functions to support graphic screen
   display of voice patterns.
   Bruce Eckel, Revolution2 Real-Time Consulting.
*/
#include <graphics.h>  /* The Turbo C BGI header file */

/* "printf"-like function for printing messages while
using the BGI in graphics mode. */
void gprintf(char * format, ...);

/* Display the graphics "viewport" values (for debugging) */
void display_viewsettings(struct viewporttype view);

/* Types of scaling for display_series: */
typedef enum { quarter, half, full, twice, quad } scale_factor;

/* Display a series of numbers as dots on the screen: */
void display_series(unsigned * series, int series_size,
	int offset,
	scale_factor vertical_scale_factor,
	scale_factor horizontal_scale_factor,
	int color);
