/*  This code supports an article in issue #51 of:

    Micro Cornucopia Magazine
    P.O. Box 223
    Bend, OR 97709
*/
/*
    Header:     ZG_LwLvl    (ZipGraph Low-Level functions)
    Version     1.00        22-Oct-1989

    Language:   ANSI C w/MS-DOS extensions
    Environ:    IBM-PC compatibles w/MDA, CGA, HGC, EGA, MCGA, or VGA

    Compilers:  Borland Turbo C v2.00
                Lattice C v6.01
                Microsoft C v5.10 and QuickC v2.01
                Zortech C & C++ v2.01

    Purpose:    Provides low-level graphics routines for detecting graphics
                adapters, setting graphics modes, and plotting pixels. This
                module is required by the higher-level ZipGraph modules.

    Written by: Scott Robert Ladd
                705 West Virginia
                Gunnison CO 81230

                MCI:     srl
                FidoNet: 1:104/708
*/

#if !defined(__ZG_LWLVL_H)
#define __ZG_LWLVL_H 1

#if defined(__cplusplus)
    extern "C" {
#endif

/*---------------------
  ZipGraph CONSTANTS!
---------------------*/

#define ZG_ERROR   0xFF

#define ZG_VID_MDA  0
#define ZG_VID_CGA  1
#define ZG_VID_HGC  2
#define ZG_VID_EGA  3
#define ZG_VID_MCGA 4
#define ZG_VID_VGA  5

#define ZG_MTR_MONO  0
#define ZG_MTR_COLOR 1

#define ZG_MOD_720x348x1    0
#define ZG_MOD_320x200x4    1
#define ZG_MOD_640x200x2    2
#define ZG_MOD_320x200x16   3
#define ZG_MOD_640x200x16   4
#define ZG_MOD_640x350x2    5
#define ZG_MOD_640x350x16   6
#define ZG_MOD_640x480x2    7
#define ZG_MOD_640x480x16   8
#define ZG_MOD_320x200x256  9

#define ZG_MOD_BESTRES    0x80
#define ZG_MOD_MOSTCOLOR  0x81

#define ZG_PXL_SET  0
#define ZG_PXL_AND  1
#define ZG_PXL_OR   2
#define ZG_PXL_XOR  3

/*---------------------------
  ZipGraph PUBLIC VARIABLES
---------------------------*/

#if !defined(__ZG_LWLVL_C)
extern struct
    {
    int     Type;
    int     Monitor;
    int     Mode;

    int     Xwidth;
    int     Ylength;
    int     NoColors;
    }
    ZG_VideoInfo;
#endif

extern void (* ZG_PlotPixel)(int x, int y, int color, int mode);
extern int  (* ZG_ReadPixel)(int x, int y);

/*---------------------
  ZipGraph PROTOTYPES
---------------------*/

int ZG_Init(void);
int ZG_SetMode(int VideoMode);
int ZG_Done(void);

int ZG_SetCGAPalette(char PaletteNo);
int ZG_SetEVGAPalette(char Palette, char Color);

#if defined(__cplusplus)
    }
#endif

#endif
