UNIT MufGlobs;

INTERFACE

USES
   Dos, Crt;

(*----------------------------------------------------------------------*)
(*                   GLOBAL VARIABLE DEFINITIONS                        *)
(*----------------------------------------------------------------------*)

CONST
                   (* 8086/8088 hardware flags *)

   Carry_Flag     = 1;
   Parity_Flag    = 4;
   Aux_Carry_Flag = 16;
   Zero_Flag      = 64;
   Sign_Flag      = 128;

TYPE

   AnyStr    = STRING[255]  (* Matches any string for parameter passing *);

   StringPtr = ^AnyStr      (* Points to a string                       *);

   ShortStr  = STRING[30]   (* Short string *);

   String1   = STRING[1]    (* 1-character string  *);

   String10  = STRING[10]   (* 10-character string *);

   String12  = STRING[12]   (* 12-character string *);

   FileStr   = STRING[65]   (* File name string *);

   String80  = STRING[80]   (* 80-character string *);

   Text_File = TEXT         (* General text file                 *);

                                   (* Comparison types for string tests *)

   Comparer       = ( Less, Equal, Greater );

                                   (* Character set definitions *)
   CharSet        = SET OF CHAR;

(*----------------------------------------------------------------------*)
(*               ASCII character set definitions                        *)
(*----------------------------------------------------------------------*)

CONST

   NUL  = 0          (* NULL            *);
   ETX  = 3          (* ETX = ^C        *);
   ENQ  = 5          (* ENQ = Enquiry   *);
   BELL = 7          (* BELL = bell     *);
   BS   = 8          (* Backspace       *);
   HT   = 9          (* Horizontal Tab  *);
   LF   = 10         (* Line Feed       *);
   VT   = 11         (* Vertical Tab    *);
   FF   = 12         (* Form Feed       *);
   CR   = 13         (* Carriage Return *);
   SO   = 14         (* Start grahics   *);
   SI   = 15         (* End graphics    *);
   DLE  = 16         (* Data link esc.  *);
   XON  = 17         (* XON             *);
   XOFF = 19         (* XOFF            *);
   SUB  = 26         (* End of file     *);
   ESC  = 27         (* Escape          *);
   FS   = 28         (* Graphics start  *);
   GS   = 29         (* Graphics start  *);
   RS   = 30         (* Inc. plot start *);
   US   = 31         (* Graphics end    *);
   SP   = 32         (* Space           *);
   DEL  = 127        (* Delete          *);



(*----------------------------------------------------------------------*)
(*                Timing constants and variables                        *)
(*----------------------------------------------------------------------*)

TYPE
   Date_Format_Type = ( MDY_Style, YMD_Style, DMY_Style );
   Time_Format_Type = ( Military_Time, AMPM_Time        );

CONST
   Half_Second_Delay       =  500  (* Delay argument for 1/2 sec. delay *);
   One_Second_Delay        = 1000  (* Delay argument for 1 second delay *);
   Two_Second_Delay        = 2000  (* Delay argument for 2 second delay *);
   Three_Second_Delay      = 3000  (* Delay argument for 3 second delay *);
   Tenth_of_a_second_Delay = 100   (* 1/10 second delay                 *);

(* VAR *) CONST
   Delay_Time            : INTEGER (* Time to delay in response to DELAY *)
                                   (* command                            *)
                           = 0;

   Current_Status_Time   : INTEGER (* Current time for status line       *)
                           = 0;

   New_Status_Time       : INTEGER (* Updated time for status line       *)
                           = 0;

   Time_Format           : Time_Format_Type (* Time format               *)
                           = Military_Time;

   Date_Format           : Date_Format_Type (* Date format               *)
                           = YMD_Style;

   Date_Format_String    : STRING[10]       (* Date format in string form*)
                           = 'YY/MM/DD';

   Use_Military          : BOOLEAN (* TRUE to use 24 hour time           *)
                           = TRUE;

   Window_Hold_Time      : INTEGER (* Time to wait when clearing window  *)
                           = 10;


(*----------------------------------------------------------------------*)
(*                      Program Option Flags                            *)
(*----------------------------------------------------------------------*)

CONST
   ON   = TRUE                       (* Convenient synonym for switches *);
   OFF  = FALSE                      (* Likewise                        *);

(* VAR *) CONST
   Reset_Comm_Port     : BOOLEAN   (* TRUE to reset comm port           *)
                         = TRUE;
   Comm_Port_Changed   : BOOLEAN   (* TRUE if comm port number changed  *)
                         = TRUE;
   Write_Screen_Memory : BOOLEAN   (* TRUE to write video memory direct *)
                         = FALSE;
   Write_Screen_Memory_Par : BOOLEAN (* TRUE to write video direct -- param *)
                         = FALSE;
   Alter_Baud_Rate     : BOOLEAN   (* TRUE to get baud rate from modem  *)
                         = TRUE;
   Check_CTS           : BOOLEAN   (* TRUE to check clear-to-send line  *)
                         = TRUE;
   Check_DSR           : BOOLEAN   (* TRUE to check data-set-ready line *)
                         = FALSE;
   Hard_Wired          : BOOLEAN   (* TRUE if hard-wired connection     *)
                         = FALSE;
   Drop_Dtr_At_End     : BOOLEAN   (* TRUE to drop DTR when closing port*)
                         = FALSE;
   Close_Comm_For_Dos  : BOOLEAN   (* TRUE to drop DTR when Alt-J done  *)
                         = TRUE;
   Wait_For_Retrace    : BOOLEAN   (* TRUE to wait for retrace in DSW   *)
                         = TRUE;
   Wait_For_Retrace_Par: BOOLEAN   (* TRUE to wait for retrace -- param *)
                         = TRUE;
   Current_Carrier_Status : BOOLEAN (* Has current carrier detect status*)
                            = FALSE;
   New_Carrier_Status     : BOOLEAN (* Has new carrier detect status    *)
                            = FALSE;
   Carrier_Dropped        : BOOLEAN (* TRUE if carrier dropped          *)
                            = FALSE;
   Video_Handler_Installed: BOOLEAN (* TRUE if new int $10 handler inst.*)
                            = FALSE;


(*----------------------------------------------------------------------*)
(*               Global communications variables                        *)
(*----------------------------------------------------------------------*)

(* VAR *) CONST
   Data_Bits     : 5..8 = 8;
   Parity        : CHAR = 'N';
   Stop_Bits     : 0..2 = 1;
   Comm_Port     : 1..4 = 1;
   Baud_Rate     : 110..38400 = 2400;
   Cmd_Line_Port : 0..4 = 0;

(* STRUCTURED *) CONST
   N_Baud_Rates = 11;

   Baud_Rates: ARRAY[ 1 .. N_Baud_Rates ] OF WORD
               = ( 110, 150, 300, 600, 1200, 2400, 4800, 9600, 19200,
                   38400, 57600 );


(*----------------------------------------------------------------------*)
(*                                                                      *)
(*                  COMMUNICATIONS HARDWARE ADDRESSES                   *)
(*                                                                      *)
(*        These are specific to IBM PCs and close compatibles.          *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

CONST

   UART_THR = $00;       (* offset from base of UART Registers for IBM PC *)
   UART_RBR = $00;
   UART_IER = $01;
   UART_IIR = $02;
   UART_LCR = $03;
   UART_MCR = $04;
   UART_LSR = $05;
   UART_MSR = $06;

   I8088_IMR = $21;      (* port address of the Interrupt Mask Register *)

   COM1_Base = $03F8;    (* port addresses for the UART *)
   COM2_Base = $02F8;
   COM3_Base = $03E8;
   COM4_Base = $02E8;

   COM1_Irq = 4;         (* Interrupt line for the UART *)
   COM2_Irq = 3;
   COM3_Irq = 4;
   COM4_Irq = 3;

   COM1_Int = $0C;       (* Interrupt number for the UART *)
   COM2_Int = $0B;
   COM3_Int = $0C;
   COM4_Int = $0B;

   RS232_Base = $0400    (* Address of RS 232 com port pointer *);

   MaxComPorts = 4       (* Four ports allowed by this code    *);

(* STRUCTURED *) CONST
                                   (* Port addresses of each com port *)

   Default_Com_Base : ARRAY[1..MaxComPorts] OF WORD =
                      ( COM1_Base, COM2_Base, COM3_Base, COM4_Base );

                                   (* IRQ line for each port *)

   Default_Com_Irq  : ARRAY[1..MaxComPorts] OF INTEGER =
                      ( COM1_Irq, COM2_Irq, COM3_Irq, COM4_Irq );

                                   (* Interrupt for each port *)

   Default_Com_Int  : ARRAY[1..MaxComPorts] OF INTEGER =
                      ( COM1_Int, COM2_Int, COM3_Int, COM4_Int );

(*----------------------------------------------------------------------*)
(*                                                                      *)
(*                   COMMUNICATIONS BUFFER VARIABLES                    *)
(*                                                                      *)
(*     The communications buffers are implemented as circular (ring)    *)
(*     buffers, or double-ended queues.  The asynchronous I/O routines  *)
(*     enter characters in the receive buffer as they arrive at the     *)
(*     serial port.  Higher-level routines may extract characters from  *)
(*     the receive buffer at leisure.  Higher-level routines insert     *)
(*     characters into the send buffer.  The asynchronous I/O routines  *)
(*     then send characters out the serial port when possible.          *)
(*                                                                      *)
(*----------------------------------------------------------------------*)

CONST

   TimeOut             = 256        (* TimeOut value                   *);
   Async_XON           = ^Q         (* XON character                   *);
   Async_XOFF          = ^S         (* XOFF character                  *);

   Async_Overrun_Error = 2          (*   overrun                       *);
   Async_Parity_Error  = 4          (*   parity error                  *);
   Async_Framing_Error = 8          (*   framing error                 *);
   Async_Break_Found   = 16         (*   break interrupt               *);

   Async_CTS           = $10        (*   Clear to send                 *);
   Async_RTS           = $20        (*   Request to send               *);

   Async_DSR           = $20        (*   Data set ready                *);
   Async_DTR           = $10        (*   Data terminal ready           *);

   Async_RTSDTR        = $30        (*   RTS + DTR                     *);
   
TYPE
                                    (* I/O buffer type for serial port *)

   Async_Buffer_Type   = ARRAY[0..1] OF CHAR;
   Async_Ptr           = ^Async_Buffer_Type;


VAR                                 (* Port addresses for serial ports *)

   Com_Base               : ARRAY[1..MaxComPorts] OF WORD;

                                    (* IRQ line for each serial port   *)

   Com_Irq                : ARRAY[1..MaxComPorts] OF INTEGER;

                                    (* Interrupt for each serial port   *)

   Com_Int                : ARRAY[1..MaxComPorts] OF INTEGER;

VAR
   Async_Buffer_Ptr       : Async_Ptr  (* Input buffer address  *);
   Async_OBuffer_Ptr      : Async_Ptr  (* Output buffer address *);

   Async_Open_Flag        : BOOLEAN    (* true if port opened               *);
   Async_Port             : INTEGER    (* current open port number (1 -- 4) *);
   Async_Base             : INTEGER    (* base for current open port        *);
   Async_Irq              : INTEGER    (* IRQ for current open port         *);
   Async_Int              : INTEGER    (* Interrupt # for current port      *);
   Async_RS232            : INTEGER    (* RS232 address for current port    *);

   Async_Buffer_Overflow  : BOOLEAN    (* True if buffer overflow has happened *);
   Async_Buffer_Used      : INTEGER    (* Amount of input buffer used so far   *);
   Async_MaxBufferUsed    : INTEGER    (* Maximum amount of input buffer used  *);

                                       (* Async_Buffer empty if Head = Tail    *)
   Async_Buffer_Head      : INTEGER    (* Loc in Async_Buffer to put next char *);
   Async_Buffer_Tail      : INTEGER    (* Loc in Async_Buffer to get next char *);
   Async_Buffer_NewTail   : INTEGER    (* For updating tail value              *);

   Async_OBuffer_Overflow : BOOLEAN    (* True if buffer overflow has happened *);
   Async_OBuffer_Used     : INTEGER    (* Amount of output buffer used         *);
   Async_MaxOBufferUsed   : INTEGER    (* Max amount of output buffer used     *);

                                       (* Async_Buffer empty if Head = Tail    *)
   Async_OBuffer_Head     : INTEGER    (* Loc in Async_Buffer to put next char *);
   Async_OBuffer_Tail     : INTEGER    (* Loc in Async_Buffer to get next char *);
   Async_OBuffer_NewTail  : INTEGER    (* For updating tail value              *);

   Async_Buffer_Low       : INTEGER    (* Low point in receive buffer for XON  *);
   Async_Buffer_High      : INTEGER    (* High point in receive buffer for XOFF*);
   Async_Buffer_High_2    : INTEGER    (* Emergency point for XOFF             *);

   Async_XOFF_Sent        : BOOLEAN    (* If XOFF sent                      *);
   Async_Sender_On        : BOOLEAN    (* If sender is enabled              *);
   Async_Send_XOFF        : BOOLEAN    (* TRUE to send XOFF ASAP            *);
   Async_XOFF_Received    : BOOLEAN    (* If XOFF received                  *);
   Async_XOFF_Rec_Display : BOOLEAN    (* If XOFF received and displayed    *);
   Async_XON_Rec_Display  : BOOLEAN    (* If XON received                   *);
   Async_Baud_Rate        : WORD       (* Current baud rate                 *);

                                    (* Save previous serial interrupt status *)
   Async_Save_IAddr       : POINTER;
   Async_Do_CTS           : BOOLEAN (* TRUE to do clear-to-send checking    *);
   Async_Do_DSR           : BOOLEAN (* TRUE to do data-set-ready checking   *);
   Async_Do_XonXoff       : BOOLEAN (* TRUE to do XON/XOFF flow checking    *);
   Async_OV_XonXoff       : BOOLEAN (* TRUE to do XON/XOFF if buffer overfl *);
   Async_Hard_Wired_On    : BOOLEAN (* TRUE if hard-wired connection        *);
   Async_Break_Length     : INTEGER (* Length of break in 1/10 seconds      *);
   Async_Line_Status      : BYTE    (* Line Status Reg at interrupt         *);
   Async_Modem_Status     : BYTE    (* Modem Status Reg at interrupt        *);
   Async_Line_Error_Flags : BYTE    (* Line status bits accumulated         *);
   Async_Buffer_Size      : INTEGER (* Stores input buffer size             *);
   Async_OBuffer_Size     : INTEGER (* Stores output buffer size            *);
   Async_Uart_IER         : INTEGER (* Interrupt enable register address    *);
   Async_Uart_MCR         : INTEGER (* Interrupt enable register address    *);
   Async_Uart_IIR         : INTEGER (* Interrupt ID register address        *);
   Async_Uart_MSR         : INTEGER (* Modem status register address        *);
   Async_Uart_LSR         : INTEGER (* Line status register address         *);
   Async_Output_Delay     : INTEGER (* Delay in ms when output buffer full  *);
   Async_OneMSDelay       : INTEGER (* Loop count value to effect 1 ms delay*);
   Async_Buffer_Length    : INTEGER (* Receive buffer length                *);
   Async_OBuffer_Length   : INTEGER (* Send buffer length                   *);
                                    (* Pointer to Async_Send routine        *)
   Async_Send_Addr        : Async_Ptr;

(*----------------------------------------------------------------------*)
(*          Definitions for screen memory reading/writing               *)
(*----------------------------------------------------------------------*)

CONST
   EGA_Screen_Address      = $A000    (* Address of EGA color screen      *);
   Color_Screen_Address    = $B800    (* Address of color screen          *);
   Mono_Screen_Address     = $B000    (* Address of mono screen           *);
   Screen_Length           = 4000     (* 80 x 25 x 2 = screen area length *);
   Graphics_Screen_Length  = 16000    (* Length of graphics screen area   *);
   EGA_Graphics_Scr_Length = 28000    (* Length of EGA graphics screen    *);
   Max_Saved_Screen        = 6        (* Maximum no. of saved screens     *);
   MedRes_GraphMode        = 4        (* Medium resolution graphics       *);
   HiRes_GraphMode         = 6        (* High resolution graphics mode    *);
   Mono_TextMode           = 7        (* Monochrome adapter text mode     *);
   EGA_GraphMode           = 16       (* EGA adapter graphics mode        *);
   CRT_Index               = $03D4    (* CRT index register               *);
   CRT_Data                = $03D5    (* CRT data register                *);
   CRT_Mode                = $03D8    (* CRT mode register                *);
   CRT_Color_Select        = $03D9    (* CRT color select register        *);
   CRT_Status              = $03DA    (* CRT status port                  *);
   CRT_Mode_Byte           = $0465    (* CRT mode byte                    *);

TYPE
                                     (* A screen image            *)

   Screen_Type       = ARRAY[ 1 .. EGA_Graphics_Scr_Length ] OF BYTE;

   Screen_Ptr        = ^Screen_Image_Type;

   Screen_Image_Type = RECORD
                          Screen_Image: Screen_Type;
                       END;

                                              (* Screen stack entries      *)
   Saved_Screen_Ptr  = ^Saved_Screen_Type;

   Saved_Screen_Type = RECORD
                          Screen_Row    : INTEGER;
                          Screen_Column : INTEGER;
                          Screen_X1     : INTEGER;
                          Screen_Y1     : INTEGER;
                          Screen_X2     : INTEGER;
                          Screen_Y2     : INTEGER;
                          Window_X1     : INTEGER;
                          Window_Y1     : INTEGER;
                          Window_X2     : INTEGER;
                          Window_Y2     : INTEGER;
                          Screen_Size   : WORD;
                          Video_Mode    : INTEGER;
                          If_BIOS       : BOOLEAN;
                          Screen_Image  : Screen_Type;
                       END;

CONST
   Video_Interrupt  = $10          (* Video interrupt number     *);

CONST                              (* Save previous video interrupt status. *)

   Video_Save_Iaddr  : Pointer = Nil;

   Video_Request     : INTEGER = 0     (* Current video request *);
   Video_Fill        : INTEGER = 0     (* Fill attribute        *);
   Video_Page        : BYTE    = 0     (* Text memory page      *);
   Video_Mode        : BYTE    = 3     (* Current text mode     *);
   Video_Screen_Addr : WORD    = $B800 (* Screen memory address *);

(* VAR *) CONST
   Max_Screen_Col       : INTEGER             (* PC's screen width         *)
                          = 80;

   Wrap_Screen_Col      : INTEGER             (* Column at which to wrap   *)
                          = 80;

   Max_Screen_Line      : INTEGER             (* PC's screen length        *)
                          = 25;

   New_Max_Screen_Col   : INTEGER             (* Width for param settings  *)
                          = 80;

   New_Max_Screen_Line  : INTEGER             (* Length for param settings *)
                          = 25;

   Font8x8Loaded        : BOOLEAN             (* TRUE if 8x8 font loaded   *)
                          = FALSE;

   Really_Save_EGA      : BOOLEAN             (* TRUE to save EGA memory   *)
                          = TRUE;

(* VAR *) CONST
                                              (* Memory-mapped screen area *)
   Actual_Screen        : Screen_Ptr = NIL;
                                              (* Saves screen behind menus *)

   Saved_Screen         : Saved_Screen_Ptr = NIL;

                                              (* Stack of saved screens    *)

   Saved_Screen_List    : ARRAY[ 1 .. Max_Saved_Screen ] OF Saved_Screen_Ptr
                          = ( NIL, NIL, NIL, NIL, NIL, NIL );

                                              (* Depth of saved screen stack *)
   Current_Saved_Screen : 0 .. Max_Saved_Screen = 0;

                                   (* Upper left corner of      *)
                                   (* current TURBO window      *)
(* VAR *) CONST
   Upper_Left_Column  : INTEGER = 1;
   Upper_Left_Row     : INTEGER = 1;

                                   (* Lower right corner of     *)
                                   (* current TURBO window      *)
(* VAR *) CONST
   Lower_Right_Column  : INTEGER = 80;
   Lower_Right_Row     : INTEGER = 25;

(* VAR *) CONST
   Global_ForeGround_Color : INTEGER = White;
   Global_BackGround_Color : INTEGER = Black;
   Global_Border_Color     : INTEGER = Black;
   Global_Text_Attribute   : INTEGER = White;

(*----------------------------------------------------------------------*)
(*                       Multitasker definitions                        *)
(*----------------------------------------------------------------------*)

TYPE
   MultiTaskerType     = ( MultiTasker_None, DoubleDos, DesqView, TopView,
                           MSWindows, APXCore, EZDosIt, Concurrent_DOS,
                           TaskView, MultiLink, Other );

VAR
   TimeSharingActive   : BOOLEAN   (* TRUE if multitasker active        *);

                                   (* Which multitasker active          *)
   MultiTasker         : MultiTaskerType;

   DesqView_Screen     : Screen_Ptr (* Alternate display buffer address *);
   Graphics_Screen     : Screen_Ptr (* Graphics display buffer address  *);
   

IMPLEMENTATION

END   (* GlobType *).
