;-----------------------------------------------------------------------
; File:    RPT_SCAN.RS - Robocomm 4.x script file
;.......................................................................
; Author:  Dan Parsons
; Version: 1.1
; Revised: 05/27/92
;
; Notes:   You MUST have the renumbering style on Robocomm's
;          "Data and Logs" configuration screen set to "#???????.???"
;          in order to use this script!!!
;
; v 1.1    Modified to check for a file list in the first
;          QWK packet downloaded.
;
;----------------------------------------------------------------------
TITLE "Repeat QWK Scan in Qmail 4.0 Door (READ ME!)"
ENDPARAMS

    ; You may want to set a custom timeout value.
    ; If so, uncomment the next line and edit it to suit your taste.
    ; TIMEOUT 360

    ; Go to mail door and get it set up for extended prompts.
    VENUE MAIL
    SEND "PROMPTS ON|"

    WAITFOR "<COMMAND>"
    SEND "D|"
    WHEN "<COMMAND>" GOTO END
    WAITFOR "<DLASK>"
    SEND "Y|"
    WAITFOR "<DOWNLOAD>"
    GOSUB GETQWK
    GOSUB GETLIST

    ; Repeat #1
    WHEN "<COMMAND>" GOTO END
    WAITFOR "<DOWNLOAD>"
    GOSUB GETQWK

    ; Repeat #2
    WAITFOR "<DOWNLOAD>"
    GOSUB GETQWK

    ; Repeat #3
    WAITFOR "<DOWNLOAD>"
    GOSUB GETQWK

    ; Repeat #4
    WAITFOR "<DOWNLOAD>"
    GOSUB GETQWK

    ; Repeat #5
    WAITFOR "<DOWNLOAD>"
    GOSUB GETQWK

    ; Repeat #6
    WAITFOR "<DOWNLOAD>"
    GOSUB GETQWK

    ; Repeat #7
    WAITFOR "<DOWNLOAD>"
    GOSUB GETQWK

    ; Repeat #8
    WAITFOR "<DOWNLOAD>"
    GOSUB GETQWK

    ; If we got this far, there's no way to stop, so just hang up.
    HANGUP

EXIT 0

:GETQWK
    ; We force up to nine packets, because that's how many this script may end
    ; up downloading.
    RENUMBER "%QWKDIR%%ID%.QWK" 9
    ; Macro 22 is the mail door download protocol.
    DOWNLOAD "%QWKDIR%%ID%.QWK" USING "%BBS22%"
RETURN

:GETLIST
    ERASE "NEWFILES.DAT"
    RUN "PKUNZIP %QWKDIR%%ID%.QWK NEWFILES.DAT"
    IF EXIST "newfiles.dat" RUN "TYPE NEWFILES.DAT >> NEWLIST.DAT"
    IF EXIST "newfiles.dat" MESSAGE "Extracted file list from QWK."
    IF NOT EXIST "newfiles.dat" MESSAGE "No file list found in QWK."
    ERASE "NEWFILES.DAT"
RETURN

:END
    MESSAGE "No more messages to download"
EXIT 0

