Short explanation of ZUtil's features and how to use 'em
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

1. License
~~~~~~~~~~

ZUtil is Freeware, this means, anybody can use it at no charge.
Patching the code is allowed only for private use.
Distributing ZUtil in other forms than it is bundled by me is
not allowed. The archive, named ZUTIL_F2.* should contain :
It is not allowed to let anybody pay for ZUtil more than
the price for the disk that contains it.

ZUTIL.EXE (the program itself)
ZUTIL.MAN (german documentation)
ZUTIL_E.MAN (this file)
ABR1.BAT (a sample automatic answering machine with modem/fax detection)
FOSSY.COM (a program to terminate FrontDoor with an errorlevel when a
           RING comes in)
FOSSY.ASM (Assembler Source of FOSSY.COM)


2. Requirements to run ZUtil.Exe
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

An IBM PC or compatible (a system with 286 or faster may be the minimum to
                         record and play voice files)
A Hard Disk drive. In some cases maybe it will work to play voice files
                   from floppy disks, but I didn't test this out.
A Fossil Driver (e.g. BNU or X00), not locked at speeds below 38400 bps
A ZyXEL U1496 series modem with Firmware version 5.00 or newer


3. Main Functions & general errorlevels returned by ZUtil
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

A short overview over ZUtil's functions can be printed on the screen
by calling the program ZUtil.Exe without any command line parameters.

To execute any of the following functions, the syntax is

ZUTIL <function name> [options] [filename] [strings]

<function name> has to be the first argument. It could be
abbreviated by using only the first letter ('P' for 'PLAY' etc.)
[options] must begin with '-' or '/'.
The first string without a leading '-' or '/' is recognized as
the filename when using RECORD or PLAY.
[strings] and [options] may be mixed.
In [strings], the pipe character may be used as a replacement
for <cr> (ASCII 13). Used in a string that should be awaited from
the modem, it is used as a replacement for <cr> and for <lf> (ASCII 10).

BTW: You can stop almost every action by pressing <esc> or <ctrl-c>
on your keyboard. Press 'q' to force 'Quiet detected' immediately,
's' to force 'Silence detected', 'c' to make ZUtil think it has
detected a Fax calling tone, or '0'...'9','*','#' to simulate the
reception of the corresponding DTMF codes.

All the functions return errorlevels as follows:
255 - (PLAY or RECORD) couldn't open the specified file, or it doesn't
      contain PLAYable ZyXEL voice data.
254 - general serial I/O fault. In most cases, this means there is
      no Fossil driver available at the moment.
253 - didn't get any answer from the modem (e.g. an OK after some command)
252 - (RECORD) could not write to file. (e.g. 'cause the disk is full)
251 - (PLAY or RECORD) Fax-Calling Tone detected. You can disable this
      by using the /I command line option.
250 - action stopped by operator. The operator (you!) pressed <esc> or
      <ctrl-c>. In bad cases, the modem may be in an undefined state after
      this. You should issue an SEND 'ATZ|' or HANGUP after this.
249 - (RECORD) Silence detected. This means, the caller was quiet during
      from the beginning of the recording for <TimeOut> 1/10 seconds (see below)
248 - (RECORD) Quiet detected. This means, the caller said something
      at the beginning of the recording and then became quiet. He kept
      quiet for <TimeOut> 1/10 seconds.
      The <TimeOut> and the sensitivity level for silence detection could
      be configured by using SEND "AT+VSD=<Level>,<TimeOut>|".
      <Level>=0 means Silence Detection is disabled, <Level>=31 is the
      possible maximum. What <Level> you have to use, differs from
      country to country and from ZyXEL to ZyXEL. It's even different
      when using different Sample Modes.
      Sample: ZUTIL SEND "AT+VSD=20,30|" "OK"


3.1 AWAIT
~~~~~~~~~
Waits for a string from the modem. You can specify up to three strings
which should be recognized.
This functions returns 0, if none of the specified strings is recognized
within the time specified by the option /T.
Otherwise the count of the string is returned (1 if the first string matched,
2 if the second matched, 3 if the third one matched)

Sample : ZUTIL AWAIT /P1 "RING" /T30
Waits for the string "RING" from the modem in COM2, max. 30 seconds

Note : This function clears the 'received characters' buffer at startup,
       so its use is somewhat limited. Characters may be lost.


3.2 SEND
~~~~~~~~
Sends a string to the modem, then waits for strings from the modem.
Here, you can specify up to ten strings which should be recognized.
Returns errorlevel as function AWAIT.

Sample : ZUTIL SEND "ATA|" "CONNECT|" "CONNECT 1200" "CONNECT 2400" "CONNECT FAX" "NO CARRIER" /T60
Sends the hayes command ATA to the modem in COM1, and waits for CONNECT message
or NO CARRIER message from the modem within 60 seconds.

Sample batch file errorlevel operation after the above sample function call :

IF ERRORLEVEL 6 GOTO Error
IF ERRORLEVEL 5 GOTO No_Connect
IF ERRORLEVEL 4 GOTO Receive_Fax
IF ERRORLEVEL 3 GOTO BBS_call_at_2400
IF ERRORLEVEL 2 GOTO BBS_call_at_1200
IF ERRORLEVEL 1 GOTO BBS_call_at_300
GOTO Error
[...]


3.3 WATCH
~~~~~~~~~
Like AWAIT, but waits for a configurable count of 'RING|'s from the modem.
You could specify the max time using the /T parameter.
The count of RINGs to wait for is given by the /R parameter.
If at least one RING is received and the caller hung up (10 sec no RING)
after that, this function is also terminated. You could check the
number of incoming RINGs by testing the errorlevel.

Sample: ZUTIL WATCH /R3 /T3600
Waits 1 hour for telephone ringing. If someone dials in, but hangs up
after 1 or two rings, the returned errorlevel is 1 resp. 2.
Otherwise it returns 3 (three RINGs received) or 0 (no call).
You could use this to implement a feature like
'one RING, pause, one RING' -> Mailbox call
'three RING's -> Voice call


3.4 HANGUP
~~~~~~~~~~
This normally just does, what the name says... it will
terminate an existing connection or voice call by simply
making the ZyXEL go On-Hook.


3.5 PLAY
~~~~~~~~
Plays a recorded ZyXEL voice file from disk. The errorlevel
generation after PLAY or RECORD is quite difficult to understand:
In addition to the errorlevels described at the beginning of
this section, you could specify if DTMF tone codes should be
recognized.
If you specify /M1, the playback of the voice file is stopped
if the caller sends a DTMF signal. The program then returns
10-19 for DTMF codes '0'-'9',
20 for DTMF code '#', 21 for DTMF code '*'.
If you specify /M2 or greater, the program will return
10 + 12 * <first digit> + <second digit>, where
<digit> = 0...9 for DTMF codes '0' to '9',
<digit> = 10 for DTMF code '#' and <digit> = 11 for DTMF code '*'.
Anyway, all received codes are printed in the last line of the
program screen output, so you could read this line with an utility
program like AWK and allow action control by DTMF sequences > 2 digits
in your batch files. 'Quiet', 'Silence' and 'Fax CNG' are listed
also in the last line by the characters 'q', 's', 'c'.

Sample: ZUTIL PLAY D:\VOICE\HELLO.ZYX /P1 /M0 /I
This will play the file HELLO.ZYX on a ZyXEL in COM2, with
detection of Fax calling tone and DTMF tones fully disabled.


3.6 RECORD
~~~~~~~~~~
Record voice to a ZyXEL voice file (disk).
If one or more DTMF tone(s) is/are detected, the errorlevel is
generated as described above (3.5).
There are two or three modes available to record files :
/S1 - CELP : this mode is only availabe on the ZyXEL plus models.
             It allows good quality recording at a data rate of
             1200 cps, so one minute of voice would take 70k on your disk.
/S2 - 2-bit ADPCM : available on all ZyXEL models, data rate is
             2400 cps. Quality is poor, so use this only on slow
             computers or systems with no ZyXEL plus und less disk space.
/S3 - 3-bit ADPCM : available on all ZyXEL models, data rate is
             3600 cps, so one minute of voice would take 210k on your disk.
             It offers the best playback quality. You wouldn't be able
             to distinguish between a human talker and a ZyXEL modem... :)
If you want to record more than one messages over a day or more, you can
give PATH\* or PATH\*.EXT as the file name. * would be replaced by
'ZUTILxyz.ZVD', *.EXT would be replaced by 'ZUTILxyz.EXT', where xyz
is the number of the file (001, 002, 003, ...).

4. Command Line Options
~~~~~~~~~~~~~~~~~~~~~~~

4.1 /Dx, /Fy, /Gz (beep tone generating)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

If you specify /Dx, /Dx and /Fy or /Dx and /Fy and /Gz on the command line,
before PLAYing or RECORDing a voice file a beep tone will be generated.
x specifies the duration of that beep (1/10 seconds, range 1 to 255)
y specifies the main frequency of that beep (Hz, range 200 - 3300 Hz)
z specifies a second frequency of that beep (-"-)

Sample: ZUTIL RECORD C:\DFUE\* /S1 /T30 /D1 /F380
Record a file named ZUTILxyz.ZVD in CELP mode, maximum recording
length is 30 seconds, play an 1/10 second 380 Hz beep before recording.
Default is /D0 (no beep tone), /F600 and /G600.


4.2 /I (ignore Fax calling tone)
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/I disables the generation of the errorlevel 251 (Fax CNG detected).
Nevertheless, a 'c' is printed in the last line of the screen output
if a Fax CNG has been detected.

4.3 /L (local mode)
~~~~~~~~~~~~~~~~~~~
If you specify /L on the command line, recording is done from a
connected microphone, playing is done to the modem's internal speaker.
If you don't specify /L, RECORD and PLAY will take the modem Off-Hook
and record/generate the TelCo line signal.

4.4 /K (delete recorded file if 'silence detected')
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
In RECORD mode, if the modem detects silence, no output file will
be written.

4.5 /Mx (max. DTMF codes)
~~~~~~~~~~~~~~~~~~~~~~~~~
Specify x=0 to 63 as the count of DTMF codes, that will be received
before the program exits. Default is /M1

4.6 /Px (serial port)
~~~~~~~~~~~~~~~~~~~~~
Use x=0 for COM1, x=1 for COM2, ...
You can use any port that your Fossil driver is configured for.
Default is /P0.

4.7 /Rx (RING count)
~~~~~~~~~~~~~~~~~~~~
Specify /R1 for stop after 1 RING, /R2 for stop after 2 RINGs etc.

4.8 /Sx (sampling mode)
~~~~~~~~~~~~~~~~~~~~~~~
x=1 for CELP, 2 for 2-bit ADPCM, 3 for 3-bit ADPCM. See 3.6 for
details about the modes. Default is /S2.

4.9 /Tx (time limit)
~~~~~~~~~~~~~~~~~~~~
x=1 to 32767 seconds. This parameter is used to limit the recording
time or to specify the time the program should wait for a RING or
other modem messages. Default is /T30.


5.0 FOSSY.COM
~~~~~~~~~~~~~

Fossy.Com is a little TSR utility for use with FrontDoor 2.xx and other
programs that use the Fossil Driver.
It has to be loaded by calling FOSSY _after_ the fossil driver.
You can remove it by simply calling it a second time.

The function is to simulate a press of function key 'F3' whenever
the PC sends "ZUTIL"+<cr> to the modem.

You can use this to exit FrontDoor whenever a RING comes in, by
configuring "Modem>Answer control>Force answer: ZUTSR|" and
assigning a specific action to function key F3 under
"Mailer>Function Keys>F3".

I wrote this to allow points or FrontDoor users in general to
use FrontDoor as a Time/Event Manager. However, EMSI connects,
mail polls, file requests etc. are not possible, because
the control over the modem is immediately transferred to
an external program. If you want Voice/Data with FrontDoor
and your ZyXEL modem, you have to use ZuTSR, another program
by the author.


Apropos:

6. the Author
~~~~~~~~~~~~~

 Kolja Waschk,
 Oevelgoenne 23,
(up to the end of june'93 :)
 W-2000 Hamburg 52, Germany
(from 1st july'93 :)
 22605 Hamburg, Germany

 Phone 49-40-8804056
 FidoNet : 2:241/2101.27 until my node 2:241/2114 appears in the nodelist...
 UseNet : koljawk@zerebrm.isnet.sub.org

I hope I didn't miss anything while translating my german docs into
english docs and you understand quite everything...
Have fun !













