/*
 * WMF Import Filter - ADD METAFILE BITS
 *
 * LANGUAGE      : Microsoft C6.0
 * MODEL         : medium
 * ENVIRONMENT   : Microsoft Windows 3.0 SDK
 * STATUS        : operational
 *
 * This module contains functions to validate a WMF file and to add the
 * metafile bits from the file to the memory metafile being constructed
 * by the filter to return to the calling application.
 *
 *    Eikon Systems, Inc.
 *    989 East Hillsdale Blvd, Suite 260
 *    Foster City, California 94404
 *    415-349-4664
 *
 * 08/01/91 1.00 - David E. West - initial creation.
 * 09/01/91 1.01 - Kevin P. Welch - minor revisions.
 *
 */

#define NOCOMM

#include <windows.h>
#include <limits.h>
#include <stdio.h>
#include <dos.h>
#include "wmf.h"

/**/

/*
 * ValidateWMF( lpwmf ) : BOOL;
 *
 *    lpwmf           pointer to WMF header
 *
 * This function checks the already open file with the handle hfSrc to see
 * if it is a valid WMF file.
 *
 * The return value is TRUE if the file is a valid WMF file, and FALSE
 * otherwise.
 *
 */

BOOL FAR PASCAL ValidateWMF(
	LPWMFHEADER		lpwmf )
{
	BOOL				fValid;
	WORD				idChecksum;

	/* calculate checksum */
	idChecksum = ComputeWMFChecksum( lpwmf );
	fValid = (lpwmf->idChecksum == idChecksum);

	return fValid;
}

/**/

/*
 * ComputeWMFChecksum( lpwmf ) : WORD
 *
 *    lpwmf          pointer to metafile header
 *
 * This function computes the checksum for the given metafile header,
 * which is an Aldus disk metafile header.  The checksum is the result
 * of XORing the first 10 words in the file.
 *
 */

WORD FAR PASCAL ComputeWMFChecksum(
	LPWMFHEADER		lpwmf )
{
	LPWORD			lp;
	LPWORD			lpChecksum;
	WORD				idChecksum;

	/* initialize checksum */
	idChecksum = 0;

	/* calculate checksume */
	lpChecksum = (LPWORD)&(lpwmf->idChecksum);
	for (lp = (LPWORD)lpwmf; FP_OFF(lp) < FP_OFF(lpChecksum); ++lp)
		idChecksum ^= *lp;

	return idChecksum;
}

/**/

/*
 * GetWMFBits( lphbMF, cbMF, hfSrc ) : WORD;
 *
 *    lphbMF         pointer to handle for metafile bits
 *    cbMF           size of metafile bits
 *    hfSrc          handle to file
 *
 * This function reads the metafile bits from the file hfSrc beginning at
 * the current file position.  A memory block with size cbMF is allocated,
 * and then the bytes are read from the file into this memory block.  The
 * handle to the memory block is returned in *lphbMF.
 *
 * The return value is an IE_* Aldus-defined error code, or SUCCESS if there
 * is no error.
 *
 */

WORD FAR PASCAL GetWMFBits(
	LPHANDLE			lphbMF,
	LONG				cbMF,
	INT				hfSrc )
{
	WORD				idErr;
	HANDLE			hbMF;	
	LPSTR				lpbMF;

	/* initialize return value */
	idErr = SUCCESS;

	/* allocate memory for metafile bits */
	hbMF = GlobalAlloc( GHND, cbMF );
	lpbMF = hbMF ? GlobalLock(hbMF) : NULL;
	if (lpbMF)
	{
		/* read bits */
		if (cbMF < USHRT_MAX - 1)
		{
			/* read memory block in one read */
			_lread( hfSrc, lpbMF, (WORD)cbMF );
		}
		else
		{
			/* read memory block in several reads */
			hread( hfSrc, (HPSTR)lpbMF, cbMF );
		}

		/* unlock memory block & assign return handle */
		GlobalUnlock( hbMF );
		*lphbMF = hbMF;

	}
	else
		idErr = IE_MEM_FULL;

	return idErr;
}
