// mfchello.cpp RHS 1/5/92

#include<AFXWIN.H>
#include"mfchello.h"

#define IDM_ABOUT   100

class HelloWindow : public CFrameWnd    // main window derived from CFrameWnd
    {
public:
    HelloWindow();              // class constructor
    afx_msg void OnPaint();     // declare message handling functions
    afx_msg void OnAbout();
    DECLARE_MESSAGE_MAP()       // declare message map
    };

HelloWindow::HelloWindow()      // constructor for HelloWindow
    {
    LoadAccelTable("MainAccelTable");
    Create(NULL, "MFCHello", WS_OVERLAPPEDWINDOW, rectDefault, 
        NULL, "MainMenu");
    }

void HelloWindow::OnPaint()     // WM_PAINT handling
    {
    CPaintDC dc(this);
    dc.SetTextAlign(TA_BASELINE | TA_CENTER);
    dc.SetBkMode(TRANSPARENT);

    CRect rect;
    GetClientRect(rect);

    CString s = "Hello Windows, from MFC!";
    dc.TextOut((rect.right/2), (rect.bottom/2), s, s.GetLength());
    }

void HelloWindow::OnAbout()     // WM_COMMAND with wParam==IDM_ABOUT handling
    {
    CModalDialog about("AboutBox", this);
    about.DoModal();
    }

BEGIN_MESSAGE_MAP(HelloWindow, CFrameWnd) // message map definition
    ON_WM_PAINT()
    ON_COMMAND(IDM_ABOUT, OnAbout)
END_MESSAGE_MAP()

class MFCHello : public CWinApp // main application class derived from CWinApp
    {
public:
    BOOL InitInstance();        // declare InitInstance member function
    };

BOOL MFCHello::InitInstance()   // define InitInstance member function
    {
    m_pMainWnd = new HelloWindow();
    m_pMainWnd->ShowWindow(m_nCmdShow);
    m_pMainWnd->UpdateWindow();
    return TRUE;
    }

MFCHello myApp;                 // instantiate the application class,
                                // and start the program
