;
; LIBENTRY.ASM
;
; Windows DLL entry code
;
; LibEntry resides in the _INIT code segment, initializes the DLL's
; local heap, then calls the C LibMain function that should have the
; form:
; BOOL FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg,
;                         WORD   cbHeap,    LPSTR lpszCmdLine);
;
; LibEntry returns the result of LibMain back to Windows.  If this
; value is non-zero, initialization continues.  Otherwise the DLL
; is unloaded from memory and loading fails.
;

include cmacros.inc

createSeg  _INIT, _INIT, BYTE, PUBLIC, CODE
sBegin     _INIT
assumes CS,_INIT

?PLM=0                       ;C naming
externA  <_acrtused>         ;Insures linking Windows DLL startup code

?PLM=1                       ;PASCAL naming
externFP <LocalInit>         ;Kernel's local heap initialization function
externFP <LibMain>           ;The C initialization function



cProc   LibEntry, <PUBLIC,FAR>

cBegin
    push    di               ;Handle of the module instance
    push    ds               ;Library data segment
    push    cx               ;Heap size
    push    es               ;Command line segment
    push    si               ;Command line offset

    ;
    ; Initialize a heap if one was created for this DLL.
    ;
    jcxz    LECallLibMain    ;CX==0 if there is no heap

    ;
    ; Call the Windows function LocalInit() to set up the heap
    ; LocalInit((LPSTR)start, WORD cbHeap);
    ;
    xor     ax,ax
    cCall   LocalInit <ds, ax, cx>
    or      ax,ax            ;Success?
    jz      LEError          ;Quit if LocalInit failed

    ;
    ; Call the C initialization function.
    ;

LECallLibMain:
    call    LibMain
    jmp     short LEExit     ;LibMain is responsible for stack clean up

LEError:
    pop     si               ;Clean up stack on a LocalInit error
    pop     es
    pop     cx
    pop     ds
    pop     di

LEExit:

cEnd

sEnd    _INIT

    end     LibEntry
