/****************************************************************************
Module name: BurnIt.C
Programmer : Jeffrey M. Richter.
Description: Drop File Client Sample Application.
*****************************************************************************/

#include <windows.h>
#include <mmsystem.h>
#include <shellapi.h>

extern HINSTANCE _cdecl _hInstance;

//****************** PROTOTYPES FOR LOCAL FUNCTIONS *************************/
LRESULT FAR BurnItWndProc (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);


//************************ GLOBAL VARIABLES *********************************/
char _szAppName[] = "BurnIt";

#define BURNICONS     2
#define FLAREICONS    3
#define MAX_ICONS     (BURNICONS + FLAREICONS)

#define ICON_First   100

HICON hIconList[MAX_ICONS];
int _nIconNum;        // Index into hIcons of last displaed icon
BOOL _fFlaring = FALSE;

#pragma argsused
int WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow) {
   MSG msg;
   HWND hWnd;
   WNDCLASS wc;

   if (hPrevInstance != NULL) {
      // If instance of BurnIt is already running, bring it to top and
      // terminate this instance
      BringWindowToTop(FindWindow(_szAppName, _szAppName));
      return(0);
   }

   wc.style = 0;
   wc.lpfnWndProc = (WNDPROC) BurnItWndProc;
   wc.cbClsExtra = wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hIcon = NULL;
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = NULL;
   wc.lpszMenuName = NULL;
   wc.lpszClassName = _szAppName;
   if (!RegisterClass(&wc)) return(0);

   // Create the Frame window.
   hWnd = CreateWindowEx(WS_EX_ACCEPTFILES, _szAppName, _szAppName,
                         WS_OVERLAPPED | WS_VISIBLE |
                         WS_CAPTION | WS_SYSMENU,
                         CW_USEDEFAULT, SW_MINIMIZE,
                         CW_USEDEFAULT, CW_USEDEFAULT,
                         NULL, NULL, hInstance, NULL);
   if (hWnd == NULL) return(0);

   while (GetMessage(&msg, NULL, 0, 0))
      {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
      }

   return(msg.wParam);
}


LRESULT FAR BurnItWndProc (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
   BOOL fCallOrigProc = FALSE;
   LRESULT lResult = 0;
   WORD wFilesDropped, wSize;
   NPSTR npszPathName;
   OFSTRUCT of;
   HDC hDC;
   WORD x;

   switch (Msg) {

      case WM_CREATE:
         SetWindowPos(hWnd, HWND_TOPMOST,
            0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
         SetTimer(hWnd, 1, 250, NULL);
         for (x = 0; x < MAX_ICONS; x++)
             {
             hIconList[x] = LoadIcon(_hInstance,
                                     MAKEINTRESOURCE(ICON_First + x));
             }
         break;

      case WM_DESTROY:
         KillTimer(hWnd, 1);
         PostQuitMessage(0);
         break;

      case WM_QUERYOPEN:
         // Don't allow this app to be opened. It only runs as an icon.
         lResult = FALSE;
         break;

      case WM_TIMER:
         x = _nIconNum + 1;
         x = x % (int) (_fFlaring ? MAX_ICONS : BURNICONS);
         if (x == 0)
            _fFlaring = 0; // Reset to burning only
         _nIconNum = x;

         hDC = GetDC(hWnd);
         SendMessage(hWnd, WM_ERASEBKGND, hDC, 0);
         DrawIcon(hDC, 0, 0, hIconList[x]);
         ReleaseDC(hWnd, hDC);
         break;

      case WM_DROPFILES:
         _fFlaring = TRUE; // Stoke the fire!
         sndPlaySound("Siren.Wav", SND_ASYNC);

         // Get the number of pathnames that are being dropped on us
         wFilesDropped = DragQueryFile((HDROP) wParam, -1, NULL, 0);

         while (wFilesDropped-- > 0)
            {
            // Get the length of the the pathname
            wSize = DragQueryFile((HDROP) wParam, wFilesDropped, NULL, 0) + 1;

            // Allocate a block of memory large enough for the pathname
            npszPathName = (NPSTR) LocalAlloc(LMEM_FIXED, wSize);
            if (npszPathName == NULL) continue; // Insufficient memory

            // Copy the pathname into our local buffer
            DragQueryFile((HDROP) wParam, wFilesDropped, npszPathName, wSize);

            // Delete this file
            OpenFile(npszPathName, &of, OF_DELETE);

            LocalFree((HLOCAL) npszPathName);
            }

         // Free the memory block containing the pathnames
         DragFinish((HDROP) wParam);
         break;

      default:
         fCallOrigProc = TRUE;
         break;
   }
   if (fCallOrigProc)
      lResult = DefWindowProc(hWnd, Msg, wParam, lParam);

   return(lResult);
}
