/*-------------------------------------------------------------*\
 |  INIT.C  -- Initialization for TaskMstr.EXE.                |
\*-------------------------------------------------------------*/
#include <Windows.H>
#include <WindowsX.H>
#include <ToolHelp.H>
#include <Memory.H>
#include "TaskMstr.H"


/*-------------------------------------------------------------*\
 |                      Global Variables.                      |
\*-------------------------------------------------------------*/
extern APPCOLORS    ac;
extern APPMETRICS   am;
extern char       * achSegType[];
extern HBRUSH       hbr1;
extern HBRUSH       hbr2;
extern HFONT        hfont;

/*-------------------------------------------------------------*\
 |  trInitMetrics:  Initialize application specific metrics.   |
\*-------------------------------------------------------------*/
void FAR PASCAL trInitMetrics(HDC hdc)
    {
    DWORD       dwSize;
    int         cb;
    int         cxWidth;
    LOGFONT     lf;
    TEXTMETRIC  tm;

    // Set up application metric info.
    //
    GetTextMetrics (hdc, &tm);

    hfont = GetStockObject (SYSTEM_FONT);
    GetObject (hfont, sizeof (LOGFONT), &lf);
    lf.lfHeight         = MulDiv (lf.lfHeight, 7, 8);
    lf.lfWidth          = 0;
    lf.lfWeight         = 700;
    lf.lfQuality        = DEFAULT_QUALITY;
    lf.lfPitchAndFamily = VARIABLE_PITCH | FF_SWISS;
    lf.lfFaceName[0]    = '\0';
    hfont = CreateFontIndirect (&lf);

    SelectObject (hdc, hfont);

    am.sm_cxBorder = GetSystemMetrics (SM_CXBORDER);
    am.sm_cyBorder = GetSystemMetrics (SM_CYBORDER);
    am.tx_cyLine   = tm.tmHeight +
                     tm.tmExternalLeading +
                     tm.tmInternalLeading;

    am.tx_xMargin  = tm.tmAveCharWidth / 2;
    am.tx_yMargin  = tm.tmExternalLeading;

    am.lbTask_cyHeight   = am.tx_cyLine * 4;     // 4 lines in listbox
    am.lbModule_cyHeight = am.tx_cyLine +
                           am.tx_cyLine / 2;     // 1.5 lines in listbox

    am.bar_cyHeight = am.tx_cyLine + am.tx_cyLine / 2;

    am.xIcon = am.tx_xMargin + tm.tmAveCharWidth * 4;;
    am.yIcon = ( (am.lbTask_cyHeight+am.tx_cyLine) / 2) -
               ( GetSystemMetrics (SM_CYICON)  / 2);

    am.tx_xIconMargin = am.xIcon + tm.tmAveCharWidth * 2 +
                        GetSystemMetrics (SM_CXICON);

    // Get width of longest 'task list' char string.
    cb = lstrlen(achSegType[GT_UNKNOWN]);
    dwSize = GetTextExtent (hdc, achSegType[GT_UNKNOWN], cb);
    cxWidth = LOWORD (dwSize);

    // Create right-alignment offsets for task list.
    am.tx_xTaskText = am.tx_xIconMargin + cxWidth;
    am.tx_yTaskText = am.tx_cyLine + am.tx_yMargin;

    // Get width of longest 'module list' char string.
    cb = lstrlen (achSegType[GT_BURGERMASTER]);
    dwSize = GetTextExtent (hdc, achSegType[GT_BURGERMASTER], cb);
    cxWidth = LOWORD (dwSize);

    // Create right-alignment offsets for module list.
    am.tx_xModuleText = cxWidth;
    am.tx_yModuleText = am.lbModule_cyHeight / 2 +
                        tm.tmHeight / 4;

    // Calculate minimum tracking size for the main window.
    am.win_xMinTracking = 2 * GetSystemMetrics (SM_CXFRAME)   +
                          2 * GetSystemMetrics (SM_CYVSCROLL) +
                          2 * am.tx_xTaskText                 +
                              MulDiv (am.tx_xModuleText, 3, 2);
    am.win_yMinTracking = 2 * GetSystemMetrics (SM_CYFRAME)   +
                              GetSystemMetrics (SM_CYCAPTION) +
                              am.lbTask_cyHeight - 1;

    am.win_cxInit       = am.win_xMinTracking;
    am.win_cyInit       = 2 * GetSystemMetrics (SM_CYFRAME)   +
                              GetSystemMetrics (SM_CYCAPTION) +
                          SEGTYPE_COUNT * am.lbModule_cyHeight - 1;
    }


/*-------------------------------------------------------------*\
 |    trInitColors:  Initialize table of application colors.   |
\*-------------------------------------------------------------*/
void FAR PASCAL trInitColors()
    {
    int iColor;

    // Set up color independent values.
    ac.rgbForeSelect = GetSysColor (COLOR_HIGHLIGHTTEXT);
    ac.rgbBackSelect = GetSysColor (COLOR_HIGHLIGHT);
    ac.rgbBlack      = RGB (0, 0, 0);

    // Set up for monochrome devices.
    //
    if (ac.cColors == 2)
        {
        for (iColor = 0; iColor < 10; iColor++)
            {
            ac.rgbSolidColors[iColor] = ac.rgbBlack;
            }
        hbr1 = CreateHatchBrush (HS_DIAGCROSS, RGB (0, 0, 0));
        hbr2 = CreateHatchBrush (HS_FDIAGONAL, RGB (0, 0, 0));
        }
    else   // Color devices.
           //
        {
        ac.rgbSolidColors[GT_UNKNOWN ] = RGB (255,   0,   0);
        ac.rgbSolidColors[GT_DGROUP  ] = RGB (  0,   0, 255);
        ac.rgbSolidColors[GT_DATA    ] = RGB (  0,   0,   0);
        ac.rgbSolidColors[GT_CODE    ] = RGB (  0, 128,   0);
        ac.rgbSolidColors[GT_TASK    ] = RGB (128,   0,   0);
        ac.rgbSolidColors[GT_RESOURCE] = RGB (  0,   0, 128);
        ac.rgbSolidColors[GT_MODULE  ] = RGB (128, 128, 128);

        hbr1 = CreateSolidBrush (ac.rgbSolidColors[GT_UNKNOWN]);
        hbr2 = CreateSolidBrush (ac.rgbSolidColors[GT_DGROUP]);
        }
    }
