/*-------------------------------------------------------------*\
 |  LISTS.C  --  Builds module, task & segment lists for use   |
 |               by Task Master.                               |
\*-------------------------------------------------------------*/
#include <Windows.H>
#include <WindowsX.H>
#include <ToolHelp.H>
#include <Memory.H>
#include "TaskMstr.H"


/*-------------------------------------------------------------*\
 |                      Global Variables.                      |
\*-------------------------------------------------------------*/
extern HWND                hwndMain;
extern GLOBALENTRY _huge * lpheList;
extern int                 cSegments;
extern int                 cTaskList;
extern LPTASKLIST          lptlList;


/*-------------------------------------------------------------*\
 |          trBuildSegmentList:  Rebuild Segment List.         |
\*-------------------------------------------------------------*/
void FAR PASCAL trBuildSegmentList()
    {
    BOOL                bOk;
    GLOBALENTRY _huge * lpheTemp;
    GLOBALENTRY         globalentry;
    GLOBALINFO          gi;
    WORD                err;
    WORD                retry;
    WORD                wcItems;

    // Init error code.
    err = ERR_OK;

    // Query system about number of segments.
    //
    gi.dwSize = sizeof (GLOBALINFO);
    bOk = GlobalInfo (&gi);

    if (!bOk)
        {
        err = ERR_GLOBALINFO;
        goto Exit;
        }

    // Adjust buffer for segment info.
    //
    wcItems = GlobalSizePtr (lpheList) / sizeof(GLOBALENTRY);
    for (retry = RETRY_SEGALLOC; retry > 0; retry--)
        {
        lpheTemp = (GLOBALENTRY FAR *)GlobalReAllocPtr (lpheList,
                    (SEG_EXTRA + gi.wcItems) * sizeof(GLOBALENTRY),
                     0);

        if (!lpheTemp)
            {
            err = ERR_OUTOFMEMORY;
            goto Exit;
            }
        lpheList = lpheTemp;

        // Check whether count of items has changed on global heap.
        //
        wcItems = gi.wcItems;
        GlobalInfo (&gi);
        if (wcItems > gi.wcItems)
            break;
        }

    cSegments = wcItems;

    // Loop through heap, querying segment info.
    //
    globalentry.dwSize = sizeof (GLOBALENTRY);
    GlobalFirst (&globalentry, GLOBAL_ALL);
    _fmemcpy (lpheTemp, &globalentry, sizeof(GLOBALENTRY));
    wcItems--;

    for (;wcItems > 0; wcItems--)
        {
        if (GlobalNext (&globalentry, GLOBAL_ALL))
            {
            lpheTemp++;
            _fmemcpy (lpheTemp, &globalentry, sizeof(GLOBALENTRY));
            }
        else
            {
            cSegments -= wcItems;
            break;
            }
        }

Exit:
    if (err != ERR_OK)
        {
        PostMessage (hwndMain, AM_ERROR, err, 0);
        }
    }


/*-------------------------------------------------------------*\
 |             trBuildTaskList:  Build Task List.              |
\*-------------------------------------------------------------*/
void FAR PASCAL trBuildTaskList()
    {
    TASKENTRY  teTemp;
    LPTASKLIST lptlTemp;
    int        cTasks;

    if (!lptlList)
        {
        lptlList = (LPTASKLIST)GlobalAllocPtr (GMEM_MOVEABLE,
                                               sizeof(TASKLIST) );
        }

    // Count number of tasks in the system.
    //
    cTasks = GetNumTasks();  // Returns invalid value.
    cTaskList = cTasks;

    lptlTemp = (LPTASKLIST)GlobalReAllocPtr (lptlList,
                                             cTasks * sizeof(TASKLIST), 0);
    if (!lptlTemp)
        {
        SendMessage (hwndMain, AM_ERROR, ERR_TASKLIST, 0);
        lptlList = (TASKENTRY FAR *)0;
        return;
        }
    lptlList = lptlTemp;

    // Fetch list of tasks.
    //
    teTemp.dwSize = sizeof (TASKENTRY);
    TaskFirst (&teTemp);
    _fmemcpy (&lptlTemp->taskentry, &teTemp, sizeof (TASKENTRY));
    cTasks--;

    for ( ;cTasks > 0; cTasks--)
        {
        TaskNext(&teTemp);
        lptlTemp++;
        _fmemcpy (&lptlTemp->taskentry, &teTemp, sizeof (TASKENTRY));
        }
    }
