/*-------------------------------------------------------------*\
 |  TASKMSTR.H:  Include file for TASKMSTR.EXE.                |
\*-------------------------------------------------------------*/

//  Application metric values.
//
typedef struct tagAPPMETRICS
    {
    int sm_cxBorder;        // System metric values.
    int sm_cyBorder;
    int tx_cyLine;          // Text metric values.
    int tx_xMargin;
    int tx_yMargin;
    int tx_xIconMargin;
    int tx_xTaskText;       // (x, y) origin for task bar...
    int tx_yTaskText;       // ...graph titles.
    int tx_xModuleText;     // (x, y) origin for module bar...
    int tx_yModuleText;     // ...graph titles.
    int win_xMinTracking;   // Minimum window tracking size.
    int win_yMinTracking;
    int win_cxInit;         // Initial window size.
    int win_cyInit;
    int bar_cyHeight;
    int lbTask_cyHeight;    // Task listbox item height.
    int lbModule_cyHeight;  // Module listbox item height;
    int xIcon;              // Icon placement info.
    int yIcon;
    }  APPMETRICS;

//  Application color values.
//
typedef struct tagAPPCOLORS
    {
    int   cColors;
    DWORD rgbForeSelect;
    DWORD rgbBackSelect;
    DWORD rgbBlack;
    DWORD rgbSolidColors[10];
    }  APPCOLORS;

//  Application constants.
//
#define BUFSIZE 256
#define SEG_INIT_COUNT 200


//  Error handling defines.
//
#define STR_ERRBASE     (100)
#define ERR_OK            (0)
#define ERR_MISSING      ( 1)
#define ERR_OUTOFMEMORY  ( 2)
#define ERR_GLOBALINFO   ( 3)
#define ERR_MODULELIST   ( 4)
#define ERR_TASKLIST     ( 5)


//  Application-specific messages.
//
#define AM_ERROR            (WM_USER + 1)
#define AM_BUILDTASKLIST    (WM_USER + 2)

//  Task List information.
#define WINTEXTLEN 64

typedef struct tagTASKLIST
    {
    TASKENTRY taskentry;
    DWORD     dwDGroup;
    DWORD     dwGlobal;
    char      achWindowText[WINTEXTLEN + 1];
    HICON     hIcon;
    } TASKLIST;

typedef TASKLIST FAR * LPTASKLIST;


// Retry for matching segment buffer size to
// actual count of segments in system.
//
#define RETRY_SEGALLOC 3
#define SEG_EXTRA      2   //  Extra space for segment shifting.


// Create windowsx.h type of macro
#define GlobalSizePtr(lp) \
        (GlobalSize((GlobalPtrHandle(lp))))


// Control IDs for listboxes.
#define IDL_TASK      (1)
#define IDL_MODULE    (2)

#define SEGTYPE_COUNT (7)  //  Count of segment types.

/*-------------------------------------------------------------*\
 |                    Function Prototypes.                     |
\*-------------------------------------------------------------*/
long FAR  PASCAL TaskMstrWndProc (HWND, UINT, WPARAM, LPARAM);
void FAR  PASCAL trBuildSegmentList (void);
void FAR  PASCAL trBuildTaskList(void);
void NEAR PASCAL trCalcTaskList(void);
void NEAR PASCAL trCalcSegmentList(void);
void NEAR PASCAL trFillTaskListbox(HWND hwndTask);
void NEAR PASCAL trFillSegmentListbox(void);
void FAR  PASCAL trInitMetrics(HDC hdc);
void FAR  PASCAL trInitColors(void);
BOOL FAR  PASCAL _export trToolHelpNotify (WORD wID, DWORD dwData);
VOID NEAR PASCAL trDrawTaskItems (const DRAWITEMSTRUCT FAR*  lpdraw);
VOID NEAR PASCAL trDrawModuleItems (const DRAWITEMSTRUCT FAR*  lpdraw);

VOID NEAR PASCAL trMain_OnCommand(HWND hwnd, int id, HWND hwndCtl,
                                  UINT codeNotify);
BOOL NEAR PASCAL trMain_OnCreate(HWND hwnd,
                                 CREATESTRUCT FAR* lpCreateStruct);
VOID NEAR PASCAL trMain_OnDestroy (HWND hwnd);
VOID NEAR PASCAL trMain_OnDrawItem(HWND hwnd,
                                   const DRAWITEMSTRUCT FAR* lpDrawItem);

VOID NEAR PASCAL trMain_GetMinMaxInfo(HWND hwnd,
                                      MINMAXINFO FAR* lpMinMaxInfo);
VOID NEAR PASCAL trMain_MeasureItem(HWND hwnd,
                                    MEASUREITEMSTRUCT FAR* lpMeasureItem);
VOID NEAR PASCAL trMain_Size(HWND hwnd, UINT state, int cx, int cy);
VOID NEAR PASCAL trMain_SetFocus(HWND hwnd, HWND hwndOldFocus);
VOID NEAR PASCAL trMain_Timer(HWND hwnd, UINT id);
VOID NEAR PASCAL trMain_BuildTaskList(void);
VOID NEAR PASCAL trMain_Error(HWND hwnd, WORD error);
