main:
        push    WORD PTR [b + 2]        // b variable on stack
        push    WORD PTR [b + 0]
        push    WORD PTR [c + 2]        // c variable on stack
        push    WORD PTR [c + 0]
        call    __aNlmul                // call 32-bit multiply function
        mov     WORD PTR [a + 0], ax    // save result
        mov     WORD PTR [a + 2], dx

        xor     ax, ax                  // return
        ret

__aNlmul:
        push    bp                      // prologue
        mov     bp,sp
        mov     ax, [bp + 06]           // high word, operand 1
        mov     cx, [bp + 10]           // high word, operand 2
        or      cx, ax                  // check if both are zero
        mov     cx, [bp + 08]           // low word, operand 2
        jnz     nonzero                 // jump if non-zero high words
        mov     ax, [bp + 04]           // low word, operand 1
        mul     cx                      // multiply low words
        pop     bp                      // epilogue
        ret     0x0008                  // return

nonzero:
        push    bx                      // save BX register
        mul     cx                      // low word 2 times high word 1
        mov     bx, ax                  // save result in BX
        mov     ax, [bp + 04]           // low word, operand 1
        mul     WORD PTR [bp + 10]      // multiply by high word, operand 2
        add     bx, ax                  // add result to BX
        mov     ax, [bp + 04]           // low word, operand 1
        mul     cx                      // multiply high low word, operand 2
        add     dx, bx                  // add high word from BX
        pop     bx                      // restore BX register
        pop     bp                      // epilogue
        ret     0x0008                  // return
