/*----------------------------------------------------
   SORT16.C -- Bubble Sort Benchmark (16-Bit Version)
  ----------------------------------------------------*/

#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

void SortLongs (int iNum)
     {
     int          i, j ;
     long         lBegTime, lEndTime, lTemp ;
     long far *   lplArray ;
     long huge *  hplArray ;

     if (iNum <= 16384)
          {
          if (NULL == (lplArray = _fcalloc (iNum, sizeof (long))))
              {
              printf ("Cannot allocate array for %d items.\n", iNum) ;
              return ;
              }

          for (i = 0 ; i < iNum ; i++)
              lplArray [i] = (long) rand () * rand () ;

          lBegTime = time (NULL) ;

          for (i = 0     ; i < iNum - 1 ; i++)
          for (j = i + 1 ; j < iNum     ; j++)
               if (lplArray [i] > lplArray [j])
                  {
                  lTemp        = lplArray [i] ;
                  lplArray [i] = lplArray [j] ;
                  lplArray [j] = lTemp ;
                  }

          lEndTime = time (NULL) ;

          _ffree (lplArray) ;
          }
     else
          {
          if (NULL == (hplArray = halloc (iNum, sizeof (long))))
              {
              printf ("Cannot allocate array for %d items.\n", iNum) ;
              return ;
              }

          for (i = 0 ; i < iNum ; i++)
              hplArray [i] = (long) rand () * rand () ;

          lBegTime = time (NULL) ;

          for (i = 0     ; i < iNum - 1 ; i++)
          for (j = i + 1 ; j < iNum     ; j++)
              if (hplArray [i] > hplArray [j])
                  {
                  lTemp        = hplArray [i] ;
                  hplArray [i] = hplArray [j] ;
                  hplArray [j] = lTemp ;
                  }

          lEndTime = time (NULL) ;

          hfree (hplArray) ;
          }

     printf ("Elapsed time for %d items: %ld seconds.\n", iNum,
             lEndTime - lBegTime) ;
     }

int main (void)
     {
     SortLongs (16000) ;
     SortLongs (17000) ;

     return 0 ;
     }
